
#include "StableRecipeChecker.h"

StableRecipeChecker::StableRecipeChecker(BaseDevice* device, int delayTime, int checkTime)
{
	devices = device;
	setDelayTime = delayTime;
	setCheckTime = checkTime;
	status = StableRecipeStatusValue::Unused;
	elapsedCheckTime = elapsedDelayTime = 0;
}

StableRecipeChecker::~StableRecipeChecker()
{
}

void StableRecipeChecker::check()
{
	if (status == StableRecipeStatusValue::Unused)
		return;
	if (status==StableRecipeStatusValue::Delay && setDelayTime==0)
	{
		status = StableRecipeStatusValue::Check;
	}
	if (status == StableRecipeStatusValue::Delay && setDelayTime != 0)
	{
		elapsedDelayTime += TM;
		if (elapsedDelayTime>=setDelayTime)
		{
			status = StableRecipeStatusValue::Check;
			return;
		}
	}

	if (status==StableRecipeStatusValue::Check || status == StableRecipeStatusValue::Success|| status == StableRecipeStatusValue::Fail)
	{
		if (checkOnce())
		{
			if (setCheckTime<=0)
			{
				status = StableRecipeStatusValue::Success;
				return;
			}
			elapsedCheckTime += TM;

			if (elapsedCheckTime>=setCheckTime)
			{
				elapsedCheckTime = setCheckTime;
				status = StableRecipeStatusValue::Success;
				return;
			}

			if (elapsedCheckTime<setCheckTime)
			{
				status = StableRecipeStatusValue::Check;
				return;
			}
		}
		else
		{
			elapsedCheckTime = 0;
			status = StableRecipeStatusValue::Fail;
			return;
		}
	}

}

BOOL StableRecipeChecker::checkOnce() 
{
	BOOL result = true;

	return result;
}

int StableRecipeChecker::getStatus()
{
	//BOOL result = true;

	return (int)status;
}
void StableRecipeChecker::start()
{
	if (status!=StableRecipeStatusValue::Unused)
	{
		return;
	}
	else
	{
		status = StableRecipeStatusValue::Delay;
	}
}
void StableRecipeChecker::stop()
{
	status = StableRecipeStatusValue::Unused;
}