#pragma once
#include "Ads.h"
#include "AdsLog.h"
#include "TcBaseInterfaces.h"
#include<string>
#include<vector>
#include<map>
#include<time.h>
#include "RecipeStep.h"
#include "CommandCollection.h"


class RecipeStepManager
{
public:
	RecipeStepManager();
	~RecipeStepManager();

    bool InsertRecipeStepProcess(int stepIndex, RecipeStep recipeStep);

    bool InsertSubRecipeTable(int tableIndex, int stepIndex, RecipeStep recipeStep);
  

    bool InsertAbortRecipeTable(int tableIndex, int stepIndex, RecipeStep recipeStep);
 

    bool InsertAlarmRecipeTable(int tableIndex, int stepIndex, RecipeStep recipeStep);
  

    bool Clear();
 

    bool InsertRecipeCommands(int stepIndex, CommandCollection commandParas);


    bool InsertSubRecipeCommands(int tableIndex, int stepIndex, CommandCollection commandParas);


    bool InsertAlarmRecipeCommands(int tableIndex, int stepIndex, CommandCollection commandParas);


    bool Lock();




private:
   map<int, RecipeStep> _process;
   map<int, map<int, RecipeStep>> _sub;
   map<int, map<int, RecipeStep>> _alarm;
   map<int, map<int, RecipeStep>> _abort;

   map<int, CommandCollection> _mainCommand;
   map<int, map<int, CommandCollection>> _subCommand;
   map<int, map<int, CommandCollection>> _alarmCommand;
   map<int, map<int, CommandCollection>> _abortCommand;
    //private readonly ManualResetEvent IsLock = new(false);
};
