#ifndef _RECIPECONTEXT_H_
#define _RECIPECONTEXT_H_

#include "TcPch.h"
#pragma hdrstop

#include "Ads.h"
#include "AdsLog.h"
#include "TcBaseInterfaces.h"
#include<string>
#include<vector>
#include<map>
#include<time.h>
#include"RecipeStepInfo.h"
#include<TcInterfaces.h>
#include"Common.h"
#include"RecipeChecker.h"
#include"AlarmCondition.h"
#include"TempProfile.h"
#include"TempPID.h"
#include"TempCorrection.h"
#include"APCPID.h"
#include"LeakCheck.h"
#include"TcTimeConversion.h"
#include"EV.h"
#include"OP.h"
#include"Dictionary.h"
#include"List.h"


#define TM 100
#define MAX_MAIN_STEP_LIST 100
#define MAX_ALARMCONDITIONDIC1 120
#define MAX_TEMPPROFILEDIC 50
#define MAX_TEMPPIDDIC 10
#define MAX_TEMPCORRECTIONDIC 30
#define MAX_APCPIDDIC 30
#define MAX_LEAKCHECKDIC 30


using namespace std;

typedef enum class currentRecipeTypeValue
{
	NormalRecipe = 0,	//recipe
	SubRecipe,			//sub recipe
	AbortRecipe,		//abort recipe
	AlarmRecipe,		//alarm recipe
	ResetRecipe			//reset recipe
} currentRecipeTypeValue;

typedef enum class baseDataDownloadStatusValue
{
	Unknown=0,			//PMCʼ
	Ready,				//PMCʼɣ
	Done				//PMC
} baseDataDownloadStatusValue;

typedef enum class recipeDataDownloadStatusValue
{
	Unknown = 0,		//PMCʼ״̬recipeò
	Ready,				//PMCrecipeݶѾɳʼrecipeִִ֮лݣ״̬recipeò
	Done				//PMC½recipeò
} recipeDataDownloadStatusValue;

typedef enum class recipeExecuteStatusValue
{
	Unknown = 0,
	Idle,				//recipeִ
	ExecStep,			//ִstepstepڸտʼִеʱڴ״̬Ȼʼִstepָcommand̺ܿɣȻΪTimeWaitConditionWait
	TimeWait,			//ȴstepʱ䵽
	ConditionWait,		//ȴstep
	StepCompleted,		//ԭλУstepConditionWait㣬TimeWaitʱ䵽ܳ٣൱ڲ֧skipҼָ֮ıΪStepCompleted״̬һʱƬ״̬ExecStepһһʱƬжExecStepſʼִһһstepһstepʼʱƬʱĿǰδжԴ˵ĲʩPMCУ״̬Ǹ״̬ͬһʱƬڽһstepִ
	Paused,				//ִͣExecStepWait׶յPause֮󲻻ͣҲͣˣStepCompleted֮ж֮ǰǷյPauseԭλͨжPMMoudle.PuaseʵֵģPMCͨжյHoldյΪPausedʱstepָָһµstep
	Error,				//
	RecipeCompleted		//ȵõStepCompleted֮RecipeCompletedԭλһʱƬжRecipeCompletedĴdummyʹôĤʱ䣩PMCһʱƬ
} recipeExecuteStatusValue;


typedef enum class recipeExecuteCommandValue
{
	Default = 0,
	Abort,				//ǿ˳
	Reset,
	Hold,				//ͣ
	Release,			//
	Skip,				//һ
	Jump,				//ת
	Execute,			//ʼִ
	Clear				//ȫر־λ
						//ֻrecipeDataDownloadStatusDone״̬ʱRecipeִ
} recipeExecuteCommandValue;


struct RecipeStepMsgContext
{
public:
	int curRecipeType;
	int currentRecipeKey;
	RecipeStepInfo RecipeStep;
};


struct RecipeCheckerMsgContext
{
public:
	int curRecipeCheckerType;
	int currentRecipeCheckerKey1;
	int currentRecipeCheckerKey2;
	RecipeChecker RecipeChk;
};


struct AlarmConditionMsgContext
{
public:
	int currentAlarmConditionKey1;
	char currentAlarmConditionKey2[100];
	AlarmCondition AlarmCdt;
};


struct TempProfileMsgContext
{
public:
	int currentTempProfileKey1;
	char currentTempProfileKey2[100];
	TempProfile TempPrf;
};

struct TempPIDMsgContext
{
public:
	int currentTempPIDKey1;
	char currentTempPIDKey2[100];
	TempPID TmpPID;
};


struct TempCorrectionMsgContext
{
public:
	int currentTempCorrectionKey1;
	char  currentTempCorrectionKey2[100];
	TempCorrection TmpCorrection;
};


struct APCPIDMsgContext
{
public:
	int currentAPCPIDKey1;
	char currentAPCPIDKey2[100];
	APCPID _apcpid;
};


struct LeakCheckMsgContext
{
public:
	int currentLeakCheckKey1;
	char currentLeakCheckKey2[100];
	LeakCheck Lkc;
};




class RecipeContext
{
public:
	//ȡ
	static RecipeContext* GetInstance();
	//static RecipeContext* GetInstanceSetLog(CTcTrace* _cTrack);
	//ͷŵ˳ʱ
	static void deleteInstance();
	//static	CTcTrace* cTrack;
	//vector <RecipeStepInfo> mainStepList;
	//map<int, vector<RecipeStepInfo>> subStepListMap;  //sub recipeձ
	//map<int, vector<RecipeStepInfo>> abortStepListMap;//	abort recipeձ
	//map<int, vector<RecipeStepInfo>> alarmStepListMap;//	alarm recipeձ
	List<RecipeStepInfo, MAX_MAIN_STEP_LIST> mainStepList;
	int mainStepListStepCount;
	Dictionary<List<RecipeStepInfo,50>, 20> subStepListMap;

	Dictionary<List<RecipeStepInfo,50>,20> abortStepListMap;//	abort recipeձ
	Dictionary<List<RecipeStepInfo,50>,20> alarmStepListMap;//	alarm recipeձ

	BOOL   isPaused;		// ǰͣ־


	long  elapsedTotalTime;	//ʱ
	long  elapsedStepTime;		//ǰstepʱ
	long  remainTotalTime;		//ʣʱ
	long  remainStepTime;		//ǰstepʣʱ
	long  holdTotalTime;		//holdʱ
	long  holdStepTime;			//ǰstep holdʱ
	long  startTime;			//ʼִʱ
	int i = 0;
	int Moniter();
	
	int currentStepNo;		//ǰrecipeָ
	BOOL isJobRecipe;			//ǷjobrecipeǷִstandby

	currentRecipeTypeValue currentRecipeType;
		//NormalRecipe		recipe
		//SubRecipe		sub recipe
		//AbortRecipe		abort recipe
		//AlarmRecipe		alarm recipe
		//ResetRecipe		reset recipe

	int currentOtherStepNo;	//sub/abort/alarm/resetrecipeִָ
	int currentOtherRecipeKey;	//sub/abort/alarm/resetrecipeıkey
	List<RecipeChecker,10> checkerList;
	Dictionary<Dictionary<AlarmCondition, MAX_ALARMCONDITIONDIC1>, MAX_ALARMCONDITIONDIC1> alarmConditionDic;
	Dictionary<Dictionary<TempProfile, MAX_TEMPPROFILEDIC>, MAX_TEMPPROFILEDIC> tempProfileDic;
	Dictionary<Dictionary<TempPID, MAX_TEMPPIDDIC>, MAX_TEMPPIDDIC> tempPIDDic;
	Dictionary<Dictionary<TempCorrection,MAX_TEMPCORRECTIONDIC>,MAX_TEMPCORRECTIONDIC> tempCorrectionDic;
	Dictionary<Dictionary<APCPID, MAX_APCPIDDIC>, MAX_APCPIDDIC> apcPIDDic;
	Dictionary<Dictionary<LeakCheck, MAX_LEAKCHECKDIC>, MAX_LEAKCHECKDIC> leakCheckDic;
	
	baseDataDownloadStatusValue baseDataDownloadStatus;
	//baseDataDownloadStatus£
	//	Unknown		PMCʼ
	//	Ready		PMCʼɣ
	//	Done		PMC

	recipeDataDownloadStatusValue  recipeDataDownloadStatus;
	//recipeDataDownloadStatus£
	//	Unknown		PMCʼ״̬recipeò
	//	Ready		PMCrecipeݶѾɳʼrecipeִִ֮лݣ״̬recipeò
	//	Done		PMC½recipeò

	recipeExecuteStatusValue recipeExecuteStatus;
	//recipeExecuteStatus£
	//	Idle	recipeִ
	//	ExecStep	ִstepstepڸտʼִеʱڴ״̬Ȼʼִstepָcommand̺ܿɣȻΪTimeWaitConditionWait
	//	TimeWait	ȴstepʱ䵽
	//	ConditionWait	ȴstep
	//	StepCompleted	ԭλУstepConditionWait㣬TimeWaitʱ䵽ܳ٣൱ڲ֧skipҼָ֮ıΪStepCompleted״̬һʱƬ״̬ExecStepһһʱƬжExecStepſʼִһһstepһstepʼʱƬʱĿǰδжԴ˵ĲʩPMCУ״̬Ǹ״̬ͬһʱƬڽһstepִ
	//	Paused	ִͣExecStepWait׶յPause֮󲻻ͣҲͣˣStepCompleted֮ж֮ǰǷյPauseԭλͨжPMMoudle.PuaseʵֵģPMCͨжյHoldյΪPausedʱstepָָһµstep
	//	Error	
	//	RecipeCompleted	ȵõStepCompleted֮RecipeCompletedԭλһʱƬжRecipeCompletedĴdummyʹôĤʱ䣩PMCһʱƬ

	recipeExecuteCommandValue recipeExecuteCommand;
		//recipeExecuteCommand£
		//Default
		//Abort  		ǿ˳
		//Reset
		//Hold			ͣ
		//Release		
		//Skip			һ
		//Jump		ת
		//Execute		ʼִ
		//Clear		ȫر־λ
		//ֻrecipeDataDownloadStatusDone״̬ʱRecipeִ



	BOOL isFinished();
	//int getCurrentRecipeType(); //ǰrecipe
	BOOL next();
	BOOL previous();
	BOOL skip();
	BOOL jumpTo(string toStepName);

	void pause();
	void updateTime(BOOL newStep);
	string* getCommandParam(string command);
	string getCurrentStepName();	//stepƣԶʶreciperecipe
	int getCurrentRecipeType();	//ǰrecipe
	int getCurrentStepNo();		//0ʼrecipeĲ
	int getCurrentOtherStepNo();	//0ʼreciperecipeĲ
	RecipeStepInfo* getCurrentStepInfo();	//ԶʶreciperecipestepϢ
	double getStepTime();			//step ʱ
	int getElapsedTotalTime();	//Ѿŵʱ
	int getElapsedStepTime();	//Ѿŵĵǰִʱ
	int getRemainTotalTime();	//ܼʣʱ
	int getRemainStepTime();	//ǰʣִʱ
	int getHoldTotalTime();	//ܼƵͣʱ
	int getHoldStepTime();		//ǰͣʱ
	int getStartTime();		//ʼִʱ

	void executeStep();

	//int TM = 100;
	void ParseDataWithRawData();
	void PackageDataAndSendBufferData();

	char* CovertIntToChar(int key);
	void ClearDicAndLisrData();
	char* getRawData(char* buffer, int bufferSize);
public:
	RecipeContext();
	~RecipeContext();

	//RecipeContext(const RecipeContext& recipecont);
	//const RecipeContext& operator=(const RecipeContext& recipecont);

	//static RecipeContext* g_pRecipeContext;
	static void SetCTcTrace(CTcTrace* _cTrack);
#pragma region Recipe

	BOOL parseMainRecipe(string json);
	BOOL parseSubRecipe(string json);
	BOOL parseAbortRecipe(string json);
	BOOL parseAlarmRecipe(string json);
	BOOL parseAlarmCondition(string json);
	BOOL parseTempProfile(string json);
	BOOL parseTempPID(string json);
	BOOL parseTempCorrection(string json);
	BOOL parseApcPID(string json);
	BOOL parseLeakCheck(string json);

#pragma endregion
	
	
	BOOL judgeStep();
	/*************************************************
	 * @brief СֽbyteתΪֽ
	 * @param data byte飨С˸ʽ
	 * @param length 鳤
	 **************************************************/
	void ConvertLittleEndianToBigEndian_(uint8_t* data, size_t length)
	{
		for (size_t i = 0; i < length / 2; ++i) {
			std::swap(data[i], data[length - 1 - i]);
		}
	}

	/**************************************************
	 * @brief ذ汾ֱӴstd::vector<uint8_t>
	 * @param data byte飨С˸ʽ
	 ***************************************************/
	void ConvertLittleEndianToBigEndian(std::vector<uint8_t>& data)
	{
		ConvertLittleEndianToBigEndian_(data.data(), data.size());
	}

};

#endif