#ifndef _PARAMETERMANAGER_H_
#define _PARAMETERMANAGER_H_

#include "Ads.h"
#include "AdsLog.h"
#include "TcBaseInterfaces.h"
#include<string>
#include<vector>
#include<map>
#include<time.h>
#include "AlarmCondition.h"
#include "TempPID.h"
#include "APCPID.h"
#include "LeakCheck.h"
#include "TempProfile.h"
#include "TempCorrection.h"

using namespace std;

class ParameterManager
{
public:
	ParameterManager();
	~ParameterManager();

    bool InsertAPCParameter(int key, vector<AlarmCondition> conditions);


    bool InsertAUXParameter(int key, vector<AlarmCondition> conditions);


    bool InsertAUXParameter(int key, AlarmCondition condition);


    bool InsertHeaterParameter(int key, vector<AlarmCondition> conditions);
 
    bool InsertMFCParameter(int key, vector<AlarmCondition> conditions);



    bool InsertAPCPID(int key, APCPID aPCPID);



    bool InsertLeakCheck(int key, LeakCheck leakCheck);



    bool InsertTempPID(int key, vector<TempPID> tempPIDs);


    bool InsertTempProfile(int key, vector<TempProfile> tempProfiles);


    bool InsertTempCorrection(int key, vector<TempCorrection> tempCorrections);


    bool Clear();


    bool Lock();
 


private:
   map<int, map<string, AlarmCondition>> _mfcConditions ;
   map<int, map<string, AlarmCondition>> _heaterConditions ;
   map<int, map<string, AlarmCondition>> _apcConditions ;
   map<int, map<string, AlarmCondition>> _auxConditions ;

   map<int, map<string, TempPID>> _tempPIDs ;
   map<int, map<string, TempProfile>> _tempProfiles ;
   map<int, map<string, TempCorrection>> _tempCorrections ;

   map<int, APCPID> _apCPIDs ;
   map<int, LeakCheck> _leakCheck ;

    //private readonly ManualResetEvent IsLock = new(false);
};


#endif // !_PARAMETERMANAGER_H_
