#ifndef __OP_H__
#define __OP_H__

#include"pmc_types.h"
#include"Fields.h"
#include"Dictionary.h"
#include"TriggerStatus.h"
typedef enum class _OperatorStatusEnum {UNDEFINED,INIT,RUNNING,SUCCESS,ALARM,ABORT} OperatorStatusEnum;
typedef TriggerStatus<OperatorStatusEnum> OperatorStatus;
typedef OperatorStatusEnum (*OperatorFunctionPtr)();
typedef OperatorFunctionPtr OperatorCheckFunctionPtr;
typedef OperatorFunctionPtr OperatorCallbackFunctionPtr;
class OperatorNode {
private:
    OperatorCheckFunctionPtr preCheckFunction=NULL;
    OperatorFunctionPtr      execFunction = NULL;
    OperatorCheckFunctionPtr checkFunction = NULL;
    OperatorCheckFunctionPtr alarmCheckFunction = NULL;
    OperatorCallbackFunctionPtr alarmCallbackFunction = NULL;
    //About Setting parameters of times
    long setDelayTime=200;
    long setStableTime=500;
    long setTriggerAlarmTime=500;
    //About elapsewd times
    long elapsedDelayTime=0;
    long elapsedStableTime=0;
    long elapsedTriggerAlarmTime=0;
    
    PMCBOOL isInDelay = FALSE;
    OperatorNode* subOpList[MAX_SUB_OP_COUNT] = { 0 };
    short subOpCount=0;
    short subOpIndex=0;
    void setParamsAndTimes_a(const char* paramString, long delayTime, long stableTime, long triggerAlarmTime);
    void doSimpleOperation();
    void simpleMonitor();
    void doOperation();
    
public:
    char name[MAX_NAME_LEN] = { 0 };
    Fields<MAX_PARAM_COUNT> params;
    short paramsCount=0;
    OperatorStatus status=OperatorStatusEnum::INIT;
    
    //char  alarmText[MAX_CONTEXT_LEN]; ϢŵOPУʡռ
    //preserved alarm method
    unsigned char confirm=0;
    unsigned char method=0;
public:
    OperatorNode();
    void reset();
    void subscribe(const char* name);
    void subscribe(const char* name, OperatorFunctionPtr execFunction);
    void subscribe(const char* name, OperatorFunctionPtr execFunction,OperatorCheckFunctionPtr preCheckFunction);
    void subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction);
    void subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction,OperatorCheckFunctionPtr alarmCheckFunction);
    void subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction, OperatorCheckFunctionPtr alarmCheckFunction,OperatorCallbackFunctionPtr alarmCallbackFunction);
    void addExec(OperatorFunctionPtr function);
    void addPreCheck(OperatorCheckFunctionPtr function);
    void addCheck(OperatorCheckFunctionPtr function);
    void addAlarmCheck(OperatorCheckFunctionPtr function);
    void addAlarmCallback(OperatorCallbackFunctionPtr function);
    //öŷָNULLʾȡĬϣʱС0ʾȡĬ
    OperatorNode* setParamsAndTimes(const char* paramString=0,long delayTime=-1, long stableTime=-1, long triggerAlarmTime=-1);


    //add sub op
    OperatorNode* addChild();

    //about run time
    void Do();
    void monitor();
    void clearAlarm();
};

class COP{
    private:
        //COP();
        Dictionary<OperatorNode,MAX_OP_COUNT> opTree;
        OperatorNode subOpArray[TOTAL_SUB_OP_COUNT];
        int subOpLength=0;
        friend OperatorNode;
    public:
        OperatorNode* current=NULL;
        OperatorNode* currentRoot=NULL;
        PMCBOOL isAborted=FALSE;
        char  alarmText[MAX_CONTEXT_LEN];
    public:
         
        OperatorNode* subscribe(const char* name);
        OperatorNode* subscribe(const char* name, OperatorFunctionPtr execFunction);
        OperatorNode* subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction);
        OperatorNode* subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction);
        OperatorNode* subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction, OperatorCheckFunctionPtr alarmCheckFunction);
        OperatorNode* subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction, OperatorCheckFunctionPtr alarmCheckFunction, OperatorCallbackFunctionPtr alarmCallbackFunction);
        //nameOperatorNode
        OperatorNode* select(const char* name);
        OperatorStatusEnum monitor();
        //about alarm deal method
        
        void alarm();
        void clearAlarm(const char *opName=NULL);
        void abort();
       
        //ҪOPίкеreset        
        void reset();
        
        
};
extern COP* OP;
#endif
