/**
 *
 * @author    seagle
 * @date      2025-3-21
 * @Description 
 *   Replace old OP
 */  
#include"TcPch.h"
#pragma hdrstop
#include"OP.h"
#include"errcode.h"
#include"EV.h"
#include"debug.h"
COP* OP;

/**
* Do not use this function twice in one sentence!!!!!!
*/
static char* describeOperatorStatus(OperatorStatus status) {
	static char buffer[10];
	switch (status.value) {
	case OperatorStatusEnum::UNDEFINED:
		strcpy (buffer, "Undefined");
		break;
	case OperatorStatusEnum::INIT:
		strcpy (buffer, "Init");
		break;
	case OperatorStatusEnum::SUCCESS:
		strcpy (buffer, "Success");
		break;
	case OperatorStatusEnum::RUNNING:
		strcpy (buffer, "Running");
		break;
	case OperatorStatusEnum::ALARM:
		strcpy (buffer, "Alarm");
		break;
	default:
		sprintf(buffer, "%d", (int)status.value);
	}
	return buffer;
}
OperatorNode::OperatorNode()
{
	memset(&params, '\0', sizeof(params));
}

void OperatorNode::reset()
{
	
	elapsedDelayTime = elapsedStableTime = elapsedTriggerAlarmTime = 0;
	isInDelay = FALSE;
	status = OperatorStatusEnum::INIT;
	subOpIndex = 0;
	confirm = 0;
	method = 0;
	paramsCount = 0;

	for (int i = 0; i < subOpCount;i++) {
		subOpList[i]->reset();		
	}
}
OperatorNode * OperatorNode::setParamsAndTimes(const char* paramString, long delayTime, long stableTime, long triggerAlarmTime)
{
	/*
	  ΪexeccheckһʱƬĲ࣬delayTimeʵֵΪĶһʱƬнԸǵϰ
	*/
	if (delayTime >= 0) {
		delayTime -= TASK_TM;
		if (delayTime < 0) {
			delayTime = 0;
		}
	}
	setParamsAndTimes_a(paramString, delayTime, stableTime, triggerAlarmTime);
	return this;
	
}
void OperatorNode::setParamsAndTimes_a(const char* paramString, long delayTime, long stableTime, long triggerAlarmTime)
{
	if (paramString != NULL) {
		this->params.parse(paramString, ',');
	}
	
	if (delayTime >= 0) {
		this->setDelayTime = delayTime;
	}
	if (stableTime >= 0) {
		this->setStableTime = stableTime;
	}
	if (triggerAlarmTime >= 0) {
		this->setTriggerAlarmTime = triggerAlarmTime;
	}

	for (int i = 0; i < subOpCount; i++) {
		subOpList[i]->setParamsAndTimes_a(paramString, delayTime, stableTime, triggerAlarmTime);
	}

}


void OperatorNode::subscribe(const char* name)
{
	strcpy (this->name , name);
}

void OperatorNode::subscribe(const char* name, OperatorFunctionPtr execFunction)
{
	strcpy (this->name , name);
	this->execFunction = execFunction;
}

void OperatorNode::subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction)
{
	strcpy (this->name , name);
	this->execFunction = execFunction;
	this->preCheckFunction = preCheckFunction;
}

void OperatorNode::subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction)
{
	strcpy (this->name , name);
	this->execFunction = execFunction;
	this->preCheckFunction = preCheckFunction;
	this->checkFunction = checkFunction;
}

void OperatorNode::subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction, OperatorCheckFunctionPtr alarmCheckFunction)
{
	strcpy (this->name , name);
	this->execFunction = execFunction;
	this->preCheckFunction = preCheckFunction;
	this->checkFunction = checkFunction;
	this->alarmCheckFunction = alarmCheckFunction;
}

void OperatorNode::subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction, OperatorCheckFunctionPtr alarmCheckFunction, OperatorCallbackFunctionPtr alarmCallbackFunction)
{
	strcpy (this->name , name);
	this->execFunction = execFunction;
	this->preCheckFunction = preCheckFunction;
	this->checkFunction = checkFunction;
	this->alarmCheckFunction = alarmCheckFunction;
	this->alarmCallbackFunction = alarmCallbackFunction;
}

void OperatorNode::addExec(OperatorFunctionPtr function)
{
	this->execFunction = function;	
	
	
}

void OperatorNode::addPreCheck(OperatorCheckFunctionPtr function)
{
	this->preCheckFunction = function;
	for (int i = 0; i < subOpCount; i++) {
		subOpList[i] = NULL;
	}
	subOpCount = 0;
}

void OperatorNode::addCheck(OperatorCheckFunctionPtr function)
{
	this->checkFunction = function;
	for (int i = 0; i < subOpCount; i++) {
		subOpList[i] = NULL;
	}
	subOpCount = 0;
}

void OperatorNode::addAlarmCheck(OperatorCheckFunctionPtr function)
{
	this->alarmCheckFunction = function;
	for (int i = 0; i < subOpCount; i++) {
		subOpList[i] = NULL;
	}
	subOpCount = 0;
}

void OperatorNode::addAlarmCallback(OperatorCallbackFunctionPtr function)
{
	this->alarmCallbackFunction = function;
}

OperatorNode* OperatorNode::addChild()
{
	//execFunction = NULL;
	preCheckFunction = checkFunction = alarmCallbackFunction = NULL;
	//alarmCallbackFunction = NULL;
	OperatorNode* node = &OP->subOpArray[OP->subOpLength++];
	*node = OperatorNode();//ù캯
	subOpList[subOpCount++] = node;
	return node;
}



void OperatorNode::doSimpleOperation()
{
	if (OP->isAborted) {
		return;
	}
	OP->current = this;
	if (OP->currentRoot == NULL) {
		return;
	}
	if (status != OperatorStatusEnum::INIT) {
		char* err = EV->parseErrCode(ALARM_OP_STATUS, "name=%s;expect=Init;real=%s", name, describeOperatorStatus(status));
		strcpy (OP->alarmText ,err);
		status = OperatorStatusEnum::ALARM;
		//EV->postAlarmLog(alarmText); called by alarm deal method
		return;
	}
	elapsedDelayTime = elapsedStableTime =elapsedTriggerAlarmTime= 0;
	isInDelay = FALSE;
	if (preCheckFunction != NULL) {
		OperatorStatusEnum preCheckStatus = preCheckFunction();
		if (preCheckStatus != OperatorStatusEnum::SUCCESS) {
			status = OperatorStatusEnum::ALARM;
			char *err= EV->parseErrCode(ALARM_OP_PRECHECK, "name=%s" , name );
			strcpy (OP->alarmText, err);
			//EV->postAlarmLog(alarmText);called by alarm deal method
			if (alarmCallbackFunction != NULL) {
				alarmCallbackFunction();
			}
			else {
				OP->alarm();
			}
			return;
		}
	}
	if (execFunction == NULL) {
		status = OperatorStatusEnum::ALARM;
		char *err = EV->parseErrCode(ALARM_OP_NOT_EXIST, "name=%s" , name);
		strcpy (OP->alarmText, err);
		//EV->postAlarmLog(alarmText);called by alarm deal method
		if (alarmCallbackFunction != NULL) {
			alarmCallbackFunction();
		}
		else {
			OP->alarm();
		}
		return;
	}
	OperatorStatusEnum execStatus = execFunction();
	if (execStatus == OperatorStatusEnum::ALARM) {
		status = OperatorStatusEnum::ALARM;
		//alamText set in exec function
		//alarmText = EV->parseErrCode(ALARM_OP_NOT_EXIST, "name=" + name);
		//EV->postAlarmLog(alarmText);called by alarm deal method
		if (alarmCallbackFunction != NULL) {
			alarmCallbackFunction();
		}
		else {
			OP->alarm();
		}
		return;
	}
	else if (execStatus == OperatorStatusEnum::SUCCESS||execStatus== OperatorStatusEnum::INIT) {
		//actual there can not be SUCCESS,only be INIT
		status = OperatorStatusEnum::INIT;
		return;
	}
	else if (execStatus == OperatorStatusEnum::RUNNING) {
		status = OperatorStatusEnum::RUNNING;
		isInDelay = TRUE;
	}
}

void OperatorNode::simpleMonitor()
{
	if (OP->isAborted) {
		return;
	}
	OP->current = this;
	if (status != OperatorStatusEnum::SUCCESS && status != OperatorStatusEnum::RUNNING) {
		return;
	}
	if (isInDelay && setDelayTime == 0) {
		isInDelay = FALSE;
	}
	else if (isInDelay && setDelayTime > 0) {
		elapsedDelayTime += TASK_TM;
		if (elapsedDelayTime > setDelayTime) {
			isInDelay = FALSE;
		}
		else {
			return;	//in delay time
		}
	}
	//from here, delay is over
	if (alarmCheckFunction != NULL) {
		OperatorStatusEnum alarmStatus = alarmCheckFunction();
		if (alarmStatus == OperatorStatusEnum::ALARM) {
			elapsedTriggerAlarmTime += TASK_TM;
			if (elapsedTriggerAlarmTime > setTriggerAlarmTime) {
				elapsedTriggerAlarmTime = setTriggerAlarmTime;
				status = OperatorStatusEnum::ALARM;
				if (alarmCallbackFunction != NULL) {
					alarmCallbackFunction();
				}
				else {
					OP->alarm();
				}
				return;
			}
			
		}
		else {
			//alarm not trigger
			elapsedTriggerAlarmTime = 0;
		}
	}
	if (checkFunction != NULL) {
		OperatorStatusEnum checkStatus =checkFunction();
		if (checkStatus == OperatorStatusEnum::RUNNING) {
			elapsedStableTime = 0;
			status = OperatorStatusEnum::RUNNING;
			return;
		}
		else if (checkStatus == OperatorStatusEnum::SUCCESS) {
			if (setStableTime == 0) {
				status = OperatorStatusEnum::SUCCESS;
				return;
			}
			else {
				elapsedStableTime += TASK_TM;
				if (elapsedStableTime > setStableTime) {
					elapsedStableTime = setStableTime;
					status = OperatorStatusEnum::SUCCESS;
					return;
				}
				else {
					status = OperatorStatusEnum::RUNNING;
				}
			}
		}
		else if (checkStatus == OperatorStatusEnum::ALARM) {
			status = OperatorStatusEnum::ALARM;
			if (alarmCallbackFunction != NULL) {
				alarmCallbackFunction();
			}
			else {
				OP->alarm();
			}
		}

	}

}

void OperatorNode::doOperation()
{
	if (OP->isAborted) {
		return;
	}
	if (subOpCount == 0 && execFunction != NULL) {
		//simple operate
		doSimpleOperation();
		return;
	}
	if (subOpCount == 0) {
		return;	//should not be here
	}
	if (status != OperatorStatusEnum::INIT) {
		char *err = EV->parseErrCode(ALARM_OP_STATUS, "name=%s;expect=Init;real=" ,name, describeOperatorStatus(status));
		strcpy (OP->alarmText, err);
		status = OperatorStatusEnum::ALARM;
		if (alarmCallbackFunction != NULL) {
			alarmCallbackFunction();
		}
		else {
			OP->alarm();
		}
		return;
	}
	if (execFunction != NULL) {
		//execķֵ϶execίֻ򵥵ļ׼ܳ
		execFunction();
		
	}
	
	if (OP->isAborted) {
		return;
	}
	for (int index = 0; index < subOpCount;index++) {
		if (OP->isAborted) {
			return;
		}
		if (index == subOpIndex) {
			OperatorNode* subOp = subOpList[index];
			OperatorStatusEnum subExecStatus;
			subOp->doOperation();
			subExecStatus = subOp->status.value;
			
			if (subExecStatus == OperatorStatusEnum::ALARM) {
				status = OperatorStatusEnum::ALARM;
				subOp->status = OperatorStatusEnum::ALARM;
				break;
			}
			else if (subExecStatus == OperatorStatusEnum::INIT) {
				//continue;
			}
			else {
				status = OperatorStatusEnum::RUNNING;
				subOp->status = OperatorStatusEnum::RUNNING;
				break;
			}

			subOpIndex++;
		}
		
	}

}

void OperatorNode::Do()
{
	if (OP->isAborted) {
		return;
	}
	OP->currentRoot = this;
	doOperation();
}

void OperatorNode::monitor()
{
	if (OP->isAborted) {
		return;
	}
	if (subOpCount== 0 && execFunction != NULL) {
		//simple operate
		simpleMonitor();
		return;
	}
	if (subOpCount == 0) {
		return;	//should not be here
	}
	if (status != OperatorStatusEnum::RUNNING) {
		return;
	}
	
	for (int index = 0; index < subOpCount;index++) {
		if (index == subOpIndex) {
			OperatorNode* subOp = subOpList[index];
			OperatorStatusEnum subTestStatus;
			if (subOp->status == OperatorStatusEnum::INIT) {
				subOp->doOperation();
			}
			else {
				subOp->monitor();
			}
			if (OP->isAborted) {
				return;
			}
			subTestStatus = subOp->status.value;
			if (subTestStatus == OperatorStatusEnum::ALARM) {
				status = OperatorStatusEnum::ALARM;
				break;
			}
			else if (subTestStatus == OperatorStatusEnum::INIT) {

			}
			else if (subTestStatus == OperatorStatusEnum::SUCCESS) {
				if (subOpIndex == subOpCount - 1) {
					//last is success
					status = OperatorStatusEnum::SUCCESS;
					break;
				}
				else {
					status = OperatorStatusEnum::RUNNING;
					
				}
			}
			else {
				//sub op is running
				status = OperatorStatusEnum::RUNNING;
				break;
			}
			subOpIndex++;
		}
		
	}
}

void OperatorNode::clearAlarm()
{
	if (OP->isAborted) {
		return;
	}
	if (status != OperatorStatusEnum::ALARM) {
		return;
	}
	if (subOpCount == 0) {
		//򵥶
		this->reset();
		doSimpleOperation();
		return;
	}
	//Ӷ
	status = OperatorStatusEnum::INIT;
	for (int index = 0; index < subOpCount; index++) {
		if (OP->isAborted) {
			return;
		}
		if (index == subOpIndex) {
			OperatorNode* subOp = subOpList[index];
			OperatorStatusEnum subExecStatus;
			subOp->clearAlarm();
			subExecStatus = subOp->status.value;
			
			if (subExecStatus == OperatorStatusEnum::ALARM) {
				status = OperatorStatusEnum::ALARM;
				subOp->status = OperatorStatusEnum::ALARM;
				break;
			}
			else if (subExecStatus == OperatorStatusEnum::INIT) {
				//continue;
			}
			else {
				status = OperatorStatusEnum::RUNNING;
				subOp->status = OperatorStatusEnum::RUNNING;
				break;
			}

			subOpIndex++;
		}

	}
}





OperatorNode* COP::subscribe(const char* name)
{
	static OperatorNode operatorNode;
	strcpy (operatorNode.name, name);
	opTree.set(name, operatorNode,__FILE__,__LINE__);
	OperatorNode* node = opTree.get(name);
	
	return node;
}

OperatorNode* COP::subscribe(const char* name, OperatorFunctionPtr execFunction)
{
	OperatorNode* node = subscribe(name);
	node->addExec(execFunction);
	return node;
}

OperatorNode* COP::subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction)
{
	OperatorNode* node = subscribe(name);
	node->addExec(execFunction);
	node->addPreCheck(preCheckFunction);
	return node;
}

OperatorNode* COP::subscribe(const char * name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction)
{
	OperatorNode* node = subscribe(name);
	node->addExec(execFunction);
	node->addPreCheck(preCheckFunction);
	node->addCheck(checkFunction);
	return node;
}

OperatorNode* COP::subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction, OperatorCheckFunctionPtr alarmCheckFunction)
{

	OperatorNode* node = subscribe(name);
	node->addExec(execFunction);
	node->addPreCheck(preCheckFunction);
	node->addCheck(checkFunction);
	node->addAlarmCheck(alarmCheckFunction);
	return node;
}

OperatorNode* COP::subscribe(const char* name, OperatorFunctionPtr execFunction, OperatorCheckFunctionPtr preCheckFunction, OperatorCheckFunctionPtr checkFunction, OperatorCheckFunctionPtr alarmCheckFunction, OperatorCallbackFunctionPtr alarmCallbackFunction)
{
	OperatorNode* node = subscribe(name);
	node->addExec(execFunction);
	node->addPreCheck(preCheckFunction);
	node->addCheck(checkFunction);
	node->addAlarmCheck(alarmCheckFunction);
	node->addAlarmCallback(alarmCallbackFunction);
	return node;
}

OperatorNode* COP::select(const char* name)
{
	OperatorNode* node = opTree.get(name);
	if (node == NULL) {
		node = opTree.get("default");
		if (node == NULL) {
			char* err = EV->parseErrCode(ALARM_OP_NOT_EXIST, "name=%s;", name);
			strcpy(alarmText, err);
			EV->postAlarmLog(alarmText);
			return NULL;
		}
		node->setParamsAndTimes(name);
	}
	return node;
}



OperatorStatusEnum COP::monitor()
{
	if (isAborted) {
		return OperatorStatusEnum::ABORT;
	}
	OperatorStatusEnum result = OperatorStatusEnum::SUCCESS;
	
	for (int index = 0; index < opTree.length;index++) {
		if (isAborted) {
			return OperatorStatusEnum::ABORT;
		}
		OperatorNode* op = opTree.getByIndex(index);
		if (op->status == OperatorStatusEnum::INIT) {
			continue;
		}
		OP->currentRoot = op;
		if (op->status == OperatorStatusEnum::SUCCESS || op->status == OperatorStatusEnum::RUNNING) {
			op->monitor();
			if (OP->isAborted) {
				return OperatorStatusEnum::ABORT;
			}
		}
		if (op->status == OperatorStatusEnum::INIT || op->status == OperatorStatusEnum::SUCCESS) {
			continue;
		}
		else if (op->status == OperatorStatusEnum::ALARM) {
			result = OperatorStatusEnum::ALARM;
			//abortֹͣжalarmֹֻͣǰ
			//break;
		}
		else {
			if (result == OperatorStatusEnum::SUCCESS) {
				result = OperatorStatusEnum::RUNNING;
			}
			
		}
	}
	return result;

}




void COP::abort()
{
	OP->isAborted = TRUE;

}

void COP::alarm()
{
	
	EV->postAlarmLog(OP->alarmText);
}

void COP::clearAlarm(const char *opName)
{
	OperatorNode* op = NULL;
	if (opName != NULL) {
		op= OP->opTree.get(opName);
	}
	if (op == NULL) {
		op = OP->currentRoot;
	}
	if (op == NULL) {
		return;
	}
	op->clearAlarm();
}

void COP::reset()
{
	
	for (int index = 0; index < opTree.length;index++) {
		opTree.getByIndex(index)->reset();
	}
	current = currentRoot = NULL;
	isAborted = FALSE;
}

