///////////////////////////////////////////////////////////////////////////////
// Main.h
#ifndef _MAIN_H_
#define _MAIN_H_


#include "FurancePMCInterfaces.h"
#include"CRemoteLog.h"

//#include "RecipeContext.h"

class CMain 
	: public ITComObject
	, public ITcADI
	, public ITcWatchSource
///<AutoGeneratedContent id="InheritanceList">
	, public ITcCyclic
	, public ITcIoTcpProtocolRecv
///</AutoGeneratedContent>
{
public:
	DECLARE_IUNKNOWN()
	DECLARE_IPERSIST(CID_FurancePMCCMain)
	DECLARE_ITCOMOBJECT_LOCKOP()
	DECLARE_ITCADI()
	DECLARE_ITCWATCHSOURCE()
	DECLARE_OBJPARAWATCH_MAP()
	DECLARE_OBJDATAAREA_MAP()

	CMain();
	virtual	~CMain();


///<AutoGeneratedContent id="InterfaceMembers">
	// ITcCyclic
	virtual HRESULT TCOMAPI CycleUpdate(ITcTask* ipTask, ITcUnknown* ipCaller, ULONG_PTR context);

	// ITcIoTcpProtocolRecv
	virtual HRESULT TCOMAPI ReceiveData(ULONG socketId, ULONG nData, PVOID pData);
	virtual HRESULT TCOMAPI ReceiveEvent(ULONG socketId, TCPIP_EVENT tcpEvent);

///</AutoGeneratedContent>
	 HRESULT  SendClientData(ULONG socketId, ULONG nData, PVOID pData, ULONG& nSendData);
	 HRESULT  SendData();
	 HRESULT  PackgeTLVData(ULONG socketId, ULONG nData, PVOID pData);
	 HRESULT  UnpackgeTLVData(ULONG socketId, ULONG nData, PVOID pData);

	 //VOID ClearQueue(queue<vector<BYTE>>& q);

	 VOID RemoveAllQueue();
protected:
	DECLARE_ITCOMOBJECT_SETSTATE();




	HRESULT AddModuleToCaller();
	VOID RemoveModuleFromCaller();


	ULONG     Connect_SockId;
	ULONG     TagIDLength;
	ULONG     RequestIDLength;


	// Tracing
	CTcTrace m_Trace;
	CRemoteLog m_RemoteLog;

	ULONG     m_SockId;
	BOOL m_bSendRequest;  //set by debugger for sending a http command
	ULONG m_connections;  //count number of connection attempts
	HRESULT m_hrSend;     //Last hr of SendData

///<AutoGeneratedContent id="Members">
	TcTraceLevel m_TraceLevelMax;
	MainParameter m_Parameter;
	USHORT m_TcpServerPort;
	IPADDR m_TcpServerIpAddress;
	IPADDR m_LocalHost;
	MainInputs m_Inputs;
	MainOutputs m_Outputs;
	ITcCyclicCallerInfoPtr m_spCyclicCaller;
	ITcIoTcpProtocolPtr m_spIpTcp;
///</AutoGeneratedContent>

	// TODO: Custom variable
	UINT m_counter;

	
};


#endif // !_MAIN_H_
