///////////////////////////////////////////////////////////////////////////////
// Main.cpp
#include "TcPch.h"
#pragma hdrstop

#include "Main.h"
#include "RecipeContext.h"
#include"Common.h"
#include <vector>
#include <iterator>  // Ҫͷļ
#include<cstddef>
#include<string>
#include"TlvSession.h"
#include"DEVICE.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif
DEFINE_THIS_FILE()


CTcTrace* LOG;


TlvSession AllDataSession; //TcpպͷݵSession

SystemStatus SST;//ϵͳ״̬

RecipeExecStateValue RecipeExecState; //PMCRecipe״̬

LONGLONG sysTime;

///////////////////////////////////////////////////////////////////////////////
// CMain
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Collection of interfaces implemented by module CMain
BEGIN_INTERFACE_MAP(CMain)
	INTERFACE_ENTRY_ITCOMOBJECT()
	INTERFACE_ENTRY(IID_ITcADI, ITcADI)
	INTERFACE_ENTRY(IID_ITcWatchSource, ITcWatchSource)
///<AutoGeneratedContent id="InterfaceMap">
	INTERFACE_ENTRY(IID_ITcCyclic, ITcCyclic)
	INTERFACE_ENTRY(IID_ITcIoTcpProtocolRecv, ITcIoTcpProtocolRecv)
///</AutoGeneratedContent>
END_INTERFACE_MAP()


IMPLEMENT_ITCOMOBJECT(CMain)
IMPLEMENT_ITCOMOBJECT_SETSTATE_LOCKOP2(CMain)
IMPLEMENT_ITCADI(CMain)
IMPLEMENT_ITCWATCHSOURCE(CMain)


///////////////////////////////////////////////////////////////////////////////
// Set parameters of CMain 
BEGIN_SETOBJPARA_MAP(CMain)
	SETOBJPARA_DATAAREA_MAP()
///<AutoGeneratedContent id="SetObjectParameterMap">
	SETOBJPARA_VALUE(PID_TcTraceLevel, m_TraceLevelMax)
	SETOBJPARA_VALUE(PID_MainParameter, m_Parameter)
	SETOBJPARA_VALUE(PID_MainTcpServerPort, m_TcpServerPort)
	SETOBJPARA_VALUE(PID_MainTcpServerIpAddress, m_TcpServerIpAddress)
	SETOBJPARA_VALUE(PID_MainLocalHost, m_LocalHost)
	SETOBJPARA_ITFPTR(PID_Ctx_TaskOid, m_spCyclicCaller)
	SETOBJPARA_ITFPTR(PID_MainIpTcp, m_spIpTcp)
///</AutoGeneratedContent>
END_SETOBJPARA_MAP()

///////////////////////////////////////////////////////////////////////////////
// Get parameters of CMain 
BEGIN_GETOBJPARA_MAP(CMain)
	GETOBJPARA_DATAAREA_MAP()
///<AutoGeneratedContent id="GetObjectParameterMap">
	GETOBJPARA_VALUE(PID_TcTraceLevel, m_TraceLevelMax)
	GETOBJPARA_VALUE(PID_MainParameter, m_Parameter)
	GETOBJPARA_VALUE(PID_MainTcpServerPort, m_TcpServerPort)
	GETOBJPARA_VALUE(PID_MainTcpServerIpAddress, m_TcpServerIpAddress)
	GETOBJPARA_VALUE(PID_MainLocalHost, m_LocalHost)
	GETOBJPARA_ITFPTR(PID_Ctx_TaskOid, m_spCyclicCaller)
	GETOBJPARA_ITFPTR(PID_MainIpTcp, m_spIpTcp)
///</AutoGeneratedContent>
END_GETOBJPARA_MAP()

///////////////////////////////////////////////////////////////////////////////
// Get watch entries of CMain
BEGIN_OBJPARAWATCH_MAP(CMain)
	OBJPARAWATCH_DATAAREA_MAP()
///<AutoGeneratedContent id="ObjectParameterWatchMap">
///</AutoGeneratedContent>
END_OBJPARAWATCH_MAP()

///////////////////////////////////////////////////////////////////////////////
// Get data area members of CMain
BEGIN_OBJDATAAREA_MAP(CMain)
///<AutoGeneratedContent id="ObjectDataAreaMap">
	OBJDATAAREA_VALUE(ADI_MainInputs, m_Inputs)
	OBJDATAAREA_VALUE(ADI_MainOutputs, m_Outputs)
///</AutoGeneratedContent>
END_OBJDATAAREA_MAP()


///////////////////////////////////////////////////////////////////////////////
CMain::CMain()
	: m_Trace(m_TraceLevelMax, m_spSrv)
	,m_TraceLevelMax(tlAlways)
	,m_counter(0)
	,m_hrSend(0)
	,m_RemoteLog(&m_Trace, &m_TraceLevelMax)
{
///<AutoGeneratedContent id="MemberInitialization">
	m_TraceLevelMax = tlAlways;
	memset(&m_Parameter, 0, sizeof(m_Parameter));
	m_TcpServerPort = 0;
	memset(&m_TcpServerIpAddress, 0, sizeof(m_TcpServerIpAddress));
	memset(&m_LocalHost, 0, sizeof(m_LocalHost));
	memset(&m_Inputs, 0, sizeof(m_Inputs));
	memset(&m_Outputs, 0, sizeof(m_Outputs));
///</AutoGeneratedContent>
	m_SockId = 0; //added 
	m_bSendRequest = true; //added
	m_connections = 0; //added

	//RecipeContext::GetInstanceSetLog(&m_Trace);
	LOG = &m_Trace;

	Connect_SockId = 0;
	TagIDLength = 2;// 2
	RequestIDLength = 1;//1
	sysTime = 0;//ʼǰʱ
	AllDataSession.setTaskMain(this);
}

///////////////////////////////////////////////////////////////////////////////
CMain::~CMain() 
{
}




///////////////////////////////////////////////////////////////////////////////
// State Transitions 
// ״̬INITPREOPSAFEOPOP⣬Ӧ״̬תЩתУִлִһģضĲ״̬Ʒǳ򵥡ΣֻһһĹɡ
// ״̬תINITPREOPIPPREOPSAFEOPPSSAFEOPOPSO෴ķϣOPSAFEOPOSSAFEOPPREOPSPPREOPINITPI
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// State Transitions 
///////////////////////////////////////////////////////////////////////////////
IMPLEMENT_ITCOMOBJECT_SETOBJSTATE_IP_PI(CMain)

///////////////////////////////////////////////////////////////////////////////
// State transition from PREOP to SAFEOP
//
// Initialize input parameters 
// Allocate memory
HRESULT CMain::SetObjStatePS(PTComInitDataHdr pInitData)
{
	m_Trace.Log(tlVerbose, FENTERA "CMain::SetObjStatePS");
	HRESULT hr = S_OK;
	IMPLEMENT_ITCOMOBJECT_EVALUATE_INITDATA(pInitData);

	// TODO: Add initialization code

	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///////////////////////////////////////////////////////////////////////////////
// State transition from SAFEOP to OP
//
// Register with other TwinCAT objects
HRESULT CMain::SetObjStateSO()
{
	m_Trace.Log(tlVerbose, FENTERA "CMain::SetObjStateSO");
	HRESULT hr = S_OK;

	// TODO: Add any additional initialization
	////////////////////
	// 
	////////////////////////////
	logger->info("Initialize...");
	SST = SystemStatus::Run;
	if (SUCCEEDED(hr) && m_spIpTcp.HasOID())    //added
	{                                             //added
		hr = m_spSrv->TcQuerySmartObjectInterface(m_spIpTcp); //added

	}                                             //added
		
	initEnvironment();


	// If following call is successful the CycleUpdate method will be called, 
	// possibly even before method has been left.
	hr = FAILED(hr) ? hr : AddModuleToCaller(); 

	// Cleanup if transition failed at some stage
	if ( FAILED(hr) )
	{
		RemoveModuleFromCaller(); 
	}
#ifdef _DEBUG

	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);

#endif // _DEBUG
	return hr;
}


///////////////////////////////////////////////////////////////////////////////
// State transition from OP to SAFEOP
HRESULT CMain::SetObjStateOS()
{
	m_Trace.Log(tlVerbose, FENTERA "CMain::SetObjStateOS");

	HRESULT hr = S_OK;
	if (m_SockId != 0)
	{
		//m_Trace.Log(tlInfo, FLEAVEA "CMain::SetObjStateOS Remove m_SockId = %d", m_SockId);
		if (m_spIpTcp->IsConnected(m_SockId) == S_OK)
		{
			//m_Trace.Log(tlInfo, FLEAVEA "CMain::SetObjStateOS Remove m_SockId = OK");
			hr = m_spIpTcp->Close(m_SockId);
			//SUCCEEDED_DBG(hr);
			//m_Trace.Log(tlInfo, FLEAVEA "CMain::SetObjStateOS Remove m_SockId Close(m_SockId) state is hr=0x%08x ,0 is ok,1 is not ok", hr);
			hr = m_spIpTcp->CheckReceived();
			//SUCCEEDED_DBG(hr);
			//m_Trace.Log(tlInfo, FLEAVEA "CMain::SetObjStateOS Remove m_SockId CheckReceived() state is hr=0x%08x ,0 is ok,1 is not ok", hr);

		}

		hr = m_spIpTcp->FreeSocket(m_SockId);
		//SUCCEEDED_DBG(hr);
		//m_Trace.Log(tlInfo, FLEAVEA "CMain::SetObjStateOS Remove m_SockId FreeSocket(m_SockId) state is:hr=0x%08x ,0 is ok,1 is not ok", hr);

		m_SockId = 0;
	}
	RemoveModuleFromCaller(); 

	RemoveAllQueue();
	// TODO: Add any additional deinitialization


	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///////////////////////////////////////////////////////////////////////////////
// State transition from SAFEOP to PREOP
HRESULT CMain::SetObjStateSP()
{
	HRESULT hr = S_OK;
	m_Trace.Log(tlVerbose, FENTERA "CMain::SetObjStateSP");

	// TODO: Add deinitialization code

	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///<AutoGeneratedContent id="ImplementationOf_ITcCyclic">
HRESULT CMain::CycleUpdate(ITcTask* ipTask, ITcUnknown* ipCaller, ULONG_PTR context)
{
	//m_Trace.Log(tlVerbose, FLEAVEA " CMain::CycleUpdate");

	HRESULT hr = S_OK;
	if (SST != SystemStatus::Run)
	{
		return hr;
	}
	m_counter++;
	//if (m_counter % 1000 == 0) 

	if (m_SockId == 0)
	{
		if (SUCCEEDED_DBG(hr = m_spIpTcp->AllocSocket(THIS_CAST(ITcIoTcpProtocolRecv), m_SockId)))
		{
			if (FAILED(hr = m_spIpTcp->Listen(m_SockId, m_TcpServerPort)))
			{
				m_spIpTcp->FreeSocket(m_SockId);
				m_SockId = 0;
				m_Trace.Log(tlError, FLEAVEA "Listen Error;");

			}

			m_Trace.Log(tlInfo, FLEAVEA "Listen Start; m_SockId = %d ||m_TcpServerIpAddress =%s || m_TcpServerPort=%d", m_SockId, m_TcpServerIpAddress, m_TcpServerPort);
		}

	}

	m_spIpTcp->CheckReceived();

	AllDataSession.send();

	ipTask->GetCurrentSysTime(&sysTime);//ȡǰʱ
#ifdef DEBUG
	if (m_counter % (60*60*1000) == 0)
	{
		m_Trace.Log(tlInfo, FLEAVEA "Current System Time: %llu", sysTime);
		
	}
#endif // DEBUG


	return hr;
}
///</AutoGeneratedContent>

VOID CMain::RemoveAllQueue()
{
	m_Trace.Log(tlInfo, FLEAVEA "CMain::RemoveAllQueue() Start");

	SST = SystemStatus::Abort;

	AllDataSession.clear();
	AllDataSession.recvData.clear();
	AllDataSession.sendData.clear();
	m_Trace.Log(tlInfo, FLEAVEA "CMain::RemoveAllQueue() End");
}


///////////////////////////////////////////////////////////////////////////////
HRESULT CMain::AddModuleToCaller()
{
	m_Trace.Log(tlVerbose, FENTERA "CMain::AddModuleToCaller");

	HRESULT hr = S_OK;
	if ( m_spCyclicCaller.HasOID() )
	{
		if ( SUCCEEDED_DBG(hr = m_spSrv->TcQuerySmartObjectInterface(m_spCyclicCaller)) )
		{
			if ( FAILED(hr = m_spCyclicCaller->AddModule(m_spCyclicCaller, THIS_CAST(ITcCyclic))) )
			{
				m_spCyclicCaller = NULL;
			}
		}
		m_Trace.Log(tlVerbose, FENTERA "CMain::AddModuleToCaller enable CycleUpdate()");
	}
	else
	{
		hr = ADS_E_INVALIDOBJID; 
		SUCCEEDED_DBGT(hr, "Invalid OID specified for caller task");
	}

	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);

	return hr;
}

///////////////////////////////////////////////////////////////////////////////
VOID CMain::RemoveModuleFromCaller()
{
	m_Trace.Log(tlVerbose, FENTERA "CMain::RemoveModuleFromCaller Start");

	if ( m_spCyclicCaller )
	{
		HRESULT hr = m_spCyclicCaller->RemoveModule(m_spCyclicCaller);
		m_Trace.Log(tlInfo, FLEAVEA "CMain::RemoveModuleFromCaller  m_spCyclicCaller->RemoveModule state is= 0x%08x, 0 is ok,other numbers is not ok",hr);

	}
	m_spCyclicCaller	= NULL;

	m_Trace.Log(tlVerbose, FLEAVEA "CMain::RemoveModuleFromCaller End");
}


///<AutoGeneratedContent id="ImplementationOf_ITcIoTcpProtocolRecv">
HRESULT CMain::ReceiveData(ULONG socketId, ULONG nData, PVOID pData)
{
	m_Trace.Log(tlVerbose, FLEAVEA "CMain::ReceiveData");
	//start added code
	HRESULT hr = S_OK;
	
	hr=UnpackgeTLVData(socketId, nData, pData);

	return hr;
	//end added code
}

HRESULT CMain::ReceiveEvent(ULONG socketId, TCPIP_EVENT tcpEvent)
{
	//start added code

	//m_Trace.Log(tlInfo, FLEAVEA "Receive TCP Event: SocketId: %d Event: %d", socketId, tcpEvent);
	switch (tcpEvent)
	{
	case TCPIP_EVENT_RESET:
	case TCPIP_EVENT_TIMEOUT:
		if (socketId == m_SockId)
		{
			m_Trace.Log(tlInfo, FLEAVEA "Connection failed!");
		}
		break;
	case TCPIP_EVENT_CONN_CLOSED:
		m_Trace.Log(tlInfo, FLEAVEA "Close connection: SocketId: %d", socketId);
		m_spIpTcp->FreeSocket(socketId);
		break;
	case TCPIP_EVENT_CONN_INCOMING:
		m_spIpTcp->Accept(socketId); //Server
		//Connect_SockId = socketId;
		m_Trace.Log(tlInfo, FLEAVEA "Accept: SocketId: %d", socketId);		
		break;
	case TCPIP_EVENT_KEEP_ALIVE:
	case TCPIP_EVENT_CONN_IDLE:
		break;
	case TCPIP_EVENT_DATA_SENT:
	case TCPIP_EVENT_DATA_RECEIVED:
		//m_Trace.Log(tlInfo, FLEAVEA "TCPIP_EVENT_DATA_RECEIVED SocketId: %d", socketId);
		break;
	case TCPIP_EVENT_LINKCONNECT:
		break;
	case TCPIP_EVENT_LINKDISCONNECT:
		m_Trace.Log(tlInfo, FLEAVEA "link disconnect connection: SocketId: %d", socketId);
		m_spIpTcp->FreeSocket(socketId);
		m_SockId = 0;
		break;
	case TCPIP_EVENT_ERROR:
	default:
		break;
	}
	return S_OK;
	//end added code
}
///</AutoGeneratedContent>

/// <summary>
/// 
/// </summary>
/// <param name="socketId"> Ҫ͵SocketId</param>
/// <param name="nData">ݳ</param>
/// <param name="pData">͵</param>
/// <param name="nSendData>ط͵ĳȣ͵ݳСnData,Ҫ·</param>
/// <returns></returns>
HRESULT CMain::SendClientData(ULONG socketId, ULONG nData, PVOID pData, ULONG& nSendData)
{
	HRESULT hr = S_OK;
		
	m_spIpTcp->SendData(socketId, nData, pData, nSendData);
	m_Trace.Log(tlInfo, FLEAVEA "CMain::SendClientData() Send nData = %d , strlen(nSendData) = %d", nData, nSendData);

	return hr;
}

HRESULT CMain::SendData()
{
	HRESULT hr = S_OK;

	return hr;
}


HRESULT  CMain::PackgeTLVData(ULONG socketId, ULONG nData, PVOID pData)
{
	HRESULT hr = S_OK;
	//memset(pResponse, 0, 1000);
	//int endpos = min(1000, (int)nData);
	//memcpy(pResponse, pData, endpos);
	//pResponse[1000] = 0; //\0 term
	//CHAR req[] = { 'r','e','q','\0' };
	//PBYTE byteArray = new BYTE[10000];

	//vector<BYTE> byteA(byteArray,sizeof(byteArray));

	//string Tagid = "pmc";
	//memset(byteArray, 0, 10000);
	
	//ַ
	//memcpy(byteArray.dat)

	return hr;
}

HRESULT  CMain::UnpackgeTLVData(ULONG socketId, ULONG nData, PVOID pData)
{
	m_Trace.Log(tlVerbose, FLEAVEA " CMain::UnpackgeTLVData");
	HRESULT hr = S_OK;

	if (SST != SystemStatus::Run)
	{
		return hr;
	}

	AllDataSession.recv(socketId, (char*)pData, nData);

	LOG->Log(tlInfo, "CMain::UnpackgeTLVData() ReciveAllDataSession getRecordCount  = '%d'", AllDataSession.recvData.getRecordCount());

	return hr;
}



