#ifndef __List_H__
#define __List_H__
#include"pmc_types.h"
#include"CRemoteLog.h"
template <class T, int MAX_SIZE>
class List {
private:
	T data[MAX_SIZE];
	
public:
	int length;
	List() {
		memset(&data, '\0', sizeof(data));
		length = 0;
	}
	void clear() {
		memset(&data, '\0', sizeof(data));
		length = 0;
	}
	int size() {
		return length;
	}
	T* add(const T& value) {
		if (length < MAX_SIZE) {
			memcpy(&data[length] , &value,sizeof(value));
			length++;
			return &data[length - 1];
		}
		else {
			logger->error("List Too long[%d]>[%d]", length + 1, MAX_SIZE);
			return NULL;
		}
	}
	T* get(int index) {
		if (index < 0) {
			return NULL;
		}
		else if (index >= length) {
			return NULL;
		}
	
		return &data[index];
	}
	
}; 
#endif