#ifndef __DeviceAttribute_H__
#define __DeviceAttribute_H__
#include"pmc_types.h"

#define ATTR_TYPE_BOOL 0
#define ATTR_TYPE_CHAR 1
#define ATTR_TYPE_UCHAR 2
#define ATTR_TYPE_SHORT 3
#define ATTR_TYPE_USHORT 4
#define ATTR_TYPE_INT 5
#define ATTR_TYPE_UINT 6
#define ATTR_TYPE_LONG 7
#define ATTR_TYPE_ULONG 8
#define ATTR_TYPE_FLOAT 9
#define ATTR_TYPE_DOUBLE 10
//#define ATTR_TYPE_const char* 11
class DeviceAttribute{
    private:
        void *addr=NULL;
        double typeMax=0;
        double typeMin=0;
        PMCBOOL isPulse=FALSE;
        PMCBOOL isHold=FALSE;
        PMCBOOL isWait = FALSE;
        PMCBOOL waitValue = TRUE;
        long setHoldTime = 0;
        long elapsedHoldTime = 0;
        void (* holdCallback)(DeviceAttribute* var)=NULL;
        void (*waitCallback)(DeviceAttribute* var) = NULL;
    public:
        char name[MAX_NAME_LEN];
        char referName[MAX_NAME_LEN];
        char type=0;
        PMCBOOL isReadOnly=FALSE;
        PMCBOOL isEmpty = TRUE;
    public:
        DeviceAttribute();
        void create(const char* name);
        void create(const char* name, const char* referName);
        void create(const char* name, char* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, unsigned char* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, short* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, unsigned short* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, int* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, unsigned int* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, long* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, unsigned long* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, float* addr, const char* referName, PMCBOOL isReadOnly);
        void create(const char* name, double* addr, const char* referName, PMCBOOL isReadOnly);
        //void create(const char* name, const char* referName, PMCBOOL isReadOnly);
        

        PMCBOOL getBoolValue();
        char getCharValue();
        unsigned char getUChaValue();
        short getShortValue();
        unsigned short getUShortValue();
        int getIntValue();
        unsigned int getUIntValue();
        long getLongValue();
        unsigned long getULongValue();
        float getFloatValue();
        double getDoubleValue();
        
        ///////////
        void setBoolValue(PMCBOOL);
        void setCharValue(char);
        void setUChaValue(unsigned char);
        void setShortValue(short);
        void setUShortValue(unsigned short);
        void setIntValue(int);
        void setUIntValue(unsigned int);
        void setLongValue(long);
        void setULongValue(unsigned long);
        void setFloatValue(float);
        void setDoubleValue(double);
        void setPluseValue(PMCBOOL value, void (*callback)(DeviceAttribute *var)=NULL,long holdTime = 100);
        void setHoldValue(PMCBOOL value, void (*callback)(DeviceAttribute* var) = NULL,long holdTime = 100);
        void waitBoolValue(PMCBOOL value, void (*callback)(DeviceAttribute* var) = NULL);
        static void checkHoldDoTable();
        static void checkWaitDiTable();

};
#endif