#include"TcPch.h"
#pragma hdrstop
 
#include"DEVICE.h"
#include"EV.h"
#include"OP.h"
#include"SC.h"
#include"BoatModule.h"
#include"debug.h"
/// <summary>
/// 
/// </summary>
/// <param name="moduleDotName"></param>
/// <returns></returns>
BaseDevice* CDEVICE::getDevice(const char* moduleDotName){
	//name should be module.name
	BaseDevice** device = devices.get(moduleDotName);
	if (device == NULL) {
		return NULL;
	}
	return  *device;
 
}
/// <summary>
/// 
/// </summary>
/// <param name="module"></param>
/// <param name="name"></param>
/// <returns></returns>
BaseDevice* CDEVICE::getDevice(const char* module,const char *name) {
	//name should be module.name
	char moduleDotName[MAX_NAME_LEN];
	sprintf(moduleDotName, "%s.%s", module, name);
	BaseDevice** device = devices.get(moduleDotName);
	if (device == NULL) {
		return NULL;
	}
	return  *device;

}
/// <summary>
/// 
/// </summary>
/// <param name="index"></param>
/// <returns></returns>
BaseDevice* CDEVICE::getDeviceByIndex(int index) {
	BaseDevice** device = devices.getByIndex(index);
	if (device == NULL) {
		return NULL;
	}
	return  *device;
	

}
/// <summary>
/// 
/// </summary>
/// <param name="device"></param>
void CDEVICE::addDevice(BaseDevice * device){
	if (device == NULL){
		return;
	}
	char name[MAX_NAME_LEN];
	sprintf(name, "%s.%s", device->module, device->name);

	devices.set(name, device,__FILE__,__LINE__);

}
/// <summary>
/// 
/// </summary>
/// <returns></returns>
int CDEVICE::getDeviceCount() {
	return devices.length;
}
/// <summary>
/// 
/// </summary>
CDEVICE::CDEVICE() {
	//initAllDeviceAttr();
	//initIoVariableMap();
}
/// <summary>
/// 
/// </summary>
void CDEVICE::create() {
	
}
CDEVICE* DEVICE;


void initDEVICE();
void initEnvironment() {
	static CEV staticEV;
	
	EV = &staticEV;

	static CSC staticSC;
	SC = &staticSC;
	
	static COP staticOP;
	OP = &staticOP;
	OP->subscribe("default", []()->OperatorStatusEnum {
		logger->error("Found a undefine OP:%s", OP->current->params.get(0));
		return OperatorStatusEnum::SUCCESS;
		});

	static CDEVICE staticDEVICE;
	DEVICE = &staticDEVICE;
	initDEVICE();

	static BoatModule staticBoatModule;
	boatModule = &staticBoatModule;
	
}
void closeDEVICE() {

}
//AUTOIO_BEGIN
void initDEVICE(){
	void initIoHeater();
	initIoHeater();
	void initIoAlarmSignal();
	initIoAlarmSignal();
	void initIoShutter();
	initIoShutter();
	void initIoDoor();
	initIoDoor();
	void initFurnaceSignalTower();
	initFurnaceSignalTower();
	void initIoPressureMeter();
	initIoPressureMeter();
	void initIoAlarmSignal();
	initIoAlarmSignal();
	void initIoSensor();
	initIoSensor();
	void initIoTrigger();
	initIoTrigger();
	void initIoFIMS();
	initIoFIMS();
	void initIoStocker();
	initIoStocker();
	void initIoLP();
	initIoLP();
	void initIoBufferMotor();
	initIoBufferMotor();
	void initIoFFU();
	initIoFFU();
	void initIoWaferRobot();
	initIoWaferRobot();
	void initIoFurnaceMotor();
	initIoFurnaceMotor();
	void initIoAPC();
	initIoAPC();
	void initIoMFC();
	initIoMFC();
	void initIoMFM();
	initIoMFM();
	void initIoValve();
	initIoValve();
}
//AUTOIO_END
