#include "TcPch.h"
#pragma hdrstop
#include "CRemoteLog.h"
//#include "PMCDeviceInterfaces.h"
#include "TcBaseInterfaces.h"
#include"TcInterfaces.h"
#include "TcDef.h"
#include "TcServices.h"
#include"stdarg.h"
#include"debug.h"
static CTcTrace* pSystemTrace;
static TcTraceLevel* ptrSystemLevel;
static char outputBuf[MAX_CONTEXT_LEN*2];
void writeLog(TcTraceLevel level,const char *data) {
	size_t bufferSize;
	bufferSize = strlen(data);
	
	if (level > *ptrSystemLevel) {
		return;
	}
	pSystemTrace->Log(level, (PCHAR)data);

}
CRemoteLog::CRemoteLog(void* ptrTrace, void* ptrLevel) {
	pSystemTrace = (CTcTrace* )ptrTrace;
	ptrSystemLevel = (TcTraceLevel *)ptrLevel;
	memset(outputBuf, '\0', sizeof(outputBuf));
}
void CRemoteLog::info(const char *format,...) {
	if (tlInfo > *ptrSystemLevel) {
		return;
	}
	
	va_list args;
	va_start(args, format);
	vsnprintf(outputBuf, sizeof(outputBuf) - 1, format, args);
	va_end(args);
	writeLog(tlInfo, outputBuf);
}
void CRemoteLog::debug(const char* format, ...) {
	if (tlVerbose > *ptrSystemLevel) {
		return;
	}

	va_list args;
	va_start(args, format);
	vsnprintf(outputBuf, sizeof(outputBuf) - 1, format, args);
	va_end(args);
	writeLog(tlVerbose, outputBuf);
}
void CRemoteLog::error(const char* format, ...) {
	if (tlError > *ptrSystemLevel) {
		return;
	}
	va_list args;
	va_start(args, format);
	vsnprintf(outputBuf, sizeof(outputBuf) - 1, format, args);
	va_end(args); 
	writeLog(tlError, outputBuf);
}

CRemoteLog* logger;