#include "AlarmRecipeChecker.h"


AlarmRecipeChecker::AlarmRecipeChecker(BaseDevice* device, int delayTime, int checkTime)
{
	devices = device;
	setDelayTime = delayTime;
	setCheckTime = checkTime;
	status = AlarmRecipStatusValue::Unused;
	elapsedCheckTime = 0;
	elapsedDelayTime = 0;
}

AlarmRecipeChecker::~AlarmRecipeChecker()
{
}

BOOL AlarmRecipeChecker::checkOnce()
{
	BOOL result = true;

	return result;
}

void AlarmRecipeChecker::check()
{
	if (status == AlarmRecipStatusValue::Unused)
	{
		return;
	}
	if (status == AlarmRecipStatusValue::Delay && setDelayTime==0)
	{
		status = AlarmRecipStatusValue::Check;
	}

	if (status == AlarmRecipStatusValue::Delay && setDelayTime != 0)
	{
		elapsedDelayTime += TM;
		if (elapsedDelayTime>=setDelayTime)
		{
			status = AlarmRecipStatusValue::Check;
			return;
		}

	}

	if (status == AlarmRecipStatusValue::Check)
	{
		if (checkOnce())
		{
			elapsedCheckTime -= TM;
			if (elapsedCheckTime<=0)
			{
				elapsedCheckTime = 0;
			}
			return;
		}
		else
		{
			elapsedCheckTime += TM;
			if (elapsedCheckTime>=setCheckTime)
			{
				elapsedCheckTime = setCheckTime;
				status = Alarm;
			}
			return;
		}

	}

	if (status == AlarmRecipStatusValue::Alarm)
	{
		return;
	}

}

int AlarmRecipeChecker::getStatus()
{
	//BOOL result = true;

	return (int)status;
}

void AlarmRecipeChecker::start()
{
	if (status != AlarmRecipStatusValue::Unused)
	{
		return;
	}
	else
	{
		status = AlarmRecipStatusValue::Delay;
	}
}

void AlarmRecipeChecker::stop()
{
	status = AlarmRecipStatusValue::Unused;
}