#ifndef __TLV_SESSION_H__
#define __TLV_SESSION_H__

#define MAX_TLV_BUFFER_SIZE 1024*1024*2
#define MAX_RECORD_SIZE 1024*64+2
#define PACKAGE_MSGTYPE_POSITION 2
#define PACKAGE_MSGTYPE_ENQ 0x05
#define PACKAGE_MSGTYPE_ACK 0x06
#define PACKAGE_MSGTYPE_STX 0x02
#define PACKAGE_TAIL_FLAG_POSITION -2
#define PACKAGE_TAIL_FLAG_LENGTH 2
#define PACKAGE_TAIL_FLAG "\x0d\x0a"
#define PACKAGE_TAIL_CHECK FALSE
#define USE_NET_SORT TRUE  
class TlvData {
private:
	char data[MAX_TLV_BUFFER_SIZE];
	int head = 0;
	int tail = 0;
	int free = 0;
	int recordCount = 0;
	char msgId=0;
private:
	void getDataBytes(char* buffer, int begin, int length);
	void setDataBytes(char* buffer, int begin, int length);
public:
	int popRawData(char* buffer);
	int pop(char* buffer);
	void pushRawData(char* buffer, int length);
	void push(char* buffer, int length);
	int getRecordCount();
	void clear();
};
class TlvSession {
public:
	TlvData sendData;
	TlvData recvData;
private:
	char recvBuffer[MAX_RECORD_SIZE];
	char sendBuffer[MAX_RECORD_SIZE];
	int recvTotalLength = 0;
	int recvLength = 0;
	int sendTotalLength = 0;
	int sendLength = 0;
	unsigned long  socketId;
public:
	void recv(unsigned long  socketId, const char* buffer, const int length);
	void send();
	void clear();
private:
	int sockSend(unsigned long socketId, unsigned long  nData, void* pData, unsigned long& nSendData);
};
#endif