#ifndef __SIMULATOR_H__
#define __SIMULATOR_H__
#include"pmc_types.h"
#if defined( _DEBUG ) && defined(_WITH_SIMULATOR)
#include"DeviceAttribute.h"
#include"List.h"
#define MAX_CONDITION_COUNT 256
#define MAX_CONDITION_ITEM_COUNT 16
typedef enum class _simulator_op{NONE,EQ,NE,GT,GE,LT,LE,WAIT,SET} SMOP;
class ConditionNode {
private:
	unsigned long elapsedTime = 0;
	DeviceAttribute* attr = NULL;
	SMOP op = SMOP::NONE;
	union {
		bool BoolValue;
		double DoubleValue;
		long   LongValue;
	}value;
	int index = 0;
	int offset = 0;
	ConditionNode* next=NULL;
public:
	ConditionNode* when(DeviceAttribute* attr, SMOP op, bool   value);
	ConditionNode* when(DeviceAttribute* attr, SMOP op, double value);
	ConditionNode* wait(long value);
	ConditionNode* set(DeviceAttribute* attr,double value);
	ConditionNode* set(DeviceAttribute* attr, bool value);
	
	friend class Simulator;
};
class Simulator {
private:
	ConditionNode data[MAX_CONDITION_COUNT][MAX_CONDITION_ITEM_COUNT];
	int length=0;
public:
	Simulator();
	ConditionNode* when(DeviceAttribute* attr, SMOP op, bool   value);
	ConditionNode* when(DeviceAttribute* attr, SMOP op, double value);
	ConditionNode* wait(long value);
	ConditionNode* set(DeviceAttribute* attr, double value);
	ConditionNode* set(DeviceAttribute* attr, bool value);
	void monitor();

};

#endif
void simulatorSet();
void simulatorMonitor();
#endif