#include "TcPch.h"
#pragma hdrstop
#include"RecipeContext.h"
#include"time.h"
#include"TcTimeConversion.h"
#include"OP.h"
#include "CommandKeySt.h"
#include"debug.h"

static RecipeContext _g_pRecipeContext;

RecipeContext* RecipeContext::GetInstance()
{
	return &_g_pRecipeContext;
}

void RecipeContext::deleteInstance()
{
	EV->postInfoLog("RecipeContext::deleteInstance()");
	//if (g_pRecipeContext)
	//{
	//	delete g_pRecipeContext;
	//	g_pRecipeContext = nullptr;
	//}
}

int RecipeContext::Moniter()
{
	//EV->postInfoLog("RecipeContext::Moniter()");
	//if (RecipeExecState!= RecipeExecStateValue::Execteing)
	//{
	//	return 0;
	//}

		
	//LOG->Log(tlInfo, FLEAVEA "RecipeContext::Moniter() Start");

	//̣
	//	1.ǰ״̬recipeExecuteStatus == Idle
	//	1.յrecipeExecuteCommand == Execute 
	//	״̬baseDataDownloadStatus = Done 
	//	recipe״̬recipeDataDownloadStatus = Done
	//	i.recipeExecuteCommand
	//	ii.ִһRecipeContext.executeNextStep();
	//2.
	//	2.ǰ״̬recipeExecuteStatus == TimeWait
	//	1.ˢ¼ʱupdateTime(FALSE)
	//	2.ִRecipeCheckerбÿcheck
	//	i.AlarmRecipeCheckeralarm conditionش
	//	3.յabortָrecipeExecuteCommand = Abort
	//	i.recipeExecuteCommandָ
	//	ii.ûabort reciperecipeExecuteStatus = StepCompleted
	//	iii.abort recipeִabort recipeҲòΪ - 1֤next߼һԣ
	//	iv.ִһRecipeContext.executeNextStep();
	//v.
	//	4.StableRecipeCheckerelapsedStepTime򳬹step.timeõʱ
	//	1.recipeExecuteStatus = StepCompleted
	//	2.յskipjumpHoldָ
	//	a)skipָ
	//	i.recipeExecuteCommand
	//	ii.ִRecipeContext.next()
	//	iii.ִRecipeContext.executeNextStep()
	//	iv.
	//	b)jumpָ
	//	i.recipeExecuteCommand
	//	ii.ִjumpToִ
	//	iii.ִstep / stepż1֤nextȷԣ
	//	iv.ִRecipeContext.executeNextStep()
	//	v.
	//	c)Holdָ
	//	i.recipeExecuteCommand
	//	ii.ִRecipeContext.next()
	//	iii.ִpause
	//	iv.
	//	3.δյırecipeִ˳ָ
	//	a)ִһRecipeContext.executeNextStep();
	//b)
	//3.ǰ״̬recipeExecuteStatus == Paused
	//	1.ˢ¼ʱupdateTime(FALSE)
	//	2.յskipjumpReleaseָ
	//	i.skipָ
	//	1.recipeExecuteCommand
	//	2.ִRecipeContext.executeNextStep()ǰstepͿˡ
	//	3.
	//	ii.jumpָ
	//	1.recipeExecuteCommand
	//	2.ִjumpToִ
	//	3.ִstep / stepż1֤nextȷԣ
	//	4.ִRecipeContext.executeNextStep()
	//	5.
	//	iii.Releaseָ
	//	1.recipeExecuteCommand
	//	2.ִstep / stepż1֤nextȷԣ
	//	3.ִRecipeContext.executeNextStep()
	//	4.

	if (recipeExecuteStatus == recipeExecuteStatusValue::Idle)
	{
		if (recipeExecuteCommand == recipeExecuteCommandValue::Execute &&
			baseDataDownloadStatus == baseDataDownloadStatusValue::Done &&
			recipeDataDownloadStatus == recipeDataDownloadStatusValue::Done)
		{
			recipeExecuteCommand = recipeExecuteCommandValue::Clear;

			next();

		}

		return 0;
	}
	if (recipeExecuteStatus == recipeExecuteStatusValue::ExecStep)
	{
		char jumpRecipeCmd[32];
		sprintf(jumpRecipeCmd, "%s.Recipe.Command", MODULE_NAME);
		SC->setStringValue(jumpRecipeCmd, "");
		OperatorStatus& status = OP->monitor();
		if (status == OperatorStatusEnum::SUCCESS) {
			if (status.trigger()) {
				status.clearTrigger();				
				//TODOǵһͨ(alarm conditionת,step timejumpRecipeCmdжϴ
			}
			//TODOǵnͨ(alarm conditionתstep timejumpRecipeCmdжϴ
		}
		else if (status == OperatorStatusEnum::ALARM) {
			//TODO﷢ALARMalarm conditionδ
			
		}
		else {
			//TODOִй
		}
	}

	if (recipeExecuteStatus == recipeExecuteStatusValue::TimeWait)
	{
		updateTime(FALSE);
		//2.ִRecipeCheckerбÿcheck
		//	i.AlarmRecipeCheckeralarm conditionش
		// 
		//string 
		//for (size_t i = 0; i < length; i++)
		//{

		//}

		//3.յabortָrecipeExecuteCommand = Abort
		//	i.recipeExecuteCommandָ
		//	ii.ûabort reciperecipeExecuteStatus = StepCompleted
		//	iii.abort recipeִabort recipeҲòΪ - 1֤next߼һԣ
		//	iv.ִһRecipeContext.executeNextStep();
		//	v.

		if (recipeExecuteCommand == recipeExecuteCommandValue::Abort)
		{
			recipeExecuteCommand = recipeExecuteCommandValue::Clear;

			if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
			{
				//iii.abort recipeִabort recipeҲòΪ - 1֤next߼һԣ
				currentOtherStepNo = -1;

				executeStep();

				return 0;
			}
			else
			{
				recipeExecuteStatus = recipeExecuteStatusValue::StepCompleted;
				return 0;
			}
		}

		return 0;
	}
	if (recipeExecuteStatus == recipeExecuteStatusValue::TimeWait)
	{
		char jumpRecipeCmd[32];
		sprintf(jumpRecipeCmd, "%s.Recipe.Command", MODULE_NAME);
		SC->setStringValue(jumpRecipeCmd, "");
		OperatorStatus& status = OP->monitor();
		if (status == OperatorStatusEnum::SUCCESS) {
			if (status.trigger()) {
				status.clearTrigger();
				//TODOǵһͨ(alarm conditionת,step timejumpRecipeCmdжϴ
			}
			//TODOǵnͨ(alarm conditionתstep timejumpRecipeCmdжϴ
		}
		else if (status == OperatorStatusEnum::ALARM) {
			//TODO﷢ALARMalarm conditionδ

		}
		else {
			//TODOִй
		}
	}
	if (recipeExecuteStatus == recipeExecuteStatusValue::Paused)
	{
		updateTime(FALSE);

		if (recipeExecuteCommand == recipeExecuteCommandValue::Skip || recipeExecuteCommand == recipeExecuteCommandValue::Jump || recipeExecuteCommand == recipeExecuteCommandValue::Release)
		{
			if (recipeExecuteCommand == recipeExecuteCommandValue::Skip)
			{
				recipeExecuteCommand = recipeExecuteCommandValue::Clear;
				next();
				executeStep();
				return 0;
			}

			if (recipeExecuteCommand == recipeExecuteCommandValue::Jump)
			{
				recipeExecuteCommand = recipeExecuteCommandValue::Clear;

				//2.ִjumpToִ
				//jumpTo();

				//	3.ִstep / stepż1֤nextȷԣ
				currentStepNo--;
				currentOtherStepNo--;
				executeStep();
				return 0;
			}
			if (recipeExecuteCommand == recipeExecuteCommandValue::Release)
			{
				recipeExecuteCommand = recipeExecuteCommandValue::Clear;

				currentStepNo--;
				currentOtherStepNo--;
				executeStep();
				return 0;
			}
		}

		return 0;
	}

	//LOG->Log(tlInfo, FLEAVEA "RecipeContext::Moniter()");
	return 0;
}

void RecipeContext::SetCTcTrace(CTcTrace* _cTrack)
{
	//cTrack = _cTrack;
}

RecipeContext::RecipeContext()
{
	currentRecipeType = currentRecipeTypeValue::NormalRecipe;
	currentStepNo = -1;
	elapsedTotalTime = 0;
	elapsedStepTime = 0;
	remainTotalTime = 0;
	remainStepTime = 0;
	holdTotalTime = 0;
	holdStepTime = 0;
	startTime = 0;
	baseDataDownloadStatus = baseDataDownloadStatusValue::Unknown;
	recipeDataDownloadStatus = recipeDataDownloadStatusValue::Unknown;
	recipeExecuteStatus = recipeExecuteStatusValue::Unknown;
	recipeExecuteCommand = recipeExecuteCommandValue::Default;
}


RecipeContext::~RecipeContext()
{


}


BOOL RecipeContext::parseMainRecipe(string json)
{

	return true;
}
BOOL RecipeContext::parseSubRecipe(string json)
{
	return true;
}
BOOL RecipeContext::parseAbortRecipe(string json)
{
	return true;
}
BOOL RecipeContext::parseAlarmRecipe(string json)
{
	return true;
}
BOOL RecipeContext::parseAlarmCondition(string json)
{
	return true;
}

BOOL RecipeContext::parseTempProfile(string json)
{
	return true;
}

BOOL RecipeContext::parseTempPID(string json) 
{

	return true;
}
BOOL RecipeContext::parseTempCorrection(string json) 
{
	return true;
}
BOOL RecipeContext::parseApcPID(string json)
{
	return true;
}
BOOL RecipeContext::parseLeakCheck(string json)
{

	return true;
}

BOOL RecipeContext::isFinished()
{	
	//1.main recipestep count <= 0򷵻TRUE
	if (mainStepList.size()<=0)
	{
		return true;
	}
	//	2.currentStepNo < 0 >= step count򷵻TRUE
	if (currentStepNo<0 || currentStepNo>= mainStepList.size())
	{
		return true;
	}

	//	3.currentRecipeType == SubRecipe
	//	a)currentOtherStepNo < 0 || currentOtherStepNo >= currentOtherRecipeKey ָsub recipe countTRUEsub recipeִҪصrecipejudgeдߵ˴ʵʾǳˣֱΪ
	//	b)򷵻FALSE
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		if (currentOtherStepNo < 0 || currentOtherStepNo >= (*subStepListMap.get(CovertIntToChar(currentOtherRecipeKey))).size())
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	//	4.currentRecipeType == AbortRecipe
	//	a)currentOtherStepNo < 0 || currentOtherStepNo >= currentOtherRecipeKey ָabort recipe countTRUE
	//	b)򷵻FALSE
	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		if (currentOtherStepNo < 0 || currentOtherStepNo >= (*subStepListMap.get(CovertIntToChar( currentOtherRecipeKey))).size())
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	//	5.currentRecipeType == AlarmRecipe
	//	a)currentOtherStepNo < 0 || currentOtherStepNo >= currentOtherRecipeKey ָalarm recipe countTRUE
	//	b)򷵻FALSE
	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		if (currentOtherStepNo < 0 || currentOtherStepNo >= (*subStepListMap.get(CovertIntToChar( currentOtherRecipeKey))).size())
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	//	6.currentRecipeType == ResetRecipe
	//	a)currentOtherStepNo < 0 || currentOtherStepNo >= currentOtherRecipeKey ָreset recipe countTRUE
	//	b)򷵻FALSE
	if (currentRecipeType == currentRecipeTypeValue::ResetRecipe)
	{
		if (currentOtherStepNo < 0 || currentOtherStepNo >= (*subStepListMap.get(CovertIntToChar( currentOtherRecipeKey))).size())
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	//	7.FALSE
	return false;
}

int RecipeContext::getCurrentRecipeType()
{
	return (int)currentRecipeType;
}


BOOL RecipeContext::judgeStep()
{
	//ֵ
	//	TRUE - recipeδִָ붨λ˿ִеĲ
	//	FALSE - recipeִн﷨
	//̣	
	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		//1.currentRecipeType == NormalReciperecipe
//	a)currentStepNoָĵǰǷֱӷFALSE
		if (currentStepNo < 0 || currentStepNo > mainStepList.size())
		{
			return false;
		}
		//	b)currentStepNoָĵǰisJumpStepΪTRUE
		//	i.jumpStepNamerecipeУҵjumpStepNo
		//	ii.ҵcurrentStepNo = jumpStepNoFALSE
		//	iii.أ1ѭж
		if (mainStepList.get(currentStepNo)->isJumpStep == TRUE)
		{
			string jumpStepName = mainStepList.get(currentStepNo)->jumpStepName;
			for (size_t i = 0; i < mainStepList.size(); i++)
			{
				if (mainStepList.get(i)->name == jumpStepName)
				{
					currentStepNo = mainStepList.get(i)->stepNo;
				}
			}
		}
		//	c)currentStepNoָĵǰisLoopEndStepΪTRUE
		//	i.ǰelpasedLoopCount++
		//	ii.ǰelapsedLoopCount < loopCount
		//	1.currentStepNo = loopStartStep
		//	2.أ1ѭж
		//	iii.򣬵ǰelapsedLoopCount >= loopCount
		//	1.currentStepNo++
		//	2.elapsedLoopCount = 0
		//	3.أ1ѭж
		if (mainStepList.get(currentStepNo)->isLoopEndStep)
		{
			mainStepList.get(currentStepNo)->elapsedLoopCount++;
			if (mainStepList.get(currentStepNo)->elapsedLoopCount < mainStepList.get(currentStepNo)->loopCount)
			{
				currentStepNo = mainStepList.get(currentStepNo)->loopStartStep;
			}
			else
			{
				currentStepNo++;
				mainStepList.get(currentStepNo)->elapsedLoopCount = 0;
			}
		}

		//	d)currentStepNoָĵǰisCallSubStepΪTRUE
		//	i.ǰelapsedSubRecipeLoopCount < subRecipeLoopCount
		//	1.elapsedSubRecipeLoopCount++
		//	2.currentRecipeType = SubRecipe
		//	3.currentOtherStepNo = 0
		//	4.أ1ѭжϣsub recipe
		//	ii.ǰelapsedSubRecipeLoopCount >= subRecipeLoopCount
		//	1.elapsedSubRecipeLoopCount = 0
		//	2.TRUE˴ͣΪsubִ֮recipestep
		//	3.ǰrecipe stepִ֮nextͻ˲ԲҪ￼sub recipeˡ
		if (mainStepList.get(currentStepNo)->isCallSubStep)
		{
			if (mainStepList.get(currentStepNo)->elapsedSubRecipeLoopCount < mainStepList.get(currentStepNo)->subRecipeLoopCount)
			{
				mainStepList.get(currentStepNo)->elapsedSubRecipeLoopCount++;
				currentRecipeType = currentRecipeTypeValue::SubRecipe;
				currentOtherStepNo = 0;
			}
			else
			{
				mainStepList.get(currentStepNo)->elapsedSubRecipeLoopCount = 0;
				return true;
			}
		}
		//	e)TRUE(normal recipeת)
		return true;
	}

	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		//	2.currentRecipeType == SubRecipesub recipe
	//	a)recipeǰsubRecipeKeycurrentOtherStepNosub recipeжλ
		//subStepListMap[currentOtherRecipeKey][currentOtherStepNo].subRecipeKey;
		//subStepListMap[currentOtherRecipeKey][currentOtherStepNo].stepNo;

		//	b)currentOtherStepNoﵽsub recipeѾִ꣩
	//	1.currentRecipeType = NormalRecipe
	//	2.أ1ѭnormal recipeĵò裩
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		if (currentOtherStepNo > (*subStepListMap.get(cork)).size())
		{
			currentRecipeType = currentRecipeTypeValue::NormalRecipe;
		}

		//	c)sub recipecurrentOtherStepNoָstepǷFALSE

		if (currentOtherStepNo < 0 || currentOtherStepNo >= (*subStepListMap.get(cork)).size())
		{
			return false;
		}

		//	d)currentOtherStepNoָĵǰsub recipeisJumpStepΪTRUE
		//	i.sub recipeиjumpStepNameҵsub recipeģjumpStepNo
		//	ii.ҵcurrentOtherStepNo = jumpStepNo򷵻FALSE
		//	iii.أ1ѭж

		if ((subStepListMap.get(cork))->get(currentOtherStepNo)->isJumpStep)
		{
			string junmstepname = (subStepListMap.get(cork))->get(currentOtherStepNo)->jumpStepName;

			for (size_t i = 0; i < (subStepListMap.get(cork))->size(); i++)
			{
				if ((subStepListMap.get(cork))->get(i)->name == junmstepname)
				{
					currentOtherStepNo = (subStepListMap.get(cork))->get(i)->stepNo;
				}
			}

		}

		//	e)currentStepNoָĵǰsub recipeisLoopEndStepΪTRUE
		//	i.ǰsubelpasedLoopCount++
		//	ii.ǰsubelapsedLoopCount < loopCount
		//	1.currentOtherStepNo = loopStartStep
		//	2.أ1ѭж
		//	iii.򣬵ǰsubelapsedLoopCount >= loopCount
		//	1.currentOtherStepNo++
		//	2.elapsedLoopCount = 0
		//	3.أ1ѭж

		if ((subStepListMap.get(cork))->get(currentOtherStepNo)->isLoopEndStep)
		{
			(subStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount++;

			if ((subStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount < (subStepListMap.get(cork))->get(currentOtherStepNo)->loopCount)
			{
				currentOtherStepNo = (subStepListMap.get(cork))->get(currentOtherStepNo)->loopStartStep;

			}
			else
			{
				currentOtherStepNo++;
				(subStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount = 0;
			}
		}

		//	f)TRUE(sub recipeת)
		return true;
	}

	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		//	3.currentRecipeType == AbortRecipeabort recipe
	//	a)recipeǰabortRecipeKeycurrentOtherStepNoabort recipeжλ
		//abortStepListMap[currentOtherRecipeKey][currentOtherStepNo].abortRecipeKey;

	//	b)currentOtherStepNoﵽabort recipeǷѾִ꣩FALSE
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		if (currentOtherStepNo < 0 || currentOtherStepNo >= (*abortStepListMap.get(cork)).size())
		{
			return false;
		}

		//	c)currentOtherStepNoָĵǰabort recipeisJumpStepΪTRUE
		//	i.abort recipeиjumpStepNameҵabort recipeģjumpStepNo
		//	ii.ҵcurrentOtherStepNo = jumpStepNo򷵻FALSE
		//	iii.أ1ѭж

		if ((abortStepListMap.get(cork))->get(currentOtherStepNo)->isJumpStep)
		{
			string jumpstepname = (abortStepListMap.get(cork))->get(currentOtherStepNo)->jumpStepName;

			for (size_t i = 0; i < (abortStepListMap.get(cork))->size(); i++)
			{
				if ((abortStepListMap.get(cork))->get(i)->name == jumpstepname)
				{
					currentOtherStepNo = (abortStepListMap.get(cork))->get(i)->stepNo;
				}
			}
		}

		//	d)currentStepNoָĵǰabort recipeisLoopEndStepΪTRUE
		//	i.ǰabortelpasedLoopCount++
		//	ii.ǰabortelapsedLoopCount < loopCount
		//	1.currentOtherStepNo = loopStartStep
		//	2.أ1ѭж
		//	iii.򣬵ǰabortelapsedLoopCount >= loopCount
		//	1.currentOtherStepNo++
		//	2.elapsedLoopCount = 0
		//	3.أ1ѭж
		if ((abortStepListMap.get(cork))->get(currentOtherStepNo)->isLoopEndStep)
		{
			(abortStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount++;
			if ((abortStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount < (abortStepListMap.get(cork))->get(currentOtherStepNo)->loopCount)
			{
				currentOtherStepNo = (abortStepListMap.get(cork))->get(currentOtherStepNo)->loopStartStep;
			}
			else
			{
				currentOtherStepNo++;
				(abortStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount = 0;
			}

		}
		//	e)TRUEabort recipeת)
		return true;

	}

	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		if (currentOtherStepNo < 0 || currentOtherStepNo >= (*alarmStepListMap.get(CovertIntToChar(currentOtherRecipeKey))).size())
		{
			return false;
		}

		if ((alarmStepListMap.get(cork))->get(currentOtherStepNo)->isJumpStep)
		{
			string jumpstepname = (alarmStepListMap.get(cork))->get(currentOtherStepNo)->jumpStepName;

			for (size_t i = 0; i < (alarmStepListMap.get(cork))->size(); i++)
			{
				if ((alarmStepListMap.get(cork))->get(i)->name == jumpstepname)
				{
					currentOtherStepNo = (alarmStepListMap.get(cork))->get(i)->stepNo;
				}
			}
		}

		if ((alarmStepListMap.get(cork))->get(currentOtherStepNo)->isLoopEndStep)
		{
			(alarmStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount++;
			if ((alarmStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount < (alarmStepListMap.get(cork))->get(currentOtherStepNo)->loopCount)
			{
				currentOtherStepNo = (alarmStepListMap.get(cork))->get(currentOtherStepNo)->loopStartStep;
			}
			else
			{
				currentOtherStepNo++;
				(alarmStepListMap.get(cork))->get(currentOtherStepNo)->elapsedLoopCount = 0;
			}

		}

		return true;
	}

	return true;

}

BOOL RecipeContext::next()
{
	//ܣȡһstep
	//	캯ʼ֮һִnextȡһstep
	//	ֵ
	//	TRUE  ȡɹǰcurrentStepNocurrentOtherStepNoѾָȡstepʹĸcurrentRecipeTypeжϣ
	//	FALSE stepִУrecipeִн
	//	̣
	//	1.currentStepNo < 0һִnext
	//	a)isJobRecipecurrentStepNo = 1standby0standby
	//	2.
	//	a)currentRecipeType == NormalRecipecurrentStepNo++
	//	b)currentOtherStepNo++
	//	3. judgeStep
	if (currentStepNo<0)
	{
		if (!isJobRecipe)
		{
			currentStepNo += 1;
		}
		else
		{
			if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
			{
				currentStepNo++;
			}
			else
			{
				currentOtherStepNo++;
			}
		}

	}

	return judgeStep();
}

BOOL RecipeContext::previous()
{

	//ܣȡһstep
	//	ֵ
	//	TRUE  ȡɹ
	//	FALSE ûҵһ裬Ϊǳ
	//	̣
	//	1.currentStepNo <= 0һִnextִеĵһָ
	//	a)FALSE
	//	2.
	//	a)currentRecipeType == NormalRecipecurrentStepNo--
	//	b)
	//	i.currentOtherStepNo < 0
	//	1.FALSE
	//	ii.currentOtherStepNo--
	//	3. judgeStep
	if (currentStepNo<=0)
	{
		return false;
	}
	else
	{
		if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
		{
			currentStepNo--;
		}
		else
		{
			if (currentOtherStepNo < 0)
				return false;
			currentOtherStepNo--;
		}
	}

	return judgeStep();
}

BOOL RecipeContext::skip() 
{
	//ֵ
	//	TRUE  ȡɹ
	//	FALSE  ûҵִн
	//	̣
	//	1.currentStepNo < 0һִnext
	//	1.FALSE
	//	next
	if (currentStepNo<0)
	{
		return false;
	}
	return next();
}

BOOL RecipeContext::jumpTo(string toStepName) 
{
	//ֵ
	//	TRUE  ȡɹ
	//	FALSE ûҵΪǳ
	//	̣
	//	1.currentRecipeType == NormalReciperecipe
	//	a)toStepNamerecipeУҵjumpStepNo
	//	b)jumpStepNoϷ
	//	i.ִѭж
	//	ii.currentStepNo = jumpStepNo
	//	iii.judgeStep()
	//	c)򷵻FALSE
	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		for (size_t i = 0; i < mainStepList.size(); i++)
		{
			if (mainStepList.get(i)->name == toStepName)
			{
				int jumpstepno = mainStepList.get(i)->stepNo;
				currentStepNo = jumpstepno;
				return judgeStep();
			}
		}
	}


	//	2.currentRecipeType == SubRecipesub recipe
	//	a)toStepNamesub recipeУҵjumpStepNo
	//	b)jumpStepNoϷ
	//	i.ִѭж
	//	ii.currentOtherStepNo = jumpStepNo
	//	iii.judgeStep()
	//	c)򷵻FALSE
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		for (size_t i = 0; i < (subStepListMap.get(cork))->size(); i++)
		{
			if ((subStepListMap.get(cork))->get(i)->name == toStepName)
			{
				int jumpstepno = (subStepListMap.get(cork))->get(i)->stepNo;
				currentOtherStepNo = jumpstepno;
				return judgeStep();
			}
		}
	}

	//	3.currentRecipeType == AbortRecipeabort recipe
	//	a)toStepNameabort recipeУҵjumpStepNo
	//	b)jumpStepNoϷ
	//	i.ִѭж
	//	ii.currentOtherStepNo = jumpStepNo
	//	iii.judgeStep()
	//	c)򷵻FALSE
	
	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		for (size_t i = 0; i < (abortStepListMap.get(cork))->size(); i++)
		{
			if ((abortStepListMap.get(cork))->get(i)->name == toStepName)
			{
				int jumpstepno = (abortStepListMap.get(cork))->get(i)->stepNo;
				currentOtherStepNo = jumpstepno;
				return judgeStep();
			}
		}
	}

	//	4.currentRecipeType == AlarmRecipealarm recipe
	//	a)toStepNamealarm recipeУҵjumpStepNo
	//	b)jumpStepNoϷ
	//	i.ִѭж
	//	ii.currentOtherStepNo = jumpStepNo
	//	iii.judgeStep()
	//	c)򷵻FALSE
	
	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		for (int i = 0; i < (alarmStepListMap.get(cork))->size(); i++)
		{
			if ((alarmStepListMap.get(cork))->get(i)->name == toStepName)
			{
				int jumpstepno = (alarmStepListMap.get(cork))->get(i)->stepNo;
				currentOtherStepNo = jumpstepno;
				return judgeStep();
			}
		}
	}

	return true;
}
void RecipeContext::pause()
{
	if (isPaused)
	{
		isPaused = false;
	}
	else
	{
		isPaused = true;
	}

}

void RecipeContext::updateTime(BOOL newStep)
{
	//
	//	²newStepʱƬӣˢ»ʱ
	//	²裬ֻۼʱƬ
	//	̣
	//	newStep == TRUE
	//	1.elapsedStepTime = 0
	//	2.remainStepTime = step time
	//	3.remainTotalTime == 0һμʣʱ䣩
	//	a)currentStepNoRecipeType
	//	b)currentStepNo = -1, RecipeType = NormalRecipe
	//	c)ѭִ
	//	i.next
	//	ii.FALSEָıѭ
	//	iii.TRUEremainTime += ǰstepstep timeѭ
	//	4.holdStepTime = 0
	//	5.startTime == 0startTime = ǰʱ
	//	newStep == FALSE
	//	1.elapsedTotalTime += TM
	//	2.elapsedStepTime += TM
	//	3.isPausedͣУ
	//	a)holdTotalTime += TM
	//	b)holdStepTime += TM
	//	4.isPaused == FALSEδͣ
	//	a)remainStepTime -= TM
	//	b)remainStepTime < 0
	//	i.remainStepTime = 0
	//	c)remainStepTime >= 0
	//	i.remainTotalTime -= TM
	//	ii.remainTotalTime < 0
	//	1.remainTotalTime = 0

	if (newStep)
	{
		elapsedStepTime = 0;
		remainStepTime = mainStepList.get(currentStepNo)->time;
		if (remainStepTime == 0)
		{
			int currentstepno_c = currentStepNo;
			currentRecipeTypeValue recipetype_c = (currentRecipeTypeValue)currentRecipeType;
			currentStepNo = -1;
			currentRecipeType = currentRecipeTypeValue::NormalRecipe;
			while (true)
			{
				if (next())
				{
					remainTotalTime += mainStepList.get(currentStepNo)->time;
				}
				else
				{
					currentStepNo = currentstepno_c;
					currentRecipeType = recipetype_c;
					break;
				}
			}
			holdStepTime = 0;
			if (startTime ==0)
			{
				//const SYSTEMTIME Currontsystemtime;
				//FILETIME cuttentFileTime;
				//TcSystemTimeToFileTime(&Currontsystemtime, &cuttentFileTime);

				//// תΪ ULONGLONG
				//ULONGLONG ulFileTime = (static_cast<ULONGLONG>(cuttentFileTime.dwHighDateTime) << 32) | cuttentFileTime.dwLowDateTime;

				startTime = sysTime;//ǰʱ

				// ٵ TcEncodeFileTime תΪַ
			
			}
		}
	}
	else
	{
		elapsedTotalTime += TM;
		elapsedStepTime += TM;
		if (isPaused) 
		{
			holdTotalTime += TM;
			holdStepTime += TM;
		}
		else
		{

			remainStepTime -= TM;
			if (remainStepTime < 0)
			{
				remainStepTime = 0;
			}
			else
			{
				remainTotalTime -= TM;
				if (remainTotalTime < 0)
					remainTotalTime = 0;
			}
		}

	}
}



string* RecipeContext::getCommandParam(string command)
{
	EV->postInfoLog("RecipeContext::getCommandParam(string command)");
	string ret = "";
	//ƻȡǰstepĲб
	//	̣
	//	1.ǰǷ򷵻NULL
	//	2.ǰֵвcommandָĹؼ֣NULL
	//	3.commandָؼֵĲб
	//	4.עC++飨ָ룩ûгȣҪNULLָβ

	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		//ret = mainStepList[currentStepNo].commandMap[command];
	}
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{

		//ret = subStepListMap[currentOtherRecipeKey][currentOtherStepNo].commandMap[command];
			
	}

	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		//ret = abortStepListMap[currentOtherRecipeKey][currentOtherStepNo].commandMap[command];
	}

	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		//ret = alarmStepListMap[currentOtherRecipeKey][currentOtherStepNo].commandMap[command];
	}

	return &ret;
}


string RecipeContext::getCurrentStepName()
{
	string ret = "";
	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		ret = mainStepList.get(currentStepNo)->name;
	}
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (subStepListMap.get(cork))->get(currentOtherStepNo)->name;
	}
	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (alarmStepListMap.get(cork))->get(currentOtherStepNo)->name;
	}
	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (abortStepListMap.get(cork))->get(currentOtherStepNo)->name;
	}
	return ret;
}
//string getCurrentRecipeType()	//ǰrecipe
//{
//
//}
int RecipeContext::getCurrentStepNo()
{
	string ret = "";
	
	return currentStepNo;
}
int RecipeContext::getCurrentOtherStepNo()
{
	string ret = "";

	return currentOtherStepNo;
}

RecipeStepInfo* RecipeContext::getCurrentStepInfo()	//ԶʶreciperecipestepϢ
{
	RecipeStepInfo *ret;

	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		ret = mainStepList.get(currentStepNo);
	}
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (subStepListMap.get(cork))->get(currentOtherStepNo);
	}
	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (alarmStepListMap.get(cork))->get(currentOtherStepNo);
	}
	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (abortStepListMap.get(cork))->get(currentOtherStepNo);
	}

	return ret;
}
double RecipeContext::getStepTime()
{
	double ret = 0;
	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		ret = mainStepList.get(currentStepNo)->time;
	}
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (subStepListMap.get(cork))->get(currentOtherStepNo)->time;
	}
	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (alarmStepListMap.get(cork))->get(currentOtherStepNo)->time;
	}
	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		ret = (abortStepListMap.get(cork))->get(currentOtherStepNo)->time;
	}
	return ret;
}
int RecipeContext::getElapsedTotalTime()
{
	string ret = "";

	return elapsedTotalTime;
}
int RecipeContext::getElapsedStepTime()
{
	string ret = "";

	return elapsedStepTime;
}
int RecipeContext::getRemainTotalTime()
{
	string ret = "";

	return remainTotalTime;
}
int RecipeContext::getRemainStepTime()
{
	string ret = "";

	return remainStepTime;
}
int RecipeContext::getHoldTotalTime()
{
	string ret = "";

	return holdTotalTime;
}
int RecipeContext::getHoldStepTime()
{
	string ret = "";

	return holdStepTime;
}
int RecipeContext::getStartTime()
{
	string ret = "";

	return startTime;
}

void RecipeContext::executeStep()
{
	string ret = "";
	//̣
	//	1.ȡrecipeһRecipeContext.next()
flag1:
	bool retnext = next();
	if (retnext == false)
	{
		//	2.nextFALSErecipeExecuteStatus = RecipeCompleted
		recipeExecuteStatus = recipeExecuteStatusValue::RecipeCompleted;
		return;
	}
	//	3.recipeExecuteStatus = ExecStep
	recipeExecuteStatus = recipeExecuteStatusValue::ExecStep;

	//	4.ˢ¼ʱupateTime(TRUE)
	updateTime(true);

	//	5.ȡִеǰstepcommand
	map <string, string> retcommand;
	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		//retcommand = mainStepList[currentStepNo].commandMap;		
	}
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		//retcommand = subStepListMap[currentOtherRecipeKey][currentOtherStepNo].commandMap;
	}
	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		//retcommand = alarmStepListMap[currentOtherRecipeKey][currentOtherStepNo].commandMap;
	}
	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		//retcommand = abortStepListMap[currentOtherRecipeKey][currentOtherStepNo].commandMap;
	}
	map<string, string>::iterator iter;
	for (iter=retcommand.begin();iter!=retcommand.end();iter++)
	{
		OP->select(iter->first.c_str())->Do();
		/*iter->second;*/ //˼²δ 
	}
	
	//	6.step.time == 0recipeExecuteStatus == StepCompletedص1ѭ

	double steptimes = 0;
	if (currentRecipeType == currentRecipeTypeValue::NormalRecipe)
	{
		steptimes = mainStepList.get(currentStepNo)->time;
	}
	if (currentRecipeType == currentRecipeTypeValue::SubRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		steptimes = (subStepListMap.get(cork))->get(currentOtherStepNo)->time;
	}
	if (currentRecipeType == currentRecipeTypeValue::AlarmRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		steptimes = (alarmStepListMap.get(cork))->get(currentOtherStepNo)->time;
	}
	if (currentRecipeType == currentRecipeTypeValue::AbortRecipe)
	{
		char* cork = CovertIntToChar(currentOtherRecipeKey);
		steptimes = (abortStepListMap.get(cork))->get(currentOtherStepNo)->time;
	}

	if (steptimes == 0)
	{
		recipeExecuteStatus = recipeExecuteStatusValue::StepCompleted;
		goto flag1;
	}
	//	7.recipeExecuteStatus = TimeWait
	recipeExecuteStatus = recipeExecuteStatusValue::TimeWait;
	//	8.

	return;
}


void RecipeContext::ParseDataWithRawData()
{
	if (SST != SystemStatus::Run)
	{
		return;
	}
	static char buffer[1024 * 100];
	int popCount = AllDataSession.recvData.pop(buffer);
	if (popCount>0)
	{
		LOG->Log(tlInfo, "RecipeContext::ParseDataWithRawData() buffer[0]= %x,buffer[1]= %x", buffer[0], buffer[1]);
		LOG->Log(tlInfo, "RecipeContext::ParseDataWithRawData() AllDataSession recvData getRecordCount  = '%d'", AllDataSession.recvData.getRecordCount());
		//ȡTagID
		unsigned char five = buffer[0];
		unsigned char six = buffer[1];

		uint16_t tagid = (five << 8) | six;
		//ntoh
		//hton
	    ConvertLittleEndianToBigEndian_((uint8_t*)(buffer + 2), popCount - 2);
		LOG->Log(tlInfo, "RecipeContext tagid = %d ", tagid);
		
		if (tagid == 1)//mainrecipe
		{

			RecipeStepMsgContext* rsmc = BytesToStruct<RecipeStepMsgContext>::FromBytes((uint8_t*)(buffer+2), popCount-2);

			mainStepList.add(rsmc->RecipeStep);
			LOG->Log(tlInfo, "mainStepList.size() = %d", mainStepList.size());

		}
		if (tagid == 2)//subStepListMap
		{
			RecipeStepMsgContext* rsmc = BytesToStruct<RecipeStepMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);

			static char key[20] = "";
			sprintf(key, "%d", rsmc->currentRecipeKey);

			auto sub = subStepListMap.getOrCreate(key);
			sub->add(rsmc->RecipeStep);
		
		}

		if (tagid == 3)//alarmStepListMap
		{
		
			RecipeStepMsgContext* rsmc = BytesToStruct<RecipeStepMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);

			static char key[20] = "";
			sprintf(key, "%d", rsmc->currentRecipeKey);

			auto sub = alarmStepListMap.getOrCreate(key);
			sub->add(rsmc->RecipeStep);

		}

		if (tagid == 4)//abortStepListMap
		{

			RecipeStepMsgContext* rsmc = BytesToStruct<RecipeStepMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);
			static char key[20] = "";
			sprintf(key, "%d", rsmc->currentRecipeKey);
			auto sub = abortStepListMap.getOrCreate(key);
			sub->add(rsmc->RecipeStep);

		}

		if (tagid == 5)
		{
			RecipeCheckerMsgContext* rc = BytesToStruct<RecipeCheckerMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);

			checkerList.add(rc->RecipeChk);
		}
		if (tagid == 6)
		{
			AlarmConditionMsgContext* ac = BytesToStruct<AlarmConditionMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);

			auto sub = alarmConditionDic.getOrCreate(CovertIntToChar(ac->currentAlarmConditionKey1));
			sub->set(ac->currentAlarmConditionKey2, ac->AlarmCdt);
		}

		if (tagid == 7)
		{
			TempProfileMsgContext* tp = BytesToStruct<TempProfileMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);

			auto sub = tempProfileDic.getOrCreate(CovertIntToChar(tp->currentTempProfileKey1));
			sub->set(tp->currentTempProfileKey2, tp->TempPrf);

		}

		if (tagid == 8)
		{
			TempPIDMsgContext* tp = BytesToStruct<TempPIDMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);
			auto sub = tempPIDDic.getOrCreate(CovertIntToChar(tp->currentTempPIDKey1));
			sub->set(tp->currentTempPIDKey2, tp->TmpPID);
		}

		if (tagid == 9)
		{
			TempCorrectionMsgContext* tp = BytesToStruct<TempCorrectionMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);

			auto sub = tempCorrectionDic.getOrCreate(CovertIntToChar(tp->currentTempCorrectionKey1));
			sub->set(tp->currentTempCorrectionKey2, tp->TmpCorrection);

			int len = tempCorrectionDic.length;

			LOG->Log(tlInfo, "tempCorrectionDic.length = %d", len);
		}
		if (tagid == 10)
		{
			APCPIDMsgContext* tp = BytesToStruct<APCPIDMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);
			auto sub = apcPIDDic.getOrCreate(CovertIntToChar(tp->currentAPCPIDKey1));
			sub->set(tp->currentAPCPIDKey2, tp->_apcpid);

			int len = apcPIDDic.length;

			LOG->Log(tlInfo, "apcPIDDic.length = %d", len);
		}
		if (tagid == 11)
		{
			LeakCheckMsgContext* tp = BytesToStruct<LeakCheckMsgContext>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);
			auto sub = leakCheckDic.getOrCreate(CovertIntToChar(tp->currentLeakCheckKey1));
			sub->set(tp->currentLeakCheckKey2, tp->Lkc);	
		}

		if (tagid == 21)
		{
			CommandkeySt* cks = BytesToStruct<CommandkeySt>::FromBytes((uint8_t*)(buffer + 2), popCount - 2);
			if (cks->CKey == (int)CommandKey::Execute)
			{
				//жǷִ
				{
				
				}
				recipeExecuteStatus = recipeExecuteStatusValue::Idle;

				recipeExecuteCommand = recipeExecuteCommandValue::Execute;
				baseDataDownloadStatus = baseDataDownloadStatusValue::Done;
				recipeDataDownloadStatus = recipeDataDownloadStatusValue::Done;
			}
			if (cks->CKey == (int)CommandKey::Abort)
			{
				//жǷAbort
				{

				}
				//װһabort
				{
				
				}
				recipeExecuteStatus = recipeExecuteStatusValue::Error;

				recipeExecuteCommand = recipeExecuteCommandValue::Abort;

				ClearDicAndLisrData();
			}
			if (cks->CKey == (int)CommandKey::Hold)
			{
				//жǷAbort
				{

				}
				recipeExecuteStatus = recipeExecuteStatusValue::Paused;
				recipeExecuteCommand = recipeExecuteCommandValue::Hold;

			}
			if (cks->CKey == (int)CommandKey::Release)
			{
				//жǷAbort
				{

				}
				recipeExecuteStatus = recipeExecuteStatusValue::ExecStep;
				recipeExecuteCommand = recipeExecuteCommandValue::Release;

			}
			if (cks->CKey == (int)CommandKey::Skip)
			{
				//жǷSkip
				{

				}
				//recipeExecuteStatus = recipeExecuteStatusValue::ExecStep;
				//recipeExecuteCommand = recipeExecuteCommandValue::Release;

			}
		}

	}
	
	return;

}





void RecipeContext::PackageDataAndSendBufferData()
{
	if (SST != SystemStatus::Run)
	{
		return;
	}
	//vector<BYTE> send1;
	
	//1㳤
	//int sendlength = sd.size() + 4;
	//LOG->Log(tlInfo, "sendlength  =  '%d'",sendlength);
	//BYTE length[2];
	//length[1] = sendlength & 0xFF;
	//length[0] = (sendlength >> 8) & 0xFF;

	//for (size_t i = 0; i < 2; i++)
	//{
	//	//LOG->Log(tlInfo, "length[%d]  =  '%#x'", i, length[i]);
	//	send1.push_back(length[i]);
	//}
	//send1[0] = length[0];
	//send1[1] = length[1];
	//LOG->Log(tlInfo, "1  end");
	//2,Ϣ
	//send1[2] = 0x05;
	//send1[3] = 0x09;
	//send1.push_back(0x05);
	//send1.push_back(0x09);
	//LOG->Log(tlInfo, "2  end");
	//3tagid
	//send1[4] = 0x00;
	//send1[5] = 0x08;
	//send1.push_back(0x00);
	//send1.push_back(0x08);
	//LOG->Log(tlInfo, "3  end");
	//4sd
	//for (size_t i = 0; i < sd.size(); i++)
	//{
	//	send1.push_back(sd[i]);
	//	//LOG->Log(tlInfo, "send1[%d+6] = sd[%d]", i,i);
	//}
	//LOG->Log(tlInfo, "4  end");
	//for (size_t i = 0; i < send1.size(); i++)
	//{
	//	LOG->Log(tlInfo, "send1[%d]  =  '%#x'", i, send1[i]);

	//}
	//5 ׷ӵSendAllData
	//SendAllData.push(send1);

	
	return;
}

char* RecipeContext::CovertIntToChar(int key)
{
	static char keys[20] = {};
	sprintf(keys, "%d", key);
	return keys;
}

void RecipeContext::ClearDicAndLisrData()
{
	AllDataSession.sendData.clear();
	AllDataSession.recvData.clear();
	mainStepList.clear();
	subStepListMap.clear();
	abortStepListMap.clear();
	alarmStepListMap.clear();
	checkerList.clear();
	alarmConditionDic.clear();
	tempProfileDic.clear();
	tempPIDDic.clear();
	tempCorrectionDic.clear();
	apcPIDDic.clear();
	leakCheckDic.clear();
}

char* RecipeContext::getRawData(char* buffer, int bufferSize)
{
	if (bufferSize <= 2) return nullptr;  // ߽

	int newSize = bufferSize - 2;
	char* newArray = new char[newSize];

	// ǰԪ(buffer+2)ʣ
	memcpy(newArray, buffer + 2, newSize);

	return newArray;
}