///////////////////////////////////////////////////////////////////////////////
// ModuleMoniter.cpp
#include "TcPch.h"
#pragma hdrstop

#include "ModuleMoniter.h"
#include "Common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif
#include "RecipeContext.h"
#include"pmc_types.h"
#include"BoatModule.h"
#include"Simulator.h"
DEFINE_THIS_FILE()
void* ioModule;
///////////////////////////////////////////////////////////////////////////////
// CModuleMoniter
///////////////////////////////////////////////////////////////////////////////
Common com;
//RecipeContext rcpt;
///////////////////////////////////////////////////////////////////////////////
// Collection of interfaces implemented by module CModuleMoniter
BEGIN_INTERFACE_MAP(CModuleMoniter)
	INTERFACE_ENTRY_ITCOMOBJECT()
	INTERFACE_ENTRY(IID_ITcADI, ITcADI)
	INTERFACE_ENTRY(IID_ITcWatchSource, ITcWatchSource)
///<AutoGeneratedContent id="InterfaceMap">
	INTERFACE_ENTRY(IID_ITcCyclic, ITcCyclic)
///</AutoGeneratedContent>
END_INTERFACE_MAP()


IMPLEMENT_ITCOMOBJECT(CModuleMoniter)
IMPLEMENT_ITCOMOBJECT_SETSTATE_LOCKOP2(CModuleMoniter)
IMPLEMENT_ITCADI(CModuleMoniter)
IMPLEMENT_ITCWATCHSOURCE(CModuleMoniter)


///////////////////////////////////////////////////////////////////////////////
// Set parameters of CModuleMoniter 
BEGIN_SETOBJPARA_MAP(CModuleMoniter)
	SETOBJPARA_DATAAREA_MAP()
///<AutoGeneratedContent id="SetObjectParameterMap">
	SETOBJPARA_VALUE(PID_TcTraceLevel, m_TraceLevelMax)
	SETOBJPARA_VALUE(PID_ModuleMoniterParameter, m_Parameter)
	SETOBJPARA_ITFPTR(PID_Ctx_TaskOid, m_spCyclicCaller)
///</AutoGeneratedContent>
END_SETOBJPARA_MAP()

///////////////////////////////////////////////////////////////////////////////
// Get parameters of CModuleMoniter 
BEGIN_GETOBJPARA_MAP(CModuleMoniter)
	GETOBJPARA_DATAAREA_MAP()
///<AutoGeneratedContent id="GetObjectParameterMap">
	GETOBJPARA_VALUE(PID_TcTraceLevel, m_TraceLevelMax)
	GETOBJPARA_VALUE(PID_ModuleMoniterParameter, m_Parameter)
	GETOBJPARA_ITFPTR(PID_Ctx_TaskOid, m_spCyclicCaller)
///</AutoGeneratedContent>
END_GETOBJPARA_MAP()

///////////////////////////////////////////////////////////////////////////////
// Get watch entries of CModuleMoniter
BEGIN_OBJPARAWATCH_MAP(CModuleMoniter)
	OBJPARAWATCH_DATAAREA_MAP()
///<AutoGeneratedContent id="ObjectParameterWatchMap">
///</AutoGeneratedContent>
END_OBJPARAWATCH_MAP()

///////////////////////////////////////////////////////////////////////////////
// Get data area members of CModuleMoniter
BEGIN_OBJDATAAREA_MAP(CModuleMoniter)
///<AutoGeneratedContent id="ObjectDataAreaMap">
	OBJDATAAREA_VALUE(ADI_ModuleMoniterAI, m_AI)
	OBJDATAAREA_VALUE(ADI_ModuleMoniterNDI, m_NDI)
	OBJDATAAREA_VALUE(ADI_ModuleMoniterSDI, m_SDI)
	OBJDATAAREA_VALUE(ADI_ModuleMoniterAO, m_AO)
	OBJDATAAREA_VALUE(ADI_ModuleMoniterNDO, m_NDO)
	OBJDATAAREA_VALUE(ADI_ModuleMoniterSDO, m_SDO)
///</AutoGeneratedContent>
END_OBJDATAAREA_MAP()


///////////////////////////////////////////////////////////////////////////////
CModuleMoniter::CModuleMoniter()
	: m_Trace(m_TraceLevelMax, m_spSrv)
	, m_counter(0)
{
///<AutoGeneratedContent id="MemberInitialization">
	m_TraceLevelMax = tlAlways;
	memset(&m_Parameter, 0, sizeof(m_Parameter));
	memset(&m_AI, 0, sizeof(m_AI));
	memset(&m_NDI, 0, sizeof(m_NDI));
	memset(&m_SDI, 0, sizeof(m_SDI));
	memset(&m_AO, 0, sizeof(m_AO));
	memset(&m_NDO, 0, sizeof(m_NDO));
	memset(&m_SDO, 0, sizeof(m_SDO));
///</AutoGeneratedContent>
	INIT_MODULE_DEVICE_WITH_IO
}

///////////////////////////////////////////////////////////////////////////////
CModuleMoniter::~CModuleMoniter() 
{
}


///////////////////////////////////////////////////////////////////////////////
// State Transitions 
///////////////////////////////////////////////////////////////////////////////
IMPLEMENT_ITCOMOBJECT_SETOBJSTATE_IP_PI(CModuleMoniter)

///////////////////////////////////////////////////////////////////////////////
// State transition from PREOP to SAFEOP
//
// Initialize input parameters 
// Allocate memory
HRESULT CModuleMoniter::SetObjStatePS(PTComInitDataHdr pInitData)
{
	m_Trace.Log(tlVerbose, FENTERA);
	HRESULT hr = S_OK;
	IMPLEMENT_ITCOMOBJECT_EVALUATE_INITDATA(pInitData);

	// TODO: Add initialization code

	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///////////////////////////////////////////////////////////////////////////////
// State transition from SAFEOP to OP
//
// Register with other TwinCAT objects
HRESULT CModuleMoniter::SetObjStateSO()
{
	m_Trace.Log(tlVerbose, FENTERA);
	HRESULT hr = S_OK;

	// TODO: Add any additional initialization


	// If following call is successful the CycleUpdate method will be called, 
	// possibly even before method has been left.
	hr = FAILED(hr) ? hr : AddModuleToCaller(); 

	// Cleanup if transition failed at some stage
	if ( FAILED(hr) )
	{
		RemoveModuleFromCaller(); 
		return hr;
	}
	logger->info("Initialize...");
	initEnvironment();
	int count = DEVICE->getDeviceCount();
	logger->info("Device count=%d", count);
	
	for (int index = 0; index < count; index++) {
		BaseDevice* device = DEVICE->getDeviceByIndex(index);
		device->initialize();
	}
	boatModule->initialize();

#if defined( _DEBUG ) && defined(_WITH_SIMULATOR)
	simulatorSet();
#endif
	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///////////////////////////////////////////////////////////////////////////////
// State transition from OP to SAFEOP
HRESULT CModuleMoniter::SetObjStateOS()
{
	m_Trace.Log(tlVerbose, FENTERA);

	HRESULT hr = S_OK;

	RemoveModuleFromCaller(); 

	// TODO: Add any additional deinitialization
	//豸temrinate
	int count = DEVICE->getDeviceCount();
	//boatModule->terminate();
	for (int index = 0; index < count; index++) {
		BaseDevice* device = DEVICE->getDeviceByIndex(index);
		device->terminate();
	}
	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///////////////////////////////////////////////////////////////////////////////
// State transition from SAFEOP to PREOP
HRESULT CModuleMoniter::SetObjStateSP()
{
	HRESULT hr = S_OK;
	m_Trace.Log(tlVerbose, FENTERA);

	// TODO: Add deinitialization code

	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///<AutoGeneratedContent id="ImplementationOf_ITcCyclic">
HRESULT CModuleMoniter::CycleUpdate(ITcTask* ipTask, ITcUnknown* ipCaller, ULONG_PTR context)
{
	HRESULT hr = S_OK;
	//TODODOıֺDIĵȴȫԵģִ
	DeviceAttribute::checkHoldDoTable();
	DeviceAttribute::checkWaitDiTable();
	//TODOҪ棬Ҳÿζѯ
#if defined( _DEBUG ) && defined(_WITH_SIMULATOR)
	simulatorMonitor();
#endif

	if (SST != SystemStatus::Run)
	{
		return hr;
	}

	// TODO: Replace the sample with your cyclic code
	//m_counter+=m_Inputs.Value;
	//m_Outputs.Value=m_counter;
	//m_Outputs.TestMoniterValue = 
	m_counter++;
	//if (m_counter % 100 ==0)
	{

		//ִ RecipeContext;
		if (m_counter % 3 == 0 && m_counter % 5 != 0 && m_counter % 7 != 0)
		{

			RecipeContext::GetInstance()->ParseDataWithRawData();			//ӻRaw
		}
		//if (m_counter % 3 != 0 && m_counter % 5 == 0 && m_counter % 7 != 0)
		//{
		//	//RecipeContext::GetInstance()->PackageDataAndSendBufferData();	//Ҫ͵
		//}
		//if (m_counter % 3 != 0 && m_counter % 5 != 0 && m_counter % 7 == 0)
		{
			RecipeContext::GetInstance()->Moniter();						//ִ
		}
	}

	return hr;
}
///</AutoGeneratedContent>

///////////////////////////////////////////////////////////////////////////////
HRESULT CModuleMoniter::AddModuleToCaller()
{
	m_Trace.Log(tlVerbose, FENTERA);

	HRESULT hr = S_OK;
	if ( m_spCyclicCaller.HasOID() )
	{
		if ( SUCCEEDED_DBG(hr = m_spSrv->TcQuerySmartObjectInterface(m_spCyclicCaller)) )
		{
			if ( FAILED(hr = m_spCyclicCaller->AddModule(m_spCyclicCaller, THIS_CAST(ITcCyclic))) )
			{
				m_spCyclicCaller = NULL;
			}
		}
	}
	else
	{
		hr = ADS_E_INVALIDOBJID; 
		SUCCEEDED_DBGT(hr, "Invalid OID specified for caller task");
	}

	m_Trace.Log(tlVerbose, FLEAVEA "hr=0x%08x", hr);
	return hr;
}

///////////////////////////////////////////////////////////////////////////////
VOID CModuleMoniter::RemoveModuleFromCaller()
{
	m_Trace.Log(tlVerbose, FENTERA);

	if ( m_spCyclicCaller )
	{
		m_spCyclicCaller->RemoveModule(m_spCyclicCaller);
	}
	m_spCyclicCaller	= NULL;

	m_Trace.Log(tlVerbose, FLEAVEA);
}

