#include"TcPch.h"
#pragma hdrstop
#include"IoFurnaceMotor.h"
#include"DEVICE.h"
#include"SC.h"
#include"debug.h"

IoFurnaceMotor::IoFurnaceMotor(const char* className,const char* name,const char* module):BaseDevice(className, name, module){
	memset(&scPositions, '\0', sizeof(scPositions));
}
void IoFurnaceMotor::initialize() {
	char scName[MAX_NAME_LEN];
	char* ptrValue;
	sprintf(scName, "Boat.SlotCount");
	ptrValue = (char*)SC->getStringValue(scName);
	if (ptrValue != NULL && ptrValue[0] != '\0') {
		scSlotCount = atol(ptrValue);
	}
	sprintf(scName, "Boat.%s.MotionTimeout", name);
	ptrValue = (char*)SC->getStringValue(scName);
	if (ptrValue != NULL && ptrValue[0] != '\0') {
		scMotionTimeout = atol(ptrValue) * 1000;
	}

	sprintf(scName, "Boat.%s.CycleCount", name);
	ptrValue = (char*)SC->getStringValue(scName);
	if (ptrValue != NULL && ptrValue[0] != '\0') {
		scCycleCount = atol(ptrValue);
	}
	sprintf(scName, "Boat.%s.MoveSpeed", name);
	ptrValue = (char*)SC->getStringValue(scName);
	if (ptrValue != NULL && ptrValue[0] != '\0') {
		scMoveSpeed = atof(ptrValue);
	}
	sprintf(scName, "Boat.%s.Acc", name);
	ptrValue = (char*)SC->getStringValue(scName);
	if (ptrValue != NULL && ptrValue[0] != '\0') {
		scAcc = atof(ptrValue);
	}
	sprintf(scName, "Boat.%s.Dec", name);
	ptrValue = (char*)SC->getStringValue(scName);
	if (ptrValue != NULL && ptrValue[0] != '\0') {
		scDec = atof(ptrValue);
	}
	for (int i = 1; i < sizeof(scPositions) / sizeof(double); i++) {
		sprintf(scName, "Boat.%s.Position%d", name, i);
		ptrValue = (char*)SC->getStringValue(scName);
		if (ptrValue != NULL && ptrValue[0] != '\0') {
			scPositions[i] = atof(ptrValue);
		}
	}
}

//AUTOIO_BEGIN
IoFurnaceMotor* _initBoatElevatorServo_0(){
	static IoFurnaceMotor staticBoatElevatorServo("IoFurnaceMotor","BoatElevatorServo",MODULE_NAME);
	IoFurnaceMotor::poBoatElevatorServo=&staticBoatElevatorServo;
	IoFurnaceMotor* dev=&staticBoatElevatorServo;
	strcpy(dev->id,"BoatElevatorServo");
	strcpy(dev->display,"");
	strcpy(dev->schematicId,"");
	strcpy(dev->unit,"");
	dev->aiRealPosition.create("aiRealPosition",&AI->BoatMotorPositionFeedback,"AI.BoatMotorPositionFeedback",TRUE);
	dev->aiRealSpeed.create("aiRealSpeed",&AI->BoatMotorSpeedFb,"AI.BoatMotorSpeedFb",TRUE);
	dev->aiTargetPosFb.create("aiTargetPosFb",&AI->BoatTargetPosFb,"AI.BoatTargetPosFb",TRUE);
	dev->aiDriverErrorCode.create("aiDriverErrorCode",&AI->BoatDriverErrCode,"AI.BoatDriverErrCode",TRUE);
	dev->aiMotionErrorCode.create("aiMotionErrorCode");
	return dev;
}
IoFurnaceMotor* _initBoatElevatorServo_1(IoFurnaceMotor *dev){
	dev->aoTargetPosition.create("aoTargetPosition",&AO->BoatPosition,"AO.BoatPosition",FALSE);
	dev->aoTargetSpeed.create("aoTargetSpeed",&AO->BoatRotationSpeed,"AO.BoatRotationSpeed",FALSE);
	dev->aoAcc.create("aoAcc");
	dev->aoDec.create("aoDec");
	dev->diOpen.create("diOpen",&NDI->Furnace_shutter_open,"NDI.Furnace_shutter_open",TRUE);
	dev->diClose.create("diClose",&NDI->Furnace_shutter_close,"NDI.Furnace_shutter_close",TRUE);
	dev->diServoOn.create("diServoOn",&NDI->PwrBusyBoatZAxis,"NDI.PwrBusyBoatZAxis",TRUE);
	dev->diMotorAlarm.create("diMotorAlarm",&NDI->PwrErrBufferAxis,"NDI.PwrErrBufferAxis",TRUE);
	dev->diMove.create("diMove");
	dev->diPowerOn.create("diPowerOn");
	return dev;
}
IoFurnaceMotor* _initBoatElevatorServo_2(IoFurnaceMotor *dev){
	dev->diPowerOnError.create("diPowerOnError");
	dev->diStop.create("diStop");
	dev->diStopError.create("diStopError");
	dev->diHomeDone.create("diHomeDone");
	dev->diAlignDone.create("diAlignDone");
	dev->diHoming.create("diHoming");
	dev->diHomeError.create("diHomeError");
	dev->diMoving.create("diMoving",&NDI->MvAbsBusyBoatZAxis,"NDI.MvAbsBusyBoatZAxis",TRUE);
	dev->diMoveError.create("diMoveError");
	dev->diHomePosition.create("diHomePosition",&NDI->HmPosBoatZAxis,"NDI.HmPosBoatZAxis",TRUE);
	return dev;
}
IoFurnaceMotor* _initBoatElevatorServo_3(IoFurnaceMotor *dev){
	dev->diNegativeLimit.create("diNegativeLimit",&NDI->NegLmtPosBoatZAxis,"NDI.NegLmtPosBoatZAxis",TRUE);
	dev->diPositiveLimit.create("diPositiveLimit",&NDI->PotLmtPosBoatZAxis,"NDI.PotLmtPosBoatZAxis",TRUE);
	dev->diConveyRelaxAlarm.create("diConveyRelaxAlarm");
	dev->diReadyToSwitchOn.create("diReadyToSwitchOn",&NDI->ReadytoSwitchOnBoatZAxis,"NDI.ReadytoSwitchOnBoatZAxis",TRUE);
	dev->diSwitchOn.create("diSwitchOn",&NDI->SwitchedOnBoatZAxis,"NDI.SwitchedOnBoatZAxis",TRUE);
	dev->diWarning.create("diWarning");
	dev->diAlarm.create("diAlarm",&NDI->BoatFaultBoatZAxis,"NDI.BoatFaultBoatZAxis",TRUE);
	dev->diPosition1.create("diPosition1",&NDI->MiddlePos1BoatZAxis,"NDI.MiddlePos1BoatZAxis",TRUE);
	dev->diPosition2.create("diPosition2",&NDI->MiddlePos2BoatZAxis,"NDI.MiddlePos2BoatZAxis",TRUE);
	dev->diPosition3.create("diPosition3",&NDI->MiddlePos3BoatZAxis,"NDI.MiddlePos3BoatZAxis",TRUE);
	return dev;
}
IoFurnaceMotor* _initBoatElevatorServo_4(IoFurnaceMotor *dev){
	dev->diUpPosition.create("diUpPosition",&NDI->BoatLiftMotorUpPosition,"NDI.BoatLiftMotorUpPosition",TRUE);
	dev->diDownPosition.create("diDownPosition",&NDI->BoatLiftMotorDownPosition,"NDI.BoatLiftMotorDownPosition",TRUE);
	dev->doOpen.create("doOpen",&NDO->Furnace_shutter_open,"NDO.Furnace_shutter_open",FALSE);
	dev->doClose.create("doClose",&NDO->Furnace_shutter_close,"NDO.Furnace_shutter_close",FALSE);
	dev->doStop.create("doStop",&NDO->StopBoatZAxis,"NDO.StopBoatZAxis",FALSE);
	dev->doHome.create("doHome");
	dev->doMove.create("doMove",&NDO->MoveEnableBoatZAxis,"NDO.MoveEnableBoatZAxis",FALSE);
	dev->doReset.create("doReset",&NDO->ResetBoatZAxis,"NDO.ResetBoatZAxis",FALSE);
	dev->doServoOn.create("doServoOn",&NDO->ServoOnBoatZAxis,"NDO.ServoOnBoatZAxis",FALSE);
	dev->doInTransfer.create("doInTransfer");
	return dev;
}
IoFurnaceMotor* _initBoatElevatorServo_5(IoFurnaceMotor *dev){
	dev->doTransferComplete.create("doTransferComplete");
	dev->doStepperDriverStart.create("doStepperDriverStart");
	dev->doStepperDriverAllWindingsOff.create("doStepperDriverAllWindingsOff");
	dev->doStepperDriverDataSelectionM0.create("doStepperDriverDataSelectionM0");
	dev->doStepperDriverDataSelectionM1.create("doStepperDriverDataSelectionM1");
	dev->doStepperDriverDataSelectionM2.create("doStepperDriverDataSelectionM2");
	dev->doStepperDriverDataSelectionM3.create("doStepperDriverDataSelectionM3");
	dev->doStepperDriverDataSelectionM4.create("doStepperDriverDataSelectionM4");
	dev->doStepperDriverDataSelectionM5.create("doStepperDriverDataSelectionM5");
	dev->doStepperDriverHomeOrPosPrerst.create("doStepperDriverHomeOrPosPrerst");
	return dev;
}
IoFurnaceMotor* _initBoatElevatorServo_6(IoFurnaceMotor *dev){
	dev->doCW.create("doCW");
	dev->doCCW.create("doCCW");
	strcpy(dev->aioType,"float");
	strcpy(dev->scRootPath,"Boat.BoatElevatorServo");
	return dev;
}
IoFurnaceMotor* _initBoatRotationServo_0(){
	static IoFurnaceMotor staticBoatRotationServo("IoFurnaceMotor","BoatRotationServo",MODULE_NAME);
	IoFurnaceMotor::poBoatRotationServo=&staticBoatRotationServo;
	IoFurnaceMotor* dev=&staticBoatRotationServo;
	strcpy(dev->id,"BoatRotationServo");
	strcpy(dev->display,"");
	strcpy(dev->schematicId,"");
	strcpy(dev->unit,"");
	dev->aiRealPosition.create("aiRealPosition");
	dev->aiRealSpeed.create("aiRealSpeed",&AI->CapsSpeedFb,"AI.CapsSpeedFb",TRUE);
	dev->aiPowerErrorCode.create("aiPowerErrorCode");
	dev->aiStopErrorCode.create("aiStopErrorCode");
	dev->aiHomeErrorCode.create("aiHomeErrorCode");
	return dev;
}
IoFurnaceMotor* _initBoatRotationServo_1(IoFurnaceMotor *dev){
	dev->aiMoveAbsErrorCode.create("aiMoveAbsErrorCode");
	dev->aiJogErrorCode.create("aiJogErrorCode");
	dev->aiResetErrorCode.create("aiResetErrorCode");
	dev->aiDriverErrorCode.create("aiDriverErrorCode");
	dev->aiErrorCode.create("aiErrorCode");
	dev->aoTargetSpeed.create("aoTargetSpeed",&AO->RotationSpeed,"AO.RotationSpeed",FALSE);
	dev->diMotorAlarm.create("diMotorAlarm");
	dev->diMove.create("diMove");
	dev->diPowerOn.create("diPowerOn");
	dev->diPowerOnError.create("diPowerOnError");
	return dev;
}
IoFurnaceMotor* _initBoatRotationServo_2(IoFurnaceMotor *dev){
	dev->diStop.create("diStop");
	dev->diStopError.create("diStopError");
	dev->doBoatFinish.create("doBoatFinish",&NDO->GetBoatFinish,"NDO.GetBoatFinish",FALSE);
	dev->doBoatAllow.create("doBoatAllow",&NDO->GetBoatAllow,"NDO.GetBoatAllow",FALSE);
	dev->doBoatstart.create("doBoatstart",&NDO->GetBoatStart,"NDO.GetBoatStart",FALSE);
	dev->doExtend.create("doExtend",&NDO->R_axis_air_cylinder_extend_switch,"NDO.R_axis_air_cylinder_extend_switch",FALSE);
	dev->doRetract.create("doRetract",&NDO->R_axis_air_cylinder_retract_switch,"NDO.R_axis_air_cylinder_retract_switch",FALSE);
	dev->diHoming.create("diHoming",&NDI->BoatRAxisHomeBusy,"NDI.BoatRAxisHomeBusy",TRUE);
	dev->diInitializing.create("diInitializing");
	dev->diHomeDone.create("diHomeDone",&NDI->BoatRAxisInHomePosition,"NDI.BoatRAxisInHomePosition",TRUE);
	return dev;
}
IoFurnaceMotor* _initBoatRotationServo_3(IoFurnaceMotor *dev){
	dev->diInitDone.create("diInitDone");
	dev->diMoving.create("diMoving",&NDI->BoatRAxisMoving,"NDI.BoatRAxisMoving",TRUE);
	dev->diMoveError.create("diMoveError");
	dev->diHomePosition.create("diHomePosition",&NDI->BoatRAxisHomeDone,"NDI.BoatRAxisHomeDone",TRUE);
	dev->diNegativeLimit.create("diNegativeLimit");
	dev->diPositiveLimit.create("diPositiveLimit");
	dev->diConveyRelaxAlarm.create("diConveyRelaxAlarm");
	dev->diReadyToSwitchOn.create("diReadyToSwitchOn");
	dev->diSwitchOn.create("diSwitchOn");
	dev->diWarning.create("diWarning");
	return dev;
}
IoFurnaceMotor* _initBoatRotationServo_4(IoFurnaceMotor *dev){
	dev->diAlarm.create("diAlarm",&NDI->BoatRAxisAlarm,"NDI.BoatRAxisAlarm",TRUE);
	dev->diPosition1.create("diPosition1");
	dev->diStepperMotorInWorkPosition.create("diStepperMotorInWorkPosition");
	dev->diStepperMotorMoving.create("diStepperMotorMoving");
	dev->diStepperMotorAlarm.create("diStepperMotorAlarm");
	dev->diStepperMotorInArea.create("diStepperMotorInArea");
	dev->diStepperMotorInReady.create("diStepperMotorInReady");
	dev->diStepperMotorInHomePosition.create("diStepperMotorInHomePosition");
	dev->diUpPosition.create("diUpPosition");
	dev->diDownPosition.create("diDownPosition");
	return dev;
}
IoFurnaceMotor* _initBoatRotationServo_5(IoFurnaceMotor *dev){
	dev->doStop.create("doStop",&NDO->BoatRAxisStop,"NDO.BoatRAxisStop",FALSE);
	dev->doHome.create("doHome",&NDO->BoatRAxisHomeCmd,"NDO.BoatRAxisHomeCmd",FALSE);
	dev->doInit.create("doInit");
	dev->doMove.create("doMove",&NDO->BoatRAxisRotationCmd,"NDO.BoatRAxisRotationCmd",FALSE);
	dev->doReset.create("doReset",&NDO->BoatRAxisAlarmReset,"NDO.BoatRAxisAlarmReset",FALSE);
	dev->doM0.create("doM0");
	dev->doM1.create("doM1");
	dev->doM2.create("doM2");
	dev->doM3.create("doM3");
	dev->doM4.create("doM4");
	return dev;
}
IoFurnaceMotor* _initBoatRotationServo_6(IoFurnaceMotor *dev){
	dev->doM5.create("doM5");
	dev->doCW.create("doCW",&NDO->BoatRAxisRotationForward,"NDO.BoatRAxisRotationForward",FALSE);
	dev->doCCW.create("doCCW",&NDO->BoatRAxisRotationReverse,"NDO.BoatRAxisRotationReverse",FALSE);
	strcpy(dev->aioType,"float");
	strcpy(dev->scRootPath,"Boat.BoatRotationServo");
	return dev;
}
void initIoFurnaceMotor(){
	IoFurnaceMotor* dev;
	dev=_initBoatElevatorServo_0();
	_initBoatElevatorServo_1(dev);
	_initBoatElevatorServo_2(dev);
	_initBoatElevatorServo_3(dev);
	_initBoatElevatorServo_4(dev);
	_initBoatElevatorServo_5(dev);
	_initBoatElevatorServo_6(dev);
	dev=_initBoatRotationServo_0();
	_initBoatRotationServo_1(dev);
	_initBoatRotationServo_2(dev);
	_initBoatRotationServo_3(dev);
	_initBoatRotationServo_4(dev);
	_initBoatRotationServo_5(dev);
	_initBoatRotationServo_6(dev);
}
IoFurnaceMotor* IoFurnaceMotor::poBoatElevatorServo=NULL;
IoFurnaceMotor* IoFurnaceMotor::poBoatRotationServo=NULL;
//AUTOIO_END
