///////////////////////////////////////////////////////////////////////////////
// FurancePMCServices.h

#pragma once

#include "TcServices.h"

const ULONG DrvID_FurancePMC = 0x3F000000;
#define SRVNAME_FURANCEPMC "FurancePMC"

///<AutoGeneratedContent id="ClassIDs">
const CTCID CID_FurancePMCCMain = {0x1d93a058,0xc924,0x46d1,{0xb6,0x61,0xa6,0xb9,0x03,0xa4,0xdb,0xf7}};
const CTCID CID_FurancePMCCModuleMoniter = {0x27facd25,0xcae3,0x4b3a,{0xb6,0x4b,0xed,0x0a,0xb7,0xda,0x4f,0x50}};
///</AutoGeneratedContent>

///<AutoGeneratedContent id="ParameterIDs">
const PTCID PID_MainParameter = 0x00000001;
const PTCID PID_MainTcpServerPort = 0x00000003;
const PTCID PID_MainTcpServerIpAddress = 0x00000004;
const PTCID PID_MainLocalHost = 0x00000005;
const PTCID PID_MainIpTcp = 0x00000002;
const PTCID PID_ModuleMoniterParameter = 0x00000001;
///</AutoGeneratedContent>

///<AutoGeneratedContent id="DataTypes">
#if !defined(_TC_TYPE_7CECC506_F55F_4594_B611_972D650865D2_INCLUDED_)
#define _TC_TYPE_7CECC506_F55F_4594_B611_972D650865D2_INCLUDED_
enum TCPIP_EVENT : ULONG {
	TCPIP_EVENT_NONE = 0,
	TCPIP_EVENT_ERROR = 1,
	TCPIP_EVENT_RESET = 2,
	TCPIP_EVENT_TIMEOUT = 3,
	TCPIP_EVENT_CONN_ESTABLISHED = 4,
	TCPIP_EVENT_CONN_INCOMING = 5,
	TCPIP_EVENT_CONN_CLOSED = 6,
	TCPIP_EVENT_CONN_IDLE = 7,
	TCPIP_EVENT_DATA_RECEIVED = 8,
	TCPIP_EVENT_DATA_SENT = 9,
	TCPIP_EVENT_KEEP_ALIVE = 10,
	TCPIP_EVENT_LINKCONNECT = 11,
	TCPIP_EVENT_LINKDISCONNECT = 12
};
#endif // !defined(_TC_TYPE_7CECC506_F55F_4594_B611_972D650865D2_INCLUDED_)

#if !defined(_TC_TYPE_18071995_0000_0000_0000_00000000003E_INCLUDED_)
#define _TC_TYPE_18071995_0000_0000_0000_00000000003E_INCLUDED_
typedef BYTE IPADDR[4];
#endif // !defined(_TC_TYPE_18071995_0000_0000_0000_00000000003E_INCLUDED_)

typedef struct _MainParameter
{
	ULONG data1;
	ULONG data2;
	double data3;
} MainParameter, *PMainParameter;

typedef struct _MainInputs
{
	ULONG Value;
	ULONG Status;
	ULONG Data;
} MainInputs, *PMainInputs;

#pragma pack(push,1)
typedef struct _MainOutputs
{
	ULONG Value;
	ULONG Control;
	ULONG Data;
	SHORT TestMoniterValue;
} MainOutputs, *PMainOutputs;
#pragma pack(pop)

typedef struct _ModuleMoniterParameter
{
	ULONG data1;
	ULONG data2;
	double data3;
} ModuleMoniterParameter, *PModuleMoniterParameter;

typedef struct _ModuleMoniterAI
{
	float N2_4_Purge_Pressure1;
	float N2_4_Purge_Pressure2;
	float N2_5_Purge_Pressure;
	float N2_6_Purge_Pressure;
	float N2_7_Purge_Pressure;
	float PS17_value;
	float PG3_Pressure;
	float PG4_Pressure;
	float PG5_Pressure;
	float PG6_Pressure;
	float PG7_Pressure;
	float PG8_Pressure;
	float PG31_Pressure;
	float PG32_Pressure;
	float VG31_Pressure;
	float PG2_Pressure;
	float PS11_Pressure;
	float PG1_Pressure;
	float MS2_Gasboxleft;
	float MS5_Loadingarea;
	float OX_Value;
	float PG21_Pressure;
	float PG22_Pressure;
	float PG23_Pressure;
	float PS33_Pressure;
	float FS105_Flow;
	float FS106_Flow;
	float FS202_Flow;
	float FS104_Flow;
	float FS111_Flow;
	float FS102_Flow;
	float DG1_Pressure;
	float FS116_Flow;
	float PS13_Pressure;
	float MP21_PS_Pressure;
	float PS110_Pressure;
	float PG_PS12_Pressure;
	float VG14_Pressure;
	float VG11_Pressure;
	float VG13_Pressure;
	float PS14_Pressure;
	float Buffer_Foup1_1_N2_Flow;
	float Buffer_Foup1_1_N2_Pressure;
	float Buffer_Foup1_2_N2_Flow;
	float Buffer_Foup1_2_N2_Pressure;
	float Buffer_Foup1_3_N2_Flow;
	float Buffer_Foup1_3_N2_Pressure;
	float Buffer_Foup1_4_N2_Flow;
	float Buffer_Foup1_4_N2_Pressure;
	float Buffer_Foup2_1_N2_Flow;
	float Buffer_Foup2_1_N2_Pressure;
	float Buffer_Foup2_2_N2_Flow;
	float Buffer_Foup2_2_N2_Pressure;
	float Buffer_Foup2_3_N2_Flow;
	float Buffer_Foup2_3_N2_Pressure;
	float Buffer_Foup2_4_N2_Flow;
	float Buffer_Foup2_4_N2_Pressure;
	float Buffer_Foup3_1_N2_Flow;
	float Buffer_Foup3_1_N2_Pressure;
	float Buffer_Foup3_2_N2_Flow;
	float Buffer_Foup3_2_N2_Pressure;
	float Buffer_Foup3_3_N2_Flow;
	float Buffer_Foup3_3_N2_Pressure;
	float Buffer_Foup3_4_N2_Flow;
	float Buffer_Foup3_4_N2_Pressure;
	float Buffer_Foup4_1_N2_Flow;
	float Buffer_Foup4_1_N2_Pressure;
	float Buffer_Foup4_2_N2_Flow;
	float Buffer_Foup4_2_N2_Pressure;
	float Buffer_Foup4_3_N2_Flow;
	float Buffer_Foup4_3_N2_Pressure;
	float Buffer_Foup4_4_N2_Flow;
	float Buffer_Foup4_4_N2_Pressure;
	float MS8_RHC_ExhPress;
	float MS1_Heater;
	float MS3_Scavenger;
	float MS6_Frontbody;
	float MS9_LSC1;
	float MS11_GasBox;
	float MS12_GasBox;
	float MFC1_PV;
	float MFC2_PV;
	float MFC3_PV;
	float MFC4_PV;
	float MFC5_PV;
	float MFC6_PV;
	float MFC7_PV;
	float MFC8_PV;
	float MFC9_PV;
	float MFC10_PV;
	float MFC11_PV;
	float MFC12_PV;
	float MFC13_PV;
	float MFC14_PV;
	float MFC15_PV;
	float MFM16_PV;
	float MFC16_PV;
	float MFC17_PV;
	float MFC51_PV;
	float MFM57_PV;
	float FURNACE_JETCMode;
	float U_Working_output;
	float U_WorkingSP;
	float U_Enable_State;
	float CU_Working_output;
	float CU_WorkingSP;
	float CU_Enable_State;
	float C_Working_output;
	float C_WorkingSP;
	float C_Enable_State;
	float CL_Working_output;
	float CL_WorkingSP;
	float CL_Enable_State;
	float L_Working_output;
	float L_WorkingSP;
	float L_Enable_State;
	float SL_Working_output;
	float SL_WorkingSP;
	float SL_Enable_State;
	float SUB_Working_output;
	float SUB_WorkingSP;
	float SUB_Enable_State;
	float SUB_OT;
	float U_OT;
	float CU_OT;
	float C_OT;
	float CL_OT;
	float L_OT;
	float SL_OT;
	float SUB_HeaterTC;
	float U_HeaterTC;
	float CU_HeaterTC;
	float C_HeaterTC;
	float CL_HeaterTC;
	float L_HeaterTC;
	float SL_HeaterTC;
	float U_CascadeTC;
	float CU_CascadeTC;
	float C_CascadeTC;
	float CL_CascadeTC;
	float L_CascadeTC;
	float SL_CascadeTC;
	float SUB_OT_SBrkOut;
	float U_OT_SBrkOut;
	float CU_OT_SBrkOut;
	float C_OT_SBrkOut;
	float CL_OT_SBrkOut;
	float L_OT_SBrkOut;
	float SL_OT_SBrkOut;
	float SUB_HeaterTC_SBrkOut;
	float U_HeaterTC_SBrkOut;
	float CU_HeaterTC_SBrkOut;
	float C_HeaterTC_SBrkOut;
	float CL_HeaterTC_SBrkOut;
	float L_HeaterTC_SBrkOut;
	float SL_HeaterTC_SBrkOut;
	float U_CascadeTC_SBrkOut;
	float CU_CascadeTC_SBrkOut;
	float C_CascadeTC_SBrkOut;
	float CL_CascadeTC_SBrkOut;
	float L_CascadeTC_SBrkOut;
	float SL_CascadeTC_SBrkOut;
	float U_Open_Offset;
	float CU_Open_Offset;
	float C_Open_Offset;
	float CL_Open_Offset;
	float L_Open_Offset;
	float SL_Open_Offset;
	float SUB_SP;
	float SUB_Up_Rate;
	float SUB_Down_Rate;
	float SUB_PID_P;
	float SUB_PID_I;
	float SUB_PID_D;
	float U_Cascade_Mode_Selection;
	float U_SP;
	float U_Up_Rate;
	float U_Down_Rate;
	float U_Secondary_SP;
	float U_Main_TC_Select;
	float U_Primary_PID_P;
	float U_Primary_PID_I;
	float U_Primary_PID_D;
	float U_PID_P;
	float U_PID_I;
	float U_PID_D;
	float CU_Cascade_Mode_Selection;
	float CU_SP;
	float CU_Up_Rate;
	float CU_Down_Rate;
	float CU_Secondary_SP;
	float CU_Main_TC_Select;
	float CU_Primary_PID_P;
	float CU_Primary_PID_I;
	float CU_Primary_PID_D;
	float CU_PID_P;
	float CU_PID_I;
	float CU_PID_D;
	float C_Cascade_Mode_Selection;
	float C_SP;
	float C_Up_Rate;
	float C_Down_Rate;
	float C_Secondary_SP;
	float C_Main_TC_Select;
	float C_Primary_PID_P;
	float C_Primary_PID_I;
	float C_Primary_PID_D;
	float C_PID_P;
	float C_PID_I;
	float C_PID_D;
	float CL_Cascade_Mode_Selection;
	float CL_SP;
	float CL_Up_Rate;
	float CL_Down_Rate;
	float CL_Secondary_SP;
	float CL_Main_TC_Select;
	float CL_Primary_PID_P;
	float CL_Primary_PID_I;
	float CL_Primary_PID_D;
	float CL_PID_P;
	float CL_PID_I;
	float CL_PID_D;
	float L_Cascade_Mode_Selection;
	float L_SP;
	float L_Up_Rate;
	float L_Down_Rate;
	float L_Secondary_SP;
	float L_Main_TC_Select;
	float L_Primary_PID_P;
	float L_Primary_PID_I;
	float L_Primary_PID_D;
	float L_PID_P;
	float L_PID_I;
	float L_PID_D;
	float SL_Cascade_Mode_Selection;
	float SL_SP;
	float SL_Up_Rate;
	float SL_Down_Rate;
	float SL_Secondary_SP;
	float SL_Main_TC_Select;
	float SL_Primary_PID_P;
	float SL_Primary_PID_I;
	float SL_Primary_PID_D;
	float SL_PID_P;
	float SL_PID_I;
	float SL_PID_D;
	float Instrument_ForceStandby;
	float HEATER1_PV;
	float HEATER1_Temp_Hi_Alarm;
	float HEATER1_Working_Output;
	float HEATER1_Working_SP;
	float HEATER1_Inhibit_state;
	float HEATER1_TC_Error;
	float HEATER1_Auto_Manual;
	float HEATER1_SBrkAlarm_EN;
	float HEATER1_Temp_Hi_Alarm_Inhibit;
	float HEATER1_RateUp;
	float HEATER1_RateDown;
	float HEATER1_PID_P;
	float HEATER1_PID_I;
	float HEATER1_PID_D;
	float HEATER1_AutotuneActivate;
	float HEATER1_Autotune_Status;
	float HEATER1_Autotune_PID_P;
	float HEATER1_Autotune_PID_I;
	float HEATER1_Autotune_PID_D;
	float HEATER2_PV;
	float HEATER2_Temp_Hi_Alarm;
	float HEATER2_Working_Output;
	float HEATER2_Working_SP;
	float HEATER2_Inhibit_state;
	float HEATER2_TC_Error;
	float HEATER2_Auto_Manual;
	float HEATER2_SBrkAlarm_EN;
	float HEATER2_Temp_Hi_Alarm_Inhibit;
	float HEATER2_RateUp;
	float HEATER2_RateDown;
	float HEATER2_PID_P;
	float HEATER2_PID_I;
	float HEATER2_PID_D;
	float HEATER2_AutotuneActivate;
	float HEATER2_Autotune_Status;
	float HEATER2_Autotune_PID_P;
	float HEATER2_Autotune_PID_I;
	float HEATER2_Autotune_PID_D;
	float HEATER3_PV;
	float HEATER3_Temp_Hi_Alarm;
	float HEATER3_Working_Output;
	float HEATER3_Working_SP;
	float HEATER3_Inhibit_state;
	float HEATER3_TC_Error;
	float HEATER3_Auto_Manual;
	float HEATER3_SBrkAlarm_EN;
	float HEATER3_Temp_Hi_Alarm_Inhibit;
	float HEATER3_RateUp;
	float HEATER3_RateDown;
	float HEATER3_PID_P;
	float HEATER3_PID_I;
	float HEATER3_PID_D;
	float HEATER3_AutotuneActivate;
	float HEATER3_Autotune_Status;
	float HEATER3_Autotune_PID_P;
	float HEATER3_Autotune_PID_I;
	float HEATER3_Autotune_PID_D;
	float HEATER4_PV;
	float HEATER4_Temp_Hi_Alarm;
	float HEATER4_Working_Output;
	float HEATER4_Working_SP;
	float HEATER4_Inhibit_state;
	float HEATER4_TC_Error;
	float HEATER4_Auto_Manual;
	float HEATER4_SBrkAlarm_EN;
	float HEATER4_Temp_Hi_Alarm_Inhibit;
	float HEATER4_RateUp;
	float HEATER4_RateDown;
	float HEATER4_PID_P;
	float HEATER4_PID_I;
	float HEATER4_PID_D;
	float HEATER4_AutotuneActivate;
	float HEATER4_Autotune_Status;
	float HEATER4_Autotune_PID_P;
	float HEATER4_Autotune_PID_I;
	float HEATER4_Autotune_PID_D;
	float HEATER5_PV;
	float HEATER5_Temp_Hi_Alarm;
	float HEATER5_Working_Output;
	float HEATER5_Working_SP;
	float HEATER5_Inhibit_state;
	float HEATER5_TC_Error;
	float HEATER5_Auto_Manual;
	float HEATER5_SBrkAlarm_EN;
	float HEATER5_Temp_Hi_Alarm_Inhibit;
	float HEATER5_RateUp;
	float HEATER5_RateDown;
	float HEATER5_PID_P;
	float HEATER5_PID_I;
	float HEATER5_PID_D;
	float HEATER5_AutotuneActivate;
	float HEATER5_Autotune_Status;
	float HEATER5_Autotune_PID_P;
	float HEATER5_Autotune_PID_I;
	float HEATER5_Autotune_PID_D;
	float HEATER6_PV;
	float HEATER6_Temp_Hi_Alarm;
	float HEATER6_Working_Output;
	float HEATER6_Working_SP;
	float HEATER6_Inhibit_state;
	float HEATER6_TC_Error;
	float HEATER6_Auto_Manual;
	float HEATER6_SBrkAlarm_EN;
	float HEATER6_Temp_Hi_Alarm_Inhibit;
	float HEATER6_RateUp;
	float HEATER6_RateDown;
	float HEATER6_PID_P;
	float HEATER6_PID_I;
	float HEATER6_PID_D;
	float HEATER6_AutotuneActivate;
	float HEATER6_Autotune_Status;
	float HEATER6_Autotune_PID_P;
	float HEATER6_Autotune_PID_I;
	float HEATER6_Autotune_PID_D;
	float HEATER7_PV;
	float HEATER7_Temp_Hi_Alarm;
	float HEATER7_Working_Output;
	float HEATER7_Working_SP;
	float HEATER7_Inhibit_state;
	float HEATER7_TC_Error;
	float HEATER7_Auto_Manual;
	float HEATER7_SBrkAlarm_EN;
	float HEATER7_Temp_Hi_Alarm_Inhibit;
	float HEATER7_RateUp;
	float HEATER7_RateDown;
	float HEATER7_PID_P;
	float HEATER7_PID_I;
	float HEATER7_PID_D;
	float HEATER7_AutotuneActivate;
	float HEATER7_Autotune_Status;
	float HEATER7_Autotune_PID_P;
	float HEATER7_Autotune_PID_I;
	float HEATER7_Autotune_PID_D;
	float HEATER8_PV;
	float HEATER8_Temp_Hi_Alarm;
	float HEATER8_Working_Output;
	float HEATER8_Working_SP;
	float HEATER8_Inhibit_state;
	float HEATER8_TC_Error;
	float HEATER8_Auto_Manual;
	float HEATER8_SBrkAlarm_EN;
	float HEATER8_Temp_Hi_Alarm_Inhibit;
	float HEATER8_RateUp;
	float HEATER8_RateDown;
	float HEATER8_PID_P;
	float HEATER8_PID_I;
	float HEATER8_PID_D;
	float HEATER8_AutotuneActivate;
	float HEATER8_Autotune_Status;
	float HEATER8_Autotune_PID_P;
	float HEATER8_Autotune_PID_I;
	float HEATER8_Autotune_PID_D;
	float HEATER9_PV;
	float HEATER9_Temp_Hi_Alarm;
	float HEATER9_Working_Output;
	float HEATER9_Working_SP;
	float HEATER9_Inhibit_state;
	float HEATER9_TC_Error;
	float HEATER9_Auto_Manual;
	float HEATER9_SBrkAlarm_EN;
	float HEATER9_Temp_Hi_Alarm_Inhibit;
	float HEATER9_RateUp;
	float HEATER9_RateDown;
	float HEATER9_PID_P;
	float HEATER9_PID_I;
	float HEATER9_PID_D;
	float HEATER9_AutotuneActivate;
	float HEATER9_Autotune_Status;
	float HEATER9_Autotune_PID_P;
	float HEATER9_Autotune_PID_I;
	float HEATER9_Autotune_PID_D;
	float HEATER10_PV;
	float HEATER10_Temp_Hi_Alarm;
	float HEATER10_Working_Output;
	float HEATER10_Working_SP;
	float HEATER10_Inhibit_state;
	float HEATER10_TC_Error;
	float HEATER10_Auto_Manual;
	float HEATER10_SBrkAlarm_EN;
	float HEATER10_Temp_Hi_Alarm_Inhibit;
	float HEATER10_RateUp;
	float HEATER10_RateDown;
	float HEATER10_PID_P;
	float HEATER10_PID_I;
	float HEATER10_PID_D;
	float HEATER10_AutotuneActivate;
	float HEATER10_Autotune_Status;
	float HEATER10_Autotune_PID_P;
	float HEATER10_Autotune_PID_I;
	float HEATER10_Autotune_PID_D;
	float HEATER11_PV;
	float HEATER11_Temp_Hi_Alarm;
	float HEATER11_Working_Output;
	float HEATER11_Working_SP;
	float HEATER11_Inhibit_state;
	float HEATER11_TC_Error;
	float HEATER11_Auto_Manual;
	float HEATER11_SBrkAlarm_EN;
	float HEATER11_Temp_Hi_Alarm_Inhibit;
	float HEATER11_RateUp;
	float HEATER11_RateDown;
	float HEATER11_PID_P;
	float HEATER11_PID_I;
	float HEATER11_PID_D;
	float HEATER11_AutotuneActivate;
	float HEATER11_Autotune_Status;
	float HEATER11_Autotune_PID_P;
	float HEATER11_Autotune_PID_I;
	float HEATER11_Autotune_PID_D;
	float HEATER12_PV;
	float HEATER12_Temp_Hi_Alarm;
	float HEATER12_Working_Output;
	float HEATER12_Working_SP;
	float HEATER12_Inhibit_state;
	float HEATER12_TC_Error;
	float HEATER12_Auto_Manual;
	float HEATER12_SBrkAlarm_EN;
	float HEATER12_Temp_Hi_Alarm_Inhibit;
	float HEATER12_RateUp;
	float HEATER12_RateDown;
	float HEATER12_PID_P;
	float HEATER12_PID_I;
	float HEATER12_PID_D;
	float HEATER12_AutotuneActivate;
	float HEATER12_Autotune_Status;
	float HEATER12_Autotune_PID_P;
	float HEATER12_Autotune_PID_I;
	float HEATER12_Autotune_PID_D;
	float HEATER13_PV;
	float HEATER13_Temp_Hi_Alarm;
	float HEATER13_Working_Output;
	float HEATER13_Working_SP;
	float HEATER13_Inhibit_state;
	float HEATER13_TC_Error;
	float HEATER13_Auto_Manual;
	float HEATER13_SBrkAlarm_EN;
	float HEATER13_Temp_Hi_Alarm_Inhibit;
	float HEATER13_RateUp;
	float HEATER13_RateDown;
	float HEATER13_PID_P;
	float HEATER13_PID_I;
	float HEATER13_PID_D;
	float HEATER13_AutotuneActivate;
	float HEATER13_Autotune_Status;
	float HEATER13_Autotune_PID_P;
	float HEATER13_Autotune_PID_I;
	float HEATER13_Autotune_PID_D;
	float HEATER14_PV;
	float HEATER14_Temp_Hi_Alarm;
	float HEATER14_Working_Output;
	float HEATER14_Working_SP;
	float HEATER14_Inhibit_state;
	float HEATER14_TC_Error;
	float HEATER14_Auto_Manual;
	float HEATER14_SBrkAlarm_EN;
	float HEATER14_Temp_Hi_Alarm_Inhibit;
	float HEATER14_RateUp;
	float HEATER14_RateDown;
	float HEATER14_PID_P;
	float HEATER14_PID_I;
	float HEATER14_PID_D;
	float HEATER14_AutotuneActivate;
	float HEATER14_Autotune_Status;
	float HEATER14_Autotune_PID_P;
	float HEATER14_Autotune_PID_I;
	float HEATER14_Autotune_PID_D;
	float HEATER15_PV;
	float HEATER15_Temp_Hi_Alarm;
	float HEATER15_Working_Output;
	float HEATER15_Working_SP;
	float HEATER15_Inhibit_state;
	float HEATER15_TC_Error;
	float HEATER15_Auto_Manual;
	float HEATER15_SBrkAlarm_EN;
	float HEATER15_Temp_Hi_Alarm_Inhibit;
	float HEATER15_RateUp;
	float HEATER15_RateDown;
	float HEATER15_PID_P;
	float HEATER15_PID_I;
	float HEATER15_PID_D;
	float HEATER15_AutotuneActivate;
	float HEATER15_Autotune_Status;
	float HEATER15_Autotune_PID_P;
	float HEATER15_Autotune_PID_I;
	float HEATER15_Autotune_PID_D;
	float HEATER16_PV;
	float HEATER16_Temp_Hi_Alarm;
	float HEATER16_Working_Output;
	float HEATER16_Working_SP;
	float HEATER16_Inhibit_state;
	float HEATER16_TC_Error;
	float HEATER16_Auto_Manual;
	float HEATER16_SBrkAlarm_EN;
	float HEATER16_Temp_Hi_Alarm_Inhibit;
	float HEATER16_RateUp;
	float HEATER16_RateDown;
	float HEATER16_PID_P;
	float HEATER16_PID_I;
	float HEATER16_PID_D;
	float HEATER16_AutotuneActivate;
	float HEATER16_Autotune_Status;
	float HEATER16_Autotune_PID_P;
	float HEATER16_Autotune_PID_I;
	float HEATER16_Autotune_PID_D;
	float HEATER17_PV;
	float HEATER17_Temp_Hi_Alarm;
	float HEATER17_Working_Output;
	float HEATER17_Working_SP;
	float HEATER17_Inhibit_state;
	float HEATER17_TC_Error;
	float HEATER17_Auto_Manual;
	float HEATER17_SBrkAlarm_EN;
	float HEATER17_Temp_Hi_Alarm_Inhibit;
	float HEATER17_RateUp;
	float HEATER17_RateDown;
	float HEATER17_PID_P;
	float HEATER17_PID_I;
	float HEATER17_PID_D;
	float HEATER17_AutotuneActivate;
	float HEATER17_Autotune_Status;
	float HEATER17_Autotune_PID_P;
	float HEATER17_Autotune_PID_I;
	float HEATER17_Autotune_PID_D;
	float HEATER18_PV;
	float HEATER18_Temp_Hi_Alarm;
	float HEATER18_Working_Output;
	float HEATER18_Working_SP;
	float HEATER18_Inhibit_state;
	float HEATER18_TC_Error;
	float HEATER18_Auto_Manual;
	float HEATER18_SBrkAlarm_EN;
	float HEATER18_Temp_Hi_Alarm_Inhibit;
	float HEATER18_RateUp;
	float HEATER18_RateDown;
	float HEATER18_PID_P;
	float HEATER18_PID_I;
	float HEATER18_PID_D;
	float HEATER18_AutotuneActivate;
	float HEATER18_Autotune_Status;
	float HEATER18_Autotune_PID_P;
	float HEATER18_Autotune_PID_I;
	float HEATER18_Autotune_PID_D;
	float HEATER19_PV;
	float HEATER19_Temp_Hi_Alarm;
	float HEATER19_Working_Output;
	float HEATER19_Working_SP;
	float HEATER19_Inhibit_state;
	float HEATER19_TC_Error;
	float HEATER19_Auto_Manual;
	float HEATER19_SBrkAlarm_EN;
	float HEATER19_Temp_Hi_Alarm_Inhibit;
	float HEATER19_RateUp;
	float HEATER19_RateDown;
	float HEATER19_PID_P;
	float HEATER19_PID_I;
	float HEATER19_PID_D;
	float HEATER19_AutotuneActivate;
	float HEATER19_Autotune_Status;
	float HEATER19_Autotune_PID_P;
	float HEATER19_Autotune_PID_I;
	float HEATER19_Autotune_PID_D;
	float HEATER20_PV;
	float HEATER20_Temp_Hi_Alarm;
	float HEATER20_Working_Output;
	float HEATER20_Working_SP;
	float HEATER20_Inhibit_state;
	float HEATER20_TC_Error;
	float HEATER20_Auto_Manual;
	float HEATER20_SBrkAlarm_EN;
	float HEATER20_Temp_Hi_Alarm_Inhibit;
	float HEATER20_RateUp;
	float HEATER20_RateDown;
	float HEATER20_PID_P;
	float HEATER20_PID_I;
	float HEATER20_PID_D;
	float HEATER20_AutotuneActivate;
	float HEATER20_Autotune_Status;
	float HEATER20_Autotune_PID_P;
	float HEATER20_Autotune_PID_I;
	float HEATER20_Autotune_PID_D;
	float HEATER21_PV;
	float HEATER21_Temp_Hi_Alarm;
	float HEATER21_Working_Output;
	float HEATER21_Working_SP;
	float HEATER21_Inhibit_state;
	float HEATER21_TC_Error;
	float HEATER21_Auto_Manual;
	float HEATER21_SBrkAlarm_EN;
	float HEATER21_Temp_Hi_Alarm_Inhibit;
	float HEATER21_RateUp;
	float HEATER21_RateDown;
	float HEATER21_PID_P;
	float HEATER21_PID_I;
	float HEATER21_PID_D;
	float HEATER21_AutotuneActivate;
	float HEATER21_Autotune_Status;
	float HEATER21_Autotune_PID_P;
	float HEATER21_Autotune_PID_I;
	float HEATER21_Autotune_PID_D;
	float HEATER22_PV;
	float HEATER22_Temp_Hi_Alarm;
	float HEATER22_Working_Output;
	float HEATER22_Working_SP;
	float HEATER22_Inhibit_state;
	float HEATER22_TC_Error;
	float HEATER22_Auto_Manual;
	float HEATER22_SBrkAlarm_EN;
	float HEATER22_Temp_Hi_Alarm_Inhibit;
	float HEATER22_RateUp;
	float HEATER22_RateDown;
	float HEATER22_PID_P;
	float HEATER22_PID_I;
	float HEATER22_PID_D;
	float HEATER22_AutotuneActivate;
	float HEATER22_Autotune_Status;
	float HEATER22_Autotune_PID_P;
	float HEATER22_Autotune_PID_I;
	float HEATER22_Autotune_PID_D;
	float HEATER23_PV;
	float HEATER23_Temp_Hi_Alarm;
	float HEATER23_Working_Output;
	float HEATER23_Working_SP;
	float HEATER23_Inhibit_state;
	float HEATER23_TC_Error;
	float HEATER23_Auto_Manual;
	float HEATER23_SBrkAlarm_EN;
	float HEATER23_Temp_Hi_Alarm_Inhibit;
	float HEATER23_RateUp;
	float HEATER23_RateDown;
	float HEATER23_PID_P;
	float HEATER23_PID_I;
	float HEATER23_PID_D;
	float HEATER23_AutotuneActivate;
	float HEATER23_Autotune_Status;
	float HEATER23_Autotune_PID_P;
	float HEATER23_Autotune_PID_I;
	float HEATER23_Autotune_PID_D;
	float HEATER24_PV;
	float HEATER24_Temp_Hi_Alarm;
	float HEATER24_Working_Output;
	float HEATER24_Working_SP;
	float HEATER24_Inhibit_state;
	float HEATER24_TC_Error;
	float HEATER24_Auto_Manual;
	float HEATER24_SBrkAlarm_EN;
	float HEATER24_Temp_Hi_Alarm_Inhibit;
	float HEATER24_RateUp;
	float HEATER24_RateDown;
	float HEATER24_PID_P;
	float HEATER24_PID_I;
	float HEATER24_PID_D;
	float HEATER24_AutotuneActivate;
	float HEATER24_Autotune_Status;
	float HEATER24_Autotune_PID_P;
	float HEATER24_Autotune_PID_I;
	float HEATER24_Autotune_PID_D;
	float HEATER25_PV;
	float HEATER25_Temp_Hi_Alarm;
	float HEATER25_Working_Output;
	float HEATER25_Working_SP;
	float HEATER25_Inhibit_state;
	float HEATER25_TC_Error;
	float HEATER25_Auto_Manual;
	float HEATER25_SBrkAlarm_EN;
	float HEATER25_Temp_Hi_Alarm_Inhibit;
	float HEATER25_RateUp;
	float HEATER25_RateDown;
	float HEATER25_PID_P;
	float HEATER25_PID_I;
	float HEATER25_PID_D;
	float HEATER25_AutotuneActivate;
	float HEATER25_Autotune_Status;
	float HEATER25_Autotune_PID_P;
	float HEATER25_Autotune_PID_I;
	float HEATER25_Autotune_PID_D;
	float HEATER26_PV;
	float HEATER26_Temp_Hi_Alarm;
	float HEATER26_Working_Output;
	float HEATER26_Working_SP;
	float HEATER26_Inhibit_state;
	float HEATER26_TC_Error;
	float HEATER26_Auto_Manual;
	float HEATER26_SBrkAlarm_EN;
	float HEATER26_Temp_Hi_Alarm_Inhibit;
	float HEATER26_RateUp;
	float HEATER26_RateDown;
	float HEATER26_PID_P;
	float HEATER26_PID_I;
	float HEATER26_PID_D;
	float HEATER26_AutotuneActivate;
	float HEATER26_Autotune_Status;
	float HEATER26_Autotune_PID_P;
	float HEATER26_Autotune_PID_I;
	float HEATER26_Autotune_PID_D;
	float HEATER27_PV;
	float HEATER27_Temp_Hi_Alarm;
	float HEATER27_Working_Output;
	float HEATER27_Working_SP;
	float HEATER27_Inhibit_state;
	float HEATER27_TC_Error;
	float HEATER27_Auto_Manual;
	float HEATER27_SBrkAlarm_EN;
	float HEATER27_Temp_Hi_Alarm_Inhibit;
	float HEATER27_RateUp;
	float HEATER27_RateDown;
	float HEATER27_PID_P;
	float HEATER27_PID_I;
	float HEATER27_PID_D;
	float HEATER27_AutotuneActivate;
	float HEATER27_Autotune_Status;
	float HEATER27_Autotune_PID_P;
	float HEATER27_Autotune_PID_I;
	float HEATER27_Autotune_PID_D;
	float HEATER28_PV;
	float HEATER28_Temp_Hi_Alarm;
	float HEATER28_Working_Output;
	float HEATER28_Working_SP;
	float HEATER28_Inhibit_state;
	float HEATER28_TC_Error;
	float HEATER28_Auto_Manual;
	float HEATER28_SBrkAlarm_EN;
	float HEATER28_Temp_Hi_Alarm_Inhibit;
	float HEATER28_RateUp;
	float HEATER28_RateDown;
	float HEATER28_PID_P;
	float HEATER28_PID_I;
	float HEATER28_PID_D;
	float HEATER28_AutotuneActivate;
	float HEATER28_Autotune_Status;
	float HEATER28_Autotune_PID_P;
	float HEATER28_Autotune_PID_I;
	float HEATER28_Autotune_PID_D;
	float HEATER29_PV;
	float HEATER29_Temp_Hi_Alarm;
	float HEATER29_Working_Output;
	float HEATER29_Working_SP;
	float HEATER29_Inhibit_state;
	float HEATER29_TC_Error;
	float HEATER29_Auto_Manual;
	float HEATER29_SBrkAlarm_EN;
	float HEATER29_Temp_Hi_Alarm_Inhibit;
	float HEATER29_RateUp;
	float HEATER29_RateDown;
	float HEATER29_PID_P;
	float HEATER29_PID_I;
	float HEATER29_PID_D;
	float HEATER29_AutotuneActivate;
	float HEATER29_Autotune_Status;
	float HEATER29_Autotune_PID_P;
	float HEATER29_Autotune_PID_I;
	float HEATER29_Autotune_PID_D;
	float HEATER30_PV;
	float HEATER30_Temp_Hi_Alarm;
	float HEATER30_Working_Output;
	float HEATER30_Working_SP;
	float HEATER30_Inhibit_state;
	float HEATER30_TC_Error;
	float HEATER30_Auto_Manual;
	float HEATER30_SBrkAlarm_EN;
	float HEATER30_Temp_Hi_Alarm_Inhibit;
	float HEATER30_RateUp;
	float HEATER30_RateDown;
	float HEATER30_PID_P;
	float HEATER30_PID_I;
	float HEATER30_PID_D;
	float HEATER30_AutotuneActivate;
	float HEATER30_Autotune_Status;
	float HEATER30_Autotune_PID_P;
	float HEATER30_Autotune_PID_I;
	float HEATER30_Autotune_PID_D;
	float HEATER31_PV;
	float HEATER31_Temp_Hi_Alarm;
	float HEATER31_Working_Output;
	float HEATER31_Working_SP;
	float HEATER31_Inhibit_state;
	float HEATER31_TC_Error;
	float HEATER31_Auto_Manual;
	float HEATER31_SBrkAlarm_EN;
	float HEATER31_Temp_Hi_Alarm_Inhibit;
	float HEATER31_RateUp;
	float HEATER31_RateDown;
	float HEATER31_PID_P;
	float HEATER31_PID_I;
	float HEATER31_PID_D;
	float HEATER31_AutotuneActivate;
	float HEATER31_Autotune_Status;
	float HEATER31_Autotune_PID_P;
	float HEATER31_Autotune_PID_I;
	float HEATER31_Autotune_PID_D;
	float HEATER32_PV;
	float HEATER32_Temp_Hi_Alarm;
	float HEATER32_Working_Output;
	float HEATER32_Working_SP;
	float HEATER32_Inhibit_state;
	float HEATER32_TC_Error;
	float HEATER32_Auto_Manual;
	float HEATER32_SBrkAlarm_EN;
	float HEATER32_Temp_Hi_Alarm_Inhibit;
	float HEATER32_RateUp;
	float HEATER32_RateDown;
	float HEATER32_PID_P;
	float HEATER32_PID_I;
	float HEATER32_PID_D;
	float HEATER32_AutotuneActivate;
	float HEATER32_Autotune_Status;
	float HEATER32_Autotune_PID_P;
	float HEATER32_Autotune_PID_I;
	float HEATER32_Autotune_PID_D;
	float HEATER33_PV;
	float HEATER33_Temp_Hi_Alarm;
	float HEATER33_Working_Output;
	float HEATER33_Working_SP;
	float HEATER33_Inhibit_state;
	float HEATER33_TC_Error;
	float HEATER33_Auto_Manual;
	float HEATER33_SBrkAlarm_EN;
	float HEATER33_Temp_Hi_Alarm_Inhibit;
	float HEATER33_RateUp;
	float HEATER33_RateDown;
	float HEATER33_PID_P;
	float HEATER33_PID_I;
	float HEATER33_PID_D;
	float HEATER33_AutotuneActivate;
	float HEATER33_Autotune_Status;
	float HEATER33_Autotune_PID_P;
	float HEATER33_Autotune_PID_I;
	float HEATER33_Autotune_PID_D;
	float HEATER34_PV;
	float HEATER34_Temp_Hi_Alarm;
	float HEATER34_Working_Output;
	float HEATER34_Working_SP;
	float HEATER34_Inhibit_state;
	float HEATER34_TC_Error;
	float HEATER34_Auto_Manual;
	float HEATER34_SBrkAlarm_EN;
	float HEATER34_Temp_Hi_Alarm_Inhibit;
	float HEATER34_RateUp;
	float HEATER34_RateDown;
	float HEATER34_PID_P;
	float HEATER34_PID_I;
	float HEATER34_PID_D;
	float HEATER34_AutotuneActivate;
	float HEATER34_Autotune_Status;
	float HEATER34_Autotune_PID_P;
	float HEATER34_Autotune_PID_I;
	float HEATER34_Autotune_PID_D;
	float HEATER35_PV;
	float HEATER35_Temp_Hi_Alarm;
	float HEATER35_Working_Output;
	float HEATER35_Working_SP;
	float HEATER35_Inhibit_state;
	float HEATER35_TC_Error;
	float HEATER35_Auto_Manual;
	float HEATER35_SBrkAlarm_EN;
	float HEATER35_Temp_Hi_Alarm_Inhibit;
	float HEATER35_RateUp;
	float HEATER35_RateDown;
	float HEATER35_PID_P;
	float HEATER35_PID_I;
	float HEATER35_PID_D;
	float HEATER35_AutotuneActivate;
	float HEATER35_Autotune_Status;
	float HEATER35_Autotune_PID_P;
	float HEATER35_Autotune_PID_I;
	float HEATER35_Autotune_PID_D;
	float HEATER36_PV;
	float HEATER36_Temp_Hi_Alarm;
	float HEATER36_Working_Output;
	float HEATER36_Working_SP;
	float HEATER36_Inhibit_state;
	float HEATER36_TC_Error;
	float HEATER36_Auto_Manual;
	float HEATER36_SBrkAlarm_EN;
	float HEATER36_Temp_Hi_Alarm_Inhibit;
	float HEATER36_RateUp;
	float HEATER36_RateDown;
	float HEATER36_PID_P;
	float HEATER36_PID_I;
	float HEATER36_PID_D;
	float HEATER36_AutotuneActivate;
	float HEATER36_Autotune_Status;
	float HEATER36_Autotune_PID_P;
	float HEATER36_Autotune_PID_I;
	float HEATER36_Autotune_PID_D;
	float HEATER37_PV;
	float HEATER37_Temp_Hi_Alarm;
	float HEATER37_Working_Output;
	float HEATER37_Working_SP;
	float HEATER37_Inhibit_state;
	float HEATER37_TC_Error;
	float HEATER37_Auto_Manual;
	float HEATER37_SBrkAlarm_EN;
	float HEATER37_Temp_Hi_Alarm_Inhibit;
	float HEATER37_RateUp;
	float HEATER37_RateDown;
	float HEATER37_PID_P;
	float HEATER37_PID_I;
	float HEATER37_PID_D;
	float HEATER37_AutotuneActivate;
	float HEATER37_Autotune_Status;
	float HEATER37_Autotune_PID_P;
	float HEATER37_Autotune_PID_I;
	float HEATER37_Autotune_PID_D;
	float HEATER38_PV;
	float HEATER38_Temp_Hi_Alarm;
	float HEATER38_Working_Output;
	float HEATER38_Working_SP;
	float HEATER38_Inhibit_state;
	float HEATER38_TC_Error;
	float HEATER38_Auto_Manual;
	float HEATER38_SBrkAlarm_EN;
	float HEATER38_Temp_Hi_Alarm_Inhibit;
	float HEATER38_RateUp;
	float HEATER38_RateDown;
	float HEATER38_PID_P;
	float HEATER38_PID_I;
	float HEATER38_PID_D;
	float HEATER38_AutotuneActivate;
	float HEATER38_Autotune_Status;
	float HEATER38_Autotune_PID_P;
	float HEATER38_Autotune_PID_I;
	float HEATER38_Autotune_PID_D;
	float HEATER39_PV;
	float HEATER39_Temp_Hi_Alarm;
	float HEATER39_Working_Output;
	float HEATER39_Working_SP;
	float HEATER39_Inhibit_state;
	float HEATER39_TC_Error;
	float HEATER39_Auto_Manual;
	float HEATER39_SBrkAlarm_EN;
	float HEATER39_Temp_Hi_Alarm_Inhibit;
	float HEATER39_RateUp;
	float HEATER39_RateDown;
	float HEATER39_PID_P;
	float HEATER39_PID_I;
	float HEATER39_PID_D;
	float HEATER39_AutotuneActivate;
	float HEATER39_Autotune_Status;
	float HEATER39_Autotune_PID_P;
	float HEATER39_Autotune_PID_I;
	float HEATER39_Autotune_PID_D;
	float HEATER40_PV;
	float HEATER40_Temp_Hi_Alarm;
	float HEATER40_Working_Output;
	float HEATER40_Working_SP;
	float HEATER40_Inhibit_state;
	float HEATER40_TC_Error;
	float HEATER40_Auto_Manual;
	float HEATER40_SBrkAlarm_EN;
	float HEATER40_Temp_Hi_Alarm_Inhibit;
	float HEATER40_RateUp;
	float HEATER40_RateDown;
	float HEATER40_PID_P;
	float HEATER40_PID_I;
	float HEATER40_PID_D;
	float HEATER40_AutotuneActivate;
	float HEATER40_Autotune_Status;
	float HEATER40_Autotune_PID_P;
	float HEATER40_Autotune_PID_I;
	float HEATER40_Autotune_PID_D;
	float HEATER41_PV;
	float HEATER41_Temp_Hi_Alarm;
	float HEATER41_Working_Output;
	float HEATER41_Working_SP;
	float HEATER41_Inhibit_state;
	float HEATER41_TC_Error;
	float HEATER41_Auto_Manual;
	float HEATER41_SBrkAlarm_EN;
	float HEATER41_Temp_Hi_Alarm_Inhibit;
	float HEATER41_RateUp;
	float HEATER41_RateDown;
	float HEATER41_PID_P;
	float HEATER41_PID_I;
	float HEATER41_PID_D;
	float HEATER41_AutotuneActivate;
	float HEATER41_Autotune_Status;
	float HEATER41_Autotune_PID_P;
	float HEATER41_Autotune_PID_I;
	float HEATER41_Autotune_PID_D;
	float HEATER42_PV;
	float HEATER42_Temp_Hi_Alarm;
	float HEATER42_Working_Output;
	float HEATER42_Working_SP;
	float HEATER42_Inhibit_state;
	float HEATER42_TC_Error;
	float HEATER42_Auto_Manual;
	float HEATER42_SBrkAlarm_EN;
	float HEATER42_Temp_Hi_Alarm_Inhibit;
	float HEATER42_RateUp;
	float HEATER42_RateDown;
	float HEATER42_PID_P;
	float HEATER42_PID_I;
	float HEATER42_PID_D;
	float HEATER42_AutotuneActivate;
	float HEATER42_Autotune_Status;
	float HEATER42_Autotune_PID_P;
	float HEATER42_Autotune_PID_I;
	float HEATER42_Autotune_PID_D;
	float HEATER43_PV;
	float HEATER43_Temp_Hi_Alarm;
	float HEATER43_Working_Output;
	float HEATER43_Working_SP;
	float HEATER43_Inhibit_state;
	float HEATER43_TC_Error;
	float HEATER43_Auto_Manual;
	float HEATER43_SBrkAlarm_EN;
	float HEATER43_Temp_Hi_Alarm_Inhibit;
	float HEATER43_RateUp;
	float HEATER43_RateDown;
	float HEATER43_PID_P;
	float HEATER43_PID_I;
	float HEATER43_PID_D;
	float HEATER43_AutotuneActivate;
	float HEATER43_Autotune_Status;
	float HEATER43_Autotune_PID_P;
	float HEATER43_Autotune_PID_I;
	float HEATER43_Autotune_PID_D;
	float HEATER44_PV;
	float HEATER44_Temp_Hi_Alarm;
	float HEATER44_Working_Output;
	float HEATER44_Working_SP;
	float HEATER44_Inhibit_state;
	float HEATER44_TC_Error;
	float HEATER44_Auto_Manual;
	float HEATER44_SBrkAlarm_EN;
	float HEATER44_Temp_Hi_Alarm_Inhibit;
	float HEATER44_RateUp;
	float HEATER44_RateDown;
	float HEATER44_PID_P;
	float HEATER44_PID_I;
	float HEATER44_PID_D;
	float HEATER44_AutotuneActivate;
	float HEATER44_Autotune_Status;
	float HEATER44_Autotune_PID_P;
	float HEATER44_Autotune_PID_I;
	float HEATER44_Autotune_PID_D;
	float HEATER45_PV;
	float HEATER45_Temp_Hi_Alarm;
	float HEATER45_Working_Output;
	float HEATER45_Working_SP;
	float HEATER45_Inhibit_state;
	float HEATER45_TC_Error;
	float HEATER45_Auto_Manual;
	float HEATER45_SBrkAlarm_EN;
	float HEATER45_Temp_Hi_Alarm_Inhibit;
	float HEATER45_RateUp;
	float HEATER45_RateDown;
	float HEATER45_PID_P;
	float HEATER45_PID_I;
	float HEATER45_PID_D;
	float HEATER45_AutotuneActivate;
	float HEATER45_Autotune_Status;
	float HEATER45_Autotune_PID_P;
	float HEATER45_Autotune_PID_I;
	float HEATER45_Autotune_PID_D;
	float HEATER46_PV;
	float HEATER46_Temp_Hi_Alarm;
	float HEATER46_Working_Output;
	float HEATER46_Working_SP;
	float HEATER46_Inhibit_state;
	float HEATER46_TC_Error;
	float HEATER46_Auto_Manual;
	float HEATER46_SBrkAlarm_EN;
	float HEATER46_Temp_Hi_Alarm_Inhibit;
	float HEATER46_RateUp;
	float HEATER46_RateDown;
	float HEATER46_PID_P;
	float HEATER46_PID_I;
	float HEATER46_PID_D;
	float HEATER46_AutotuneActivate;
	float HEATER46_Autotune_Status;
	float HEATER46_Autotune_PID_P;
	float HEATER46_Autotune_PID_I;
	float HEATER46_Autotune_PID_D;
	float HEATER47_PV;
	float HEATER47_Temp_Hi_Alarm;
	float HEATER47_Working_Output;
	float HEATER47_Working_SP;
	float HEATER47_Inhibit_state;
	float HEATER47_TC_Error;
	float HEATER47_Auto_Manual;
	float HEATER47_SBrkAlarm_EN;
	float HEATER47_Temp_Hi_Alarm_Inhibit;
	float HEATER47_RateUp;
	float HEATER47_RateDown;
	float HEATER47_PID_P;
	float HEATER47_PID_I;
	float HEATER47_PID_D;
	float HEATER47_AutotuneActivate;
	float HEATER47_Autotune_Status;
	float HEATER47_Autotune_PID_P;
	float HEATER47_Autotune_PID_I;
	float HEATER47_Autotune_PID_D;
	float HEATER48_PV;
	float HEATER48_Temp_Hi_Alarm;
	float HEATER48_Working_Output;
	float HEATER48_Working_SP;
	float HEATER48_Inhibit_state;
	float HEATER48_TC_Error;
	float HEATER48_Auto_Manual;
	float HEATER48_SBrkAlarm_EN;
	float HEATER48_Temp_Hi_Alarm_Inhibit;
	float HEATER48_RateUp;
	float HEATER48_RateDown;
	float HEATER48_PID_P;
	float HEATER48_PID_I;
	float HEATER48_PID_D;
	float HEATER48_AutotuneActivate;
	float HEATER48_Autotune_Status;
	float HEATER48_Autotune_PID_P;
	float HEATER48_Autotune_PID_I;
	float HEATER48_Autotune_PID_D;
	float HEATER49_PV;
	float HEATER49_Temp_Hi_Alarm;
	float HEATER49_Working_Output;
	float HEATER49_Working_SP;
	float HEATER49_Inhibit_state;
	float HEATER49_TC_Error;
	float HEATER49_Auto_Manual;
	float HEATER49_SBrkAlarm_EN;
	float HEATER49_Temp_Hi_Alarm_Inhibit;
	float HEATER49_RateUp;
	float HEATER49_RateDown;
	float HEATER49_PID_P;
	float HEATER49_PID_I;
	float HEATER49_PID_D;
	float HEATER49_AutotuneActivate;
	float HEATER49_Autotune_Status;
	float HEATER49_Autotune_PID_P;
	float HEATER49_Autotune_PID_I;
	float HEATER49_Autotune_PID_D;
	float HEATER50_PV;
	float HEATER50_Temp_Hi_Alarm;
	float HEATER50_Working_Output;
	float HEATER50_Working_SP;
	float HEATER50_Inhibit_state;
	float HEATER50_TC_Error;
	float HEATER50_Auto_Manual;
	float HEATER50_SBrkAlarm_EN;
	float HEATER50_Temp_Hi_Alarm_Inhibit;
	float HEATER50_RateUp;
	float HEATER50_RateDown;
	float HEATER50_PID_P;
	float HEATER50_PID_I;
	float HEATER50_PID_D;
	float HEATER50_AutotuneActivate;
	float HEATER50_Autotune_Status;
	float HEATER50_Autotune_PID_P;
	float HEATER50_Autotune_PID_I;
	float HEATER50_Autotune_PID_D;
	float HEATER51_PV;
	float HEATER51_Temp_Hi_Alarm;
	float HEATER51_Working_Output;
	float HEATER51_Working_SP;
	float HEATER51_Inhibit_state;
	float HEATER51_TC_Error;
	float HEATER51_Auto_Manual;
	float HEATER51_SBrkAlarm_EN;
	float HEATER51_Temp_Hi_Alarm_Inhibit;
	float HEATER51_RateUp;
	float HEATER51_RateDown;
	float HEATER51_PID_P;
	float HEATER51_PID_I;
	float HEATER51_PID_D;
	float HEATER51_AutotuneActivate;
	float HEATER51_Autotune_Status;
	float HEATER51_Autotune_PID_P;
	float HEATER51_Autotune_PID_I;
	float HEATER51_Autotune_PID_D;
	float HEATER52_PV;
	float HEATER52_Temp_Hi_Alarm;
	float HEATER52_Working_Output;
	float HEATER52_Working_SP;
	float HEATER52_Inhibit_state;
	float HEATER52_TC_Error;
	float HEATER52_Auto_Manual;
	float HEATER52_SBrkAlarm_EN;
	float HEATER52_Temp_Hi_Alarm_Inhibit;
	float HEATER52_RateUp;
	float HEATER52_RateDown;
	float HEATER52_PID_P;
	float HEATER52_PID_I;
	float HEATER52_PID_D;
	float HEATER52_AutotuneActivate;
	float HEATER52_Autotune_Status;
	float HEATER52_Autotune_PID_P;
	float HEATER52_Autotune_PID_I;
	float HEATER52_Autotune_PID_D;
	float HEATER53_PV;
	float HEATER53_Temp_Hi_Alarm;
	float HEATER53_Working_Output;
	float HEATER53_Working_SP;
	float HEATER53_Inhibit_state;
	float HEATER53_TC_Error;
	float HEATER53_Auto_Manual;
	float HEATER53_SBrkAlarm_EN;
	float HEATER53_Temp_Hi_Alarm_Inhibit;
	float HEATER53_RateUp;
	float HEATER53_RateDown;
	float HEATER53_PID_P;
	float HEATER53_PID_I;
	float HEATER53_PID_D;
	float HEATER53_AutotuneActivate;
	float HEATER53_Autotune_Status;
	float HEATER53_Autotune_PID_P;
	float HEATER53_Autotune_PID_I;
	float HEATER53_Autotune_PID_D;
	float HEATER54_PV;
	float HEATER54_Temp_Hi_Alarm;
	float HEATER54_Working_Output;
	float HEATER54_Working_SP;
	float HEATER54_Inhibit_state;
	float HEATER54_TC_Error;
	float HEATER54_Auto_Manual;
	float HEATER54_SBrkAlarm_EN;
	float HEATER54_Temp_Hi_Alarm_Inhibit;
	float HEATER54_RateUp;
	float HEATER54_RateDown;
	float HEATER54_PID_P;
	float HEATER54_PID_I;
	float HEATER54_PID_D;
	float HEATER54_AutotuneActivate;
	float HEATER54_Autotune_Status;
	float HEATER54_Autotune_PID_P;
	float HEATER54_Autotune_PID_I;
	float HEATER54_Autotune_PID_D;
	float HEATER55_PV;
	float HEATER55_Temp_Hi_Alarm;
	float HEATER55_Working_Output;
	float HEATER55_Working_SP;
	float HEATER55_Inhibit_state;
	float HEATER55_TC_Error;
	float HEATER55_Auto_Manual;
	float HEATER55_SBrkAlarm_EN;
	float HEATER55_Temp_Hi_Alarm_Inhibit;
	float HEATER55_RateUp;
	float HEATER55_RateDown;
	float HEATER55_PID_P;
	float HEATER55_PID_I;
	float HEATER55_PID_D;
	float HEATER55_AutotuneActivate;
	float HEATER55_Autotune_Status;
	float HEATER55_Autotune_PID_P;
	float HEATER55_Autotune_PID_I;
	float HEATER55_Autotune_PID_D;
	float HEATER56_PV;
	float HEATER56_Temp_Hi_Alarm;
	float HEATER56_Working_Output;
	float HEATER56_Working_SP;
	float HEATER56_Inhibit_state;
	float HEATER56_TC_Error;
	float HEATER56_Auto_Manual;
	float HEATER56_SBrkAlarm_EN;
	float HEATER56_Temp_Hi_Alarm_Inhibit;
	float HEATER56_RateUp;
	float HEATER56_RateDown;
	float HEATER56_PID_P;
	float HEATER56_PID_I;
	float HEATER56_PID_D;
	float HEATER56_AutotuneActivate;
	float HEATER56_Autotune_Status;
	float HEATER56_Autotune_PID_P;
	float HEATER56_Autotune_PID_I;
	float HEATER56_Autotune_PID_D;
	float HEATER57_PV;
	float HEATER57_Temp_Hi_Alarm;
	float HEATER57_Working_Output;
	float HEATER57_Working_SP;
	float HEATER57_Inhibit_state;
	float HEATER57_TC_Error;
	float HEATER57_Auto_Manual;
	float HEATER57_SBrkAlarm_EN;
	float HEATER57_Temp_Hi_Alarm_Inhibit;
	float HEATER57_RateUp;
	float HEATER57_RateDown;
	float HEATER57_PID_P;
	float HEATER57_PID_I;
	float HEATER57_PID_D;
	float HEATER57_AutotuneActivate;
	float HEATER57_Autotune_Status;
	float HEATER57_Autotune_PID_P;
	float HEATER57_Autotune_PID_I;
	float HEATER57_Autotune_PID_D;
	float HEATER58_PV;
	float HEATER58_Temp_Hi_Alarm;
	float HEATER58_Working_Output;
	float HEATER58_Working_SP;
	float HEATER58_Inhibit_state;
	float HEATER58_TC_Error;
	float HEATER58_Auto_Manual;
	float HEATER58_SBrkAlarm_EN;
	float HEATER58_Temp_Hi_Alarm_Inhibit;
	float HEATER58_RateUp;
	float HEATER58_RateDown;
	float HEATER58_PID_P;
	float HEATER58_PID_I;
	float HEATER58_PID_D;
	float HEATER58_AutotuneActivate;
	float HEATER58_Autotune_Status;
	float HEATER58_Autotune_PID_P;
	float HEATER58_Autotune_PID_I;
	float HEATER58_Autotune_PID_D;
	float HEATER59_PV;
	float HEATER59_Temp_Hi_Alarm;
	float HEATER59_Working_Output;
	float HEATER59_Working_SP;
	float HEATER59_Inhibit_state;
	float HEATER59_TC_Error;
	float HEATER59_Auto_Manual;
	float HEATER59_SBrkAlarm_EN;
	float HEATER59_Temp_Hi_Alarm_Inhibit;
	float HEATER59_RateUp;
	float HEATER59_RateDown;
	float HEATER59_PID_P;
	float HEATER59_PID_I;
	float HEATER59_PID_D;
	float HEATER59_AutotuneActivate;
	float HEATER59_Autotune_Status;
	float HEATER59_Autotune_PID_P;
	float HEATER59_Autotune_PID_I;
	float HEATER59_Autotune_PID_D;
	float HEATER60_PV;
	float HEATER60_Temp_Hi_Alarm;
	float HEATER60_Working_Output;
	float HEATER60_Working_SP;
	float HEATER60_Inhibit_state;
	float HEATER60_TC_Error;
	float HEATER60_Auto_Manual;
	float HEATER60_SBrkAlarm_EN;
	float HEATER60_Temp_Hi_Alarm_Inhibit;
	float HEATER60_RateUp;
	float HEATER60_RateDown;
	float HEATER60_PID_P;
	float HEATER60_PID_I;
	float HEATER60_PID_D;
	float HEATER60_AutotuneActivate;
	float HEATER60_Autotune_Status;
	float HEATER60_Autotune_PID_P;
	float HEATER60_Autotune_PID_I;
	float HEATER60_Autotune_PID_D;
	float HEATER61_PV;
	float HEATER61_Temp_Hi_Alarm;
	float HEATER61_Working_Output;
	float HEATER61_Working_SP;
	float HEATER61_Inhibit_state;
	float HEATER61_TC_Error;
	float HEATER61_Auto_Manual;
	float HEATER61_SBrkAlarm_EN;
	float HEATER61_Temp_Hi_Alarm_Inhibit;
	float HEATER61_RateUp;
	float HEATER61_RateDown;
	float HEATER61_PID_P;
	float HEATER61_PID_I;
	float HEATER61_PID_D;
	float HEATER61_AutotuneActivate;
	float HEATER61_Autotune_Status;
	float HEATER61_Autotune_PID_P;
	float HEATER61_Autotune_PID_I;
	float HEATER61_Autotune_PID_D;
	float HEATER62_PV;
	float HEATER62_Temp_Hi_Alarm;
	float HEATER62_Working_Output;
	float HEATER62_Working_SP;
	float HEATER62_Inhibit_state;
	float HEATER62_TC_Error;
	float HEATER62_Auto_Manual;
	float HEATER62_SBrkAlarm_EN;
	float HEATER62_Temp_Hi_Alarm_Inhibit;
	float HEATER62_RateUp;
	float HEATER62_RateDown;
	float HEATER62_PID_P;
	float HEATER62_PID_I;
	float HEATER62_PID_D;
	float HEATER62_AutotuneActivate;
	float HEATER62_Autotune_Status;
	float HEATER62_Autotune_PID_P;
	float HEATER62_Autotune_PID_I;
	float HEATER62_Autotune_PID_D;
	float HEATER63_PV;
	float HEATER63_Temp_Hi_Alarm;
	float HEATER63_Working_Output;
	float HEATER63_Working_SP;
	float HEATER63_Inhibit_state;
	float HEATER63_TC_Error;
	float HEATER63_Auto_Manual;
	float HEATER63_SBrkAlarm_EN;
	float HEATER63_Temp_Hi_Alarm_Inhibit;
	float HEATER63_RateUp;
	float HEATER63_RateDown;
	float HEATER63_PID_P;
	float HEATER63_PID_I;
	float HEATER63_PID_D;
	float HEATER63_AutotuneActivate;
	float HEATER63_Autotune_Status;
	float HEATER63_Autotune_PID_P;
	float HEATER63_Autotune_PID_I;
	float HEATER63_Autotune_PID_D;
	float HEATER64_PV;
	float HEATER64_Temp_Hi_Alarm;
	float HEATER64_Working_Output;
	float HEATER64_Working_SP;
	float HEATER64_Inhibit_state;
	float HEATER64_TC_Error;
	float HEATER64_Auto_Manual;
	float HEATER64_SBrkAlarm_EN;
	float HEATER64_Temp_Hi_Alarm_Inhibit;
	float HEATER64_RateUp;
	float HEATER64_RateDown;
	float HEATER64_PID_P;
	float HEATER64_PID_I;
	float HEATER64_PID_D;
	float HEATER64_AutotuneActivate;
	float HEATER64_Autotune_Status;
	float HEATER64_Autotune_PID_P;
	float HEATER64_Autotune_PID_I;
	float HEATER64_Autotune_PID_D;
	float HEATER65_PV;
	float HEATER65_Temp_Hi_Alarm;
	float HEATER65_Working_Output;
	float HEATER65_Working_SP;
	float HEATER65_Inhibit_state;
	float HEATER65_TC_Error;
	float HEATER65_Auto_Manual;
	float HEATER65_SBrkAlarm_EN;
	float HEATER65_Temp_Hi_Alarm_Inhibit;
	float HEATER65_RateUp;
	float HEATER65_RateDown;
	float HEATER65_PID_P;
	float HEATER65_PID_I;
	float HEATER65_PID_D;
	float HEATER65_AutotuneActivate;
	float HEATER65_Autotune_Status;
	float HEATER65_Autotune_PID_P;
	float HEATER65_Autotune_PID_I;
	float HEATER65_Autotune_PID_D;
	float HEATER66_PV;
	float HEATER66_Temp_Hi_Alarm;
	float HEATER66_Working_Output;
	float HEATER66_Working_SP;
	float HEATER66_Inhibit_state;
	float HEATER66_TC_Error;
	float HEATER66_Auto_Manual;
	float HEATER66_SBrkAlarm_EN;
	float HEATER66_Temp_Hi_Alarm_Inhibit;
	float HEATER66_RateUp;
	float HEATER66_RateDown;
	float HEATER66_PID_P;
	float HEATER66_PID_I;
	float HEATER66_PID_D;
	float HEATER66_AutotuneActivate;
	float HEATER66_Autotune_Status;
	float HEATER66_Autotune_PID_P;
	float HEATER66_Autotune_PID_I;
	float HEATER66_Autotune_PID_D;
	float HEATER67_PV;
	float HEATER67_Temp_Hi_Alarm;
	float HEATER67_Working_Output;
	float HEATER67_Working_SP;
	float HEATER67_Inhibit_state;
	float HEATER67_TC_Error;
	float HEATER67_Auto_Manual;
	float HEATER67_SBrkAlarm_EN;
	float HEATER67_Temp_Hi_Alarm_Inhibit;
	float HEATER67_RateUp;
	float HEATER67_RateDown;
	float HEATER67_PID_P;
	float HEATER67_PID_I;
	float HEATER67_PID_D;
	float HEATER67_AutotuneActivate;
	float HEATER67_Autotune_Status;
	float HEATER67_Autotune_PID_P;
	float HEATER67_Autotune_PID_I;
	float HEATER67_Autotune_PID_D;
	float HEATER68_PV;
	float HEATER68_Temp_Hi_Alarm;
	float HEATER68_Working_Output;
	float HEATER68_Working_SP;
	float HEATER68_Inhibit_state;
	float HEATER68_TC_Error;
	float HEATER68_Auto_Manual;
	float HEATER68_SBrkAlarm_EN;
	float HEATER68_Temp_Hi_Alarm_Inhibit;
	float HEATER68_RateUp;
	float HEATER68_RateDown;
	float HEATER68_PID_P;
	float HEATER68_PID_I;
	float HEATER68_PID_D;
	float HEATER68_AutotuneActivate;
	float HEATER68_Autotune_Status;
	float HEATER68_Autotune_PID_P;
	float HEATER68_Autotune_PID_I;
	float HEATER68_Autotune_PID_D;
	float HEATER69_PV;
	float HEATER69_Temp_Hi_Alarm;
	float HEATER69_Working_Output;
	float HEATER69_Working_SP;
	float HEATER69_Inhibit_state;
	float HEATER69_TC_Error;
	float HEATER69_Auto_Manual;
	float HEATER69_SBrkAlarm_EN;
	float HEATER69_Temp_Hi_Alarm_Inhibit;
	float HEATER69_RateUp;
	float HEATER69_RateDown;
	float HEATER69_PID_P;
	float HEATER69_PID_I;
	float HEATER69_PID_D;
	float HEATER69_AutotuneActivate;
	float HEATER69_Autotune_Status;
	float HEATER69_Autotune_PID_P;
	float HEATER69_Autotune_PID_I;
	float HEATER69_Autotune_PID_D;
	float HEATER70_PV;
	float HEATER70_Temp_Hi_Alarm;
	float HEATER70_Working_Output;
	float HEATER70_Working_SP;
	float HEATER70_Inhibit_state;
	float HEATER70_TC_Error;
	float HEATER70_Auto_Manual;
	float HEATER70_SBrkAlarm_EN;
	float HEATER70_Temp_Hi_Alarm_Inhibit;
	float HEATER70_RateUp;
	float HEATER70_RateDown;
	float HEATER70_PID_P;
	float HEATER70_PID_I;
	float HEATER70_PID_D;
	float HEATER70_AutotuneActivate;
	float HEATER70_Autotune_Status;
	float HEATER70_Autotune_PID_P;
	float HEATER70_Autotune_PID_I;
	float HEATER70_Autotune_PID_D;
	float HEATER71_PV;
	float HEATER71_Temp_Hi_Alarm;
	float HEATER71_Working_Output;
	float HEATER71_Working_SP;
	float HEATER71_Inhibit_state;
	float HEATER71_TC_Error;
	float HEATER71_Auto_Manual;
	float HEATER71_SBrkAlarm_EN;
	float HEATER71_Temp_Hi_Alarm_Inhibit;
	float HEATER71_RateUp;
	float HEATER71_RateDown;
	float HEATER71_PID_P;
	float HEATER71_PID_I;
	float HEATER71_PID_D;
	float HEATER71_AutotuneActivate;
	float HEATER71_Autotune_Status;
	float HEATER71_Autotune_PID_P;
	float HEATER71_Autotune_PID_I;
	float HEATER71_Autotune_PID_D;
	float HEATER72_PV;
	float HEATER72_Temp_Hi_Alarm;
	float HEATER72_Working_Output;
	float HEATER72_Working_SP;
	float HEATER72_Inhibit_state;
	float HEATER72_TC_Error;
	float HEATER72_Auto_Manual;
	float HEATER72_SBrkAlarm_EN;
	float HEATER72_Temp_Hi_Alarm_Inhibit;
	float HEATER72_RateUp;
	float HEATER72_RateDown;
	float HEATER72_PID_P;
	float HEATER72_PID_I;
	float HEATER72_PID_D;
	float HEATER72_AutotuneActivate;
	float HEATER72_Autotune_Status;
	float HEATER72_Autotune_PID_P;
	float HEATER72_Autotune_PID_I;
	float HEATER72_Autotune_PID_D;
	float HEATER73_PV;
	float HEATER73_Temp_Hi_Alarm;
	float HEATER73_Working_Output;
	float HEATER73_Working_SP;
	float HEATER73_Inhibit_state;
	float HEATER73_TC_Error;
	float HEATER73_Auto_Manual;
	float HEATER73_SBrkAlarm_EN;
	float HEATER73_Temp_Hi_Alarm_Inhibit;
	float HEATER73_RateUp;
	float HEATER73_RateDown;
	float HEATER73_PID_P;
	float HEATER73_PID_I;
	float HEATER73_PID_D;
	float HEATER73_AutotuneActivate;
	float HEATER73_Autotune_Status;
	float HEATER73_Autotune_PID_P;
	float HEATER73_Autotune_PID_I;
	float HEATER73_Autotune_PID_D;
	float HEATER74_PV;
	float HEATER74_Temp_Hi_Alarm;
	float HEATER74_Working_Output;
	float HEATER74_Working_SP;
	float HEATER74_Inhibit_state;
	float HEATER74_TC_Error;
	float HEATER74_Auto_Manual;
	float HEATER74_SBrkAlarm_EN;
	float HEATER74_Temp_Hi_Alarm_Inhibit;
	float HEATER74_RateUp;
	float HEATER74_RateDown;
	float HEATER74_PID_P;
	float HEATER74_PID_I;
	float HEATER74_PID_D;
	float HEATER74_AutotuneActivate;
	float HEATER74_Autotune_Status;
	float HEATER74_Autotune_PID_P;
	float HEATER74_Autotune_PID_I;
	float HEATER74_Autotune_PID_D;
	float HEATER75_PV;
	float HEATER75_Temp_Hi_Alarm;
	float HEATER75_Working_Output;
	float HEATER75_Working_SP;
	float HEATER75_Inhibit_state;
	float HEATER75_TC_Error;
	float HEATER75_Auto_Manual;
	float HEATER75_SBrkAlarm_EN;
	float HEATER75_Temp_Hi_Alarm_Inhibit;
	float HEATER75_RateUp;
	float HEATER75_RateDown;
	float HEATER75_PID_P;
	float HEATER75_PID_I;
	float HEATER75_PID_D;
	float HEATER75_AutotuneActivate;
	float HEATER75_Autotune_Status;
	float HEATER75_Autotune_PID_P;
	float HEATER75_Autotune_PID_I;
	float HEATER75_Autotune_PID_D;
	float HEATER76_PV;
	float HEATER76_Temp_Hi_Alarm;
	float HEATER76_Working_Output;
	float HEATER76_Working_SP;
	float HEATER76_Inhibit_state;
	float HEATER76_TC_Error;
	float HEATER76_Auto_Manual;
	float HEATER76_SBrkAlarm_EN;
	float HEATER76_Temp_Hi_Alarm_Inhibit;
	float HEATER76_RateUp;
	float HEATER76_RateDown;
	float HEATER76_PID_P;
	float HEATER76_PID_I;
	float HEATER76_PID_D;
	float HEATER76_AutotuneActivate;
	float HEATER76_Autotune_Status;
	float HEATER76_Autotune_PID_P;
	float HEATER76_Autotune_PID_I;
	float HEATER76_Autotune_PID_D;
	float HEATER77_PV;
	float HEATER77_Temp_Hi_Alarm;
	float HEATER77_Working_Output;
	float HEATER77_Working_SP;
	float HEATER77_Inhibit_state;
	float HEATER77_TC_Error;
	float HEATER77_Auto_Manual;
	float HEATER77_SBrkAlarm_EN;
	float HEATER77_Temp_Hi_Alarm_Inhibit;
	float HEATER77_RateUp;
	float HEATER77_RateDown;
	float HEATER77_PID_P;
	float HEATER77_PID_I;
	float HEATER77_PID_D;
	float HEATER77_AutotuneActivate;
	float HEATER77_Autotune_Status;
	float HEATER77_Autotune_PID_P;
	float HEATER77_Autotune_PID_I;
	float HEATER77_Autotune_PID_D;
	float HEATER78_PV;
	float HEATER78_Temp_Hi_Alarm;
	float HEATER78_Working_Output;
	float HEATER78_Working_SP;
	float HEATER78_Inhibit_state;
	float HEATER78_TC_Error;
	float HEATER78_Auto_Manual;
	float HEATER78_SBrkAlarm_EN;
	float HEATER78_Temp_Hi_Alarm_Inhibit;
	float HEATER78_RateUp;
	float HEATER78_RateDown;
	float HEATER78_PID_P;
	float HEATER78_PID_I;
	float HEATER78_PID_D;
	float HEATER78_AutotuneActivate;
	float HEATER78_Autotune_Status;
	float HEATER78_Autotune_PID_P;
	float HEATER78_Autotune_PID_I;
	float HEATER78_Autotune_PID_D;
	float HEATER79_PV;
	float HEATER79_Temp_Hi_Alarm;
	float HEATER79_Working_Output;
	float HEATER79_Working_SP;
	float HEATER79_Inhibit_state;
	float HEATER79_TC_Error;
	float HEATER79_Auto_Manual;
	float HEATER79_SBrkAlarm_EN;
	float HEATER79_Temp_Hi_Alarm_Inhibit;
	float HEATER79_RateUp;
	float HEATER79_RateDown;
	float HEATER79_PID_P;
	float HEATER79_PID_I;
	float HEATER79_PID_D;
	float HEATER79_AutotuneActivate;
	float HEATER79_Autotune_Status;
	float HEATER79_Autotune_PID_P;
	float HEATER79_Autotune_PID_I;
	float HEATER79_Autotune_PID_D;
	float HEATER80_PV;
	float HEATER80_Temp_Hi_Alarm;
	float HEATER80_Working_Output;
	float HEATER80_Working_SP;
	float HEATER80_Inhibit_state;
	float HEATER80_TC_Error;
	float HEATER80_Auto_Manual;
	float HEATER80_SBrkAlarm_EN;
	float HEATER80_Temp_Hi_Alarm_Inhibit;
	float HEATER80_RateUp;
	float HEATER80_RateDown;
	float HEATER80_PID_P;
	float HEATER80_PID_I;
	float HEATER80_PID_D;
	float HEATER80_AutotuneActivate;
	float HEATER80_Autotune_Status;
	float HEATER80_Autotune_PID_P;
	float HEATER80_Autotune_PID_I;
	float HEATER80_Autotune_PID_D;
	float HEATER81_PV;
	float HEATER81_Temp_Hi_Alarm;
	float HEATER81_Working_Output;
	float HEATER81_Working_SP;
	float HEATER81_Inhibit_state;
	float HEATER81_TC_Error;
	float HEATER81_Auto_Manual;
	float HEATER81_SBrkAlarm_EN;
	float HEATER81_Temp_Hi_Alarm_Inhibit;
	float HEATER81_RateUp;
	float HEATER81_RateDown;
	float HEATER81_PID_P;
	float HEATER81_PID_I;
	float HEATER81_PID_D;
	float HEATER81_AutotuneActivate;
	float HEATER81_Autotune_Status;
	float HEATER81_Autotune_PID_P;
	float HEATER81_Autotune_PID_I;
	float HEATER81_Autotune_PID_D;
	float HEATER82_PV;
	float HEATER82_Temp_Hi_Alarm;
	float HEATER82_Working_Output;
	float HEATER82_Working_SP;
	float HEATER82_Inhibit_state;
	float HEATER82_TC_Error;
	float HEATER82_Auto_Manual;
	float HEATER82_SBrkAlarm_EN;
	float HEATER82_Temp_Hi_Alarm_Inhibit;
	float HEATER82_RateUp;
	float HEATER82_RateDown;
	float HEATER82_PID_P;
	float HEATER82_PID_I;
	float HEATER82_PID_D;
	float HEATER82_AutotuneActivate;
	float HEATER82_Autotune_Status;
	float HEATER82_Autotune_PID_P;
	float HEATER82_Autotune_PID_I;
	float HEATER82_Autotune_PID_D;
	float HEATER83_PV;
	float HEATER83_Temp_Hi_Alarm;
	float HEATER83_Working_Output;
	float HEATER83_Working_SP;
	float HEATER83_Inhibit_state;
	float HEATER83_TC_Error;
	float HEATER83_Auto_Manual;
	float HEATER83_SBrkAlarm_EN;
	float HEATER83_Temp_Hi_Alarm_Inhibit;
	float HEATER83_RateUp;
	float HEATER83_RateDown;
	float HEATER83_PID_P;
	float HEATER83_PID_I;
	float HEATER83_PID_D;
	float HEATER83_AutotuneActivate;
	float HEATER83_Autotune_Status;
	float HEATER83_Autotune_PID_P;
	float HEATER83_Autotune_PID_I;
	float HEATER83_Autotune_PID_D;
	float HEATER84_PV;
	float HEATER84_Temp_Hi_Alarm;
	float HEATER84_Working_Output;
	float HEATER84_Working_SP;
	float HEATER84_Inhibit_state;
	float HEATER84_TC_Error;
	float HEATER84_Auto_Manual;
	float HEATER84_SBrkAlarm_EN;
	float HEATER84_Temp_Hi_Alarm_Inhibit;
	float HEATER84_RateUp;
	float HEATER84_RateDown;
	float HEATER84_PID_P;
	float HEATER84_PID_I;
	float HEATER84_PID_D;
	float HEATER84_AutotuneActivate;
	float HEATER84_Autotune_Status;
	float HEATER84_Autotune_PID_P;
	float HEATER84_Autotune_PID_I;
	float HEATER84_Autotune_PID_D;
	float HEATER85_PV;
	float HEATER85_Temp_Hi_Alarm;
	float HEATER85_Working_Output;
	float HEATER85_Working_SP;
	float HEATER85_Inhibit_state;
	float HEATER85_TC_Error;
	float HEATER85_Auto_Manual;
	float HEATER85_SBrkAlarm_EN;
	float HEATER85_Temp_Hi_Alarm_Inhibit;
	float HEATER85_RateUp;
	float HEATER85_RateDown;
	float HEATER85_PID_P;
	float HEATER85_PID_I;
	float HEATER85_PID_D;
	float HEATER85_AutotuneActivate;
	float HEATER85_Autotune_Status;
	float HEATER85_Autotune_PID_P;
	float HEATER85_Autotune_PID_I;
	float HEATER85_Autotune_PID_D;
	float HEATER86_PV;
	float HEATER86_Temp_Hi_Alarm;
	float HEATER86_Working_Output;
	float HEATER86_Working_SP;
	float HEATER86_Inhibit_state;
	float HEATER86_TC_Error;
	float HEATER86_Auto_Manual;
	float HEATER86_SBrkAlarm_EN;
	float HEATER86_Temp_Hi_Alarm_Inhibit;
	float HEATER86_RateUp;
	float HEATER86_RateDown;
	float HEATER86_PID_P;
	float HEATER86_PID_I;
	float HEATER86_PID_D;
	float HEATER86_AutotuneActivate;
	float HEATER86_Autotune_Status;
	float HEATER86_Autotune_PID_P;
	float HEATER86_Autotune_PID_I;
	float HEATER86_Autotune_PID_D;
	float HEATER87_PV;
	float HEATER87_Temp_Hi_Alarm;
	float HEATER87_Working_Output;
	float HEATER87_Working_SP;
	float HEATER87_Inhibit_state;
	float HEATER87_TC_Error;
	float HEATER87_Auto_Manual;
	float HEATER87_SBrkAlarm_EN;
	float HEATER87_Temp_Hi_Alarm_Inhibit;
	float HEATER87_RateUp;
	float HEATER87_RateDown;
	float HEATER87_PID_P;
	float HEATER87_PID_I;
	float HEATER87_PID_D;
	float HEATER87_AutotuneActivate;
	float HEATER87_Autotune_Status;
	float HEATER87_Autotune_PID_P;
	float HEATER87_Autotune_PID_I;
	float HEATER87_Autotune_PID_D;
	float HEATER88_PV;
	float HEATER88_Temp_Hi_Alarm;
	float HEATER88_Working_Output;
	float HEATER88_Working_SP;
	float HEATER88_Inhibit_state;
	float HEATER88_TC_Error;
	float HEATER88_Auto_Manual;
	float HEATER88_SBrkAlarm_EN;
	float HEATER88_Temp_Hi_Alarm_Inhibit;
	float HEATER88_RateUp;
	float HEATER88_RateDown;
	float HEATER88_PID_P;
	float HEATER88_PID_I;
	float HEATER88_PID_D;
	float HEATER88_AutotuneActivate;
	float HEATER88_Autotune_Status;
	float HEATER88_Autotune_PID_P;
	float HEATER88_Autotune_PID_I;
	float HEATER88_Autotune_PID_D;
	float HEATER89_PV;
	float HEATER89_Temp_Hi_Alarm;
	float HEATER89_Working_Output;
	float HEATER89_Working_SP;
	float HEATER89_Inhibit_state;
	float HEATER89_TC_Error;
	float HEATER89_Auto_Manual;
	float HEATER89_SBrkAlarm_EN;
	float HEATER89_Temp_Hi_Alarm_Inhibit;
	float HEATER89_RateUp;
	float HEATER89_RateDown;
	float HEATER89_PID_P;
	float HEATER89_PID_I;
	float HEATER89_PID_D;
	float HEATER89_AutotuneActivate;
	float HEATER89_Autotune_Status;
	float HEATER89_Autotune_PID_P;
	float HEATER89_Autotune_PID_I;
	float HEATER89_Autotune_PID_D;
	float HEATER90_PV;
	float HEATER90_Temp_Hi_Alarm;
	float HEATER90_Working_Output;
	float HEATER90_Working_SP;
	float HEATER90_Inhibit_state;
	float HEATER90_TC_Error;
	float HEATER90_Auto_Manual;
	float HEATER90_SBrkAlarm_EN;
	float HEATER90_Temp_Hi_Alarm_Inhibit;
	float HEATER90_RateUp;
	float HEATER90_RateDown;
	float HEATER90_PID_P;
	float HEATER90_PID_I;
	float HEATER90_PID_D;
	float HEATER90_AutotuneActivate;
	float HEATER90_Autotune_Status;
	float HEATER90_Autotune_PID_P;
	float HEATER90_Autotune_PID_I;
	float HEATER90_Autotune_PID_D;
	float HEATER91_PV;
	float HEATER91_Temp_Hi_Alarm;
	float HEATER91_Working_Output;
	float HEATER91_Working_SP;
	float HEATER91_Inhibit_state;
	float HEATER91_TC_Error;
	float HEATER91_Auto_Manual;
	float HEATER91_SBrkAlarm_EN;
	float HEATER91_Temp_Hi_Alarm_Inhibit;
	float HEATER91_RateUp;
	float HEATER91_RateDown;
	float HEATER91_PID_P;
	float HEATER91_PID_I;
	float HEATER91_PID_D;
	float HEATER91_AutotuneActivate;
	float HEATER91_Autotune_Status;
	float HEATER91_Autotune_PID_P;
	float HEATER91_Autotune_PID_I;
	float HEATER91_Autotune_PID_D;
	float HEATER92_PV;
	float HEATER92_Temp_Hi_Alarm;
	float HEATER92_Working_Output;
	float HEATER92_Working_SP;
	float HEATER92_Inhibit_state;
	float HEATER92_TC_Error;
	float HEATER92_Auto_Manual;
	float HEATER92_SBrkAlarm_EN;
	float HEATER92_Temp_Hi_Alarm_Inhibit;
	float HEATER92_RateUp;
	float HEATER92_RateDown;
	float HEATER92_PID_P;
	float HEATER92_PID_I;
	float HEATER92_PID_D;
	float HEATER92_AutotuneActivate;
	float HEATER92_Autotune_Status;
	float HEATER92_Autotune_PID_P;
	float HEATER92_Autotune_PID_I;
	float HEATER92_Autotune_PID_D;
	float HEATER93_PV;
	float HEATER93_Temp_Hi_Alarm;
	float HEATER93_Working_Output;
	float HEATER93_Working_SP;
	float HEATER93_Inhibit_state;
	float HEATER93_TC_Error;
	float HEATER93_Auto_Manual;
	float HEATER93_SBrkAlarm_EN;
	float HEATER93_Temp_Hi_Alarm_Inhibit;
	float HEATER93_RateUp;
	float HEATER93_RateDown;
	float HEATER93_PID_P;
	float HEATER93_PID_I;
	float HEATER93_PID_D;
	float HEATER93_AutotuneActivate;
	float HEATER93_Autotune_Status;
	float HEATER93_Autotune_PID_P;
	float HEATER93_Autotune_PID_I;
	float HEATER93_Autotune_PID_D;
	float HEATER94_PV;
	float HEATER94_Temp_Hi_Alarm;
	float HEATER94_Working_Output;
	float HEATER94_Working_SP;
	float HEATER94_Inhibit_state;
	float HEATER94_TC_Error;
	float HEATER94_Auto_Manual;
	float HEATER94_SBrkAlarm_EN;
	float HEATER94_Temp_Hi_Alarm_Inhibit;
	float HEATER94_RateUp;
	float HEATER94_RateDown;
	float HEATER94_PID_P;
	float HEATER94_PID_I;
	float HEATER94_PID_D;
	float HEATER94_AutotuneActivate;
	float HEATER94_Autotune_Status;
	float HEATER94_Autotune_PID_P;
	float HEATER94_Autotune_PID_I;
	float HEATER94_Autotune_PID_D;
	float HEATER95_PV;
	float HEATER95_Temp_Hi_Alarm;
	float HEATER95_Working_Output;
	float HEATER95_Working_SP;
	float HEATER95_Inhibit_state;
	float HEATER95_TC_Error;
	float HEATER95_Auto_Manual;
	float HEATER95_SBrkAlarm_EN;
	float HEATER95_Temp_Hi_Alarm_Inhibit;
	float HEATER95_RateUp;
	float HEATER95_RateDown;
	float HEATER95_PID_P;
	float HEATER95_PID_I;
	float HEATER95_PID_D;
	float HEATER95_AutotuneActivate;
	float HEATER95_Autotune_Status;
	float HEATER95_Autotune_PID_P;
	float HEATER95_Autotune_PID_I;
	float HEATER95_Autotune_PID_D;
	float HEATER96_PV;
	float HEATER96_Temp_Hi_Alarm;
	float HEATER96_Working_Output;
	float HEATER96_Working_SP;
	float HEATER96_Inhibit_state;
	float HEATER96_TC_Error;
	float HEATER96_Auto_Manual;
	float HEATER96_SBrkAlarm_EN;
	float HEATER96_Temp_Hi_Alarm_Inhibit;
	float HEATER96_RateUp;
	float HEATER96_RateDown;
	float HEATER96_PID_P;
	float HEATER96_PID_I;
	float HEATER96_PID_D;
	float HEATER96_AutotuneActivate;
	float HEATER96_Autotune_Status;
	float HEATER96_Autotune_PID_P;
	float HEATER96_Autotune_PID_I;
	float HEATER96_Autotune_PID_D;
	float HEATER97_PV;
	float HEATER97_Temp_Hi_Alarm;
	float HEATER97_Working_Output;
	float HEATER97_Working_SP;
	float HEATER97_Inhibit_state;
	float HEATER97_TC_Error;
	float HEATER97_Auto_Manual;
	float HEATER97_SBrkAlarm_EN;
	float HEATER97_Temp_Hi_Alarm_Inhibit;
	float HEATER97_RateUp;
	float HEATER97_RateDown;
	float HEATER97_PID_P;
	float HEATER97_PID_I;
	float HEATER97_PID_D;
	float HEATER97_AutotuneActivate;
	float HEATER97_Autotune_Status;
	float HEATER97_Autotune_PID_P;
	float HEATER97_Autotune_PID_I;
	float HEATER97_Autotune_PID_D;
	float HEATER98_PV;
	float HEATER98_Temp_Hi_Alarm;
	float HEATER98_Working_Output;
	float HEATER98_Working_SP;
	float HEATER98_Inhibit_state;
	float HEATER98_TC_Error;
	float HEATER98_Auto_Manual;
	float HEATER98_SBrkAlarm_EN;
	float HEATER98_Temp_Hi_Alarm_Inhibit;
	float HEATER98_RateUp;
	float HEATER98_RateDown;
	float HEATER98_PID_P;
	float HEATER98_PID_I;
	float HEATER98_PID_D;
	float HEATER98_AutotuneActivate;
	float HEATER98_Autotune_Status;
	float HEATER98_Autotune_PID_P;
	float HEATER98_Autotune_PID_I;
	float HEATER98_Autotune_PID_D;
	float HEATER99_PV;
	float HEATER99_Temp_Hi_Alarm;
	float HEATER99_Working_Output;
	float HEATER99_Working_SP;
	float HEATER99_Inhibit_state;
	float HEATER99_TC_Error;
	float HEATER99_Auto_Manual;
	float HEATER99_SBrkAlarm_EN;
	float HEATER99_Temp_Hi_Alarm_Inhibit;
	float HEATER99_RateUp;
	float HEATER99_RateDown;
	float HEATER99_PID_P;
	float HEATER99_PID_I;
	float HEATER99_PID_D;
	float HEATER99_AutotuneActivate;
	float HEATER99_Autotune_Status;
	float HEATER99_Autotune_PID_P;
	float HEATER99_Autotune_PID_I;
	float HEATER99_Autotune_PID_D;
	float HEATER100_PV;
	float HEATER100_Temp_Hi_Alarm;
	float HEATER100_Working_Output;
	float HEATER100_Working_SP;
	float HEATER100_Inhibit_state;
	float HEATER100_TC_Error;
	float HEATER100_Auto_Manual;
	float HEATER100_SBrkAlarm_EN;
	float HEATER100_Temp_Hi_Alarm_Inhibit;
	float HEATER100_RateUp;
	float HEATER100_RateDown;
	float HEATER100_PID_P;
	float HEATER100_PID_I;
	float HEATER100_PID_D;
	float HEATER100_AutotuneActivate;
	float HEATER100_Autotune_Status;
	float HEATER100_Autotune_PID_P;
	float HEATER100_Autotune_PID_I;
	float HEATER100_Autotune_PID_D;
	float HEATER101_PV;
	float HEATER101_Temp_Hi_Alarm;
	float HEATER101_Working_Output;
	float HEATER101_Working_SP;
	float HEATER101_Inhibit_state;
	float HEATER101_TC_Error;
	float HEATER101_Auto_Manual;
	float HEATER101_SBrkAlarm_EN;
	float HEATER101_Temp_Hi_Alarm_Inhibit;
	float HEATER101_RateUp;
	float HEATER101_RateDown;
	float HEATER101_PID_P;
	float HEATER101_PID_I;
	float HEATER101_PID_D;
	float HEATER101_AutotuneActivate;
	float HEATER101_Autotune_Status;
	float HEATER101_Autotune_PID_P;
	float HEATER101_Autotune_PID_I;
	float HEATER101_Autotune_PID_D;
	float HEATER102_PV;
	float HEATER102_Temp_Hi_Alarm;
	float HEATER102_Working_Output;
	float HEATER102_Working_SP;
	float HEATER102_Inhibit_state;
	float HEATER102_TC_Error;
	float HEATER102_Auto_Manual;
	float HEATER102_SBrkAlarm_EN;
	float HEATER102_Temp_Hi_Alarm_Inhibit;
	float HEATER102_RateUp;
	float HEATER102_RateDown;
	float HEATER102_PID_P;
	float HEATER102_PID_I;
	float HEATER102_PID_D;
	float HEATER102_AutotuneActivate;
	float HEATER102_Autotune_Status;
	float HEATER102_Autotune_PID_P;
	float HEATER102_Autotune_PID_I;
	float HEATER102_Autotune_PID_D;
	float HEATER103_PV;
	float HEATER103_Temp_Hi_Alarm;
	float HEATER103_Working_Output;
	float HEATER103_Working_SP;
	float HEATER103_Inhibit_state;
	float HEATER103_TC_Error;
	float HEATER103_Auto_Manual;
	float HEATER103_SBrkAlarm_EN;
	float HEATER103_Temp_Hi_Alarm_Inhibit;
	float HEATER103_RateUp;
	float HEATER103_RateDown;
	float HEATER103_PID_P;
	float HEATER103_PID_I;
	float HEATER103_PID_D;
	float HEATER103_AutotuneActivate;
	float HEATER103_Autotune_Status;
	float HEATER103_Autotune_PID_P;
	float HEATER103_Autotune_PID_I;
	float HEATER103_Autotune_PID_D;
	float HEATER104_PV;
	float HEATER104_Temp_Hi_Alarm;
	float HEATER104_Working_Output;
	float HEATER104_Working_SP;
	float HEATER104_Inhibit_state;
	float HEATER104_TC_Error;
	float HEATER104_Auto_Manual;
	float HEATER104_SBrkAlarm_EN;
	float HEATER104_Temp_Hi_Alarm_Inhibit;
	float HEATER104_RateUp;
	float HEATER104_RateDown;
	float HEATER104_PID_P;
	float HEATER104_PID_I;
	float HEATER104_PID_D;
	float HEATER104_AutotuneActivate;
	float HEATER104_Autotune_Status;
	float HEATER104_Autotune_PID_P;
	float HEATER104_Autotune_PID_I;
	float HEATER104_Autotune_PID_D;
	float HEATER105_PV;
	float HEATER105_Temp_Hi_Alarm;
	float HEATER105_Working_Output;
	float HEATER105_Working_SP;
	float HEATER105_Inhibit_state;
	float HEATER105_TC_Error;
	float HEATER105_Auto_Manual;
	float HEATER105_SBrkAlarm_EN;
	float HEATER105_Temp_Hi_Alarm_Inhibit;
	float HEATER105_RateUp;
	float HEATER105_RateDown;
	float HEATER105_PID_P;
	float HEATER105_PID_I;
	float HEATER105_PID_D;
	float HEATER105_AutotuneActivate;
	float HEATER105_Autotune_Status;
	float HEATER105_Autotune_PID_P;
	float HEATER105_Autotune_PID_I;
	float HEATER105_Autotune_PID_D;
	float HEATER106_PV;
	float HEATER106_Temp_Hi_Alarm;
	float HEATER106_Working_Output;
	float HEATER106_Working_SP;
	float HEATER106_Inhibit_state;
	float HEATER106_TC_Error;
	float HEATER106_Auto_Manual;
	float HEATER106_SBrkAlarm_EN;
	float HEATER106_Temp_Hi_Alarm_Inhibit;
	float HEATER106_RateUp;
	float HEATER106_RateDown;
	float HEATER106_PID_P;
	float HEATER106_PID_I;
	float HEATER106_PID_D;
	float HEATER106_AutotuneActivate;
	float HEATER106_Autotune_Status;
	float HEATER106_Autotune_PID_P;
	float HEATER106_Autotune_PID_I;
	float HEATER106_Autotune_PID_D;
	float HEATER107_PV;
	float HEATER107_Temp_Hi_Alarm;
	float HEATER107_Working_Output;
	float HEATER107_Working_SP;
	float HEATER107_Inhibit_state;
	float HEATER107_TC_Error;
	float HEATER107_Auto_Manual;
	float HEATER107_SBrkAlarm_EN;
	float HEATER107_Temp_Hi_Alarm_Inhibit;
	float HEATER107_RateUp;
	float HEATER107_RateDown;
	float HEATER107_PID_P;
	float HEATER107_PID_I;
	float HEATER107_PID_D;
	float HEATER107_AutotuneActivate;
	float HEATER107_Autotune_Status;
	float HEATER107_Autotune_PID_P;
	float HEATER107_Autotune_PID_I;
	float HEATER107_Autotune_PID_D;
	float HEATER108_PV;
	float HEATER108_Temp_Hi_Alarm;
	float HEATER108_Working_Output;
	float HEATER108_Working_SP;
	float HEATER108_Inhibit_state;
	float HEATER108_TC_Error;
	float HEATER108_Auto_Manual;
	float HEATER108_SBrkAlarm_EN;
	float HEATER108_Temp_Hi_Alarm_Inhibit;
	float HEATER108_RateUp;
	float HEATER108_RateDown;
	float HEATER108_PID_P;
	float HEATER108_PID_I;
	float HEATER108_PID_D;
	float HEATER108_AutotuneActivate;
	float HEATER108_Autotune_Status;
	float HEATER108_Autotune_PID_P;
	float HEATER108_Autotune_PID_I;
	float HEATER108_Autotune_PID_D;
	float HEATER109_PV;
	float HEATER109_Temp_Hi_Alarm;
	float HEATER109_Working_Output;
	float HEATER109_Working_SP;
	float HEATER109_Inhibit_state;
	float HEATER109_TC_Error;
	float HEATER109_Auto_Manual;
	float HEATER109_SBrkAlarm_EN;
	float HEATER109_Temp_Hi_Alarm_Inhibit;
	float HEATER109_RateUp;
	float HEATER109_RateDown;
	float HEATER109_PID_P;
	float HEATER109_PID_I;
	float HEATER109_PID_D;
	float HEATER109_AutotuneActivate;
	float HEATER109_Autotune_Status;
	float HEATER109_Autotune_PID_P;
	float HEATER109_Autotune_PID_I;
	float HEATER109_Autotune_PID_D;
	float HEATER110_PV;
	float HEATER110_Temp_Hi_Alarm;
	float HEATER110_Working_Output;
	float HEATER110_Working_SP;
	float HEATER110_Inhibit_state;
	float HEATER110_TC_Error;
	float HEATER110_Auto_Manual;
	float HEATER110_SBrkAlarm_EN;
	float HEATER110_Temp_Hi_Alarm_Inhibit;
	float HEATER110_RateUp;
	float HEATER110_RateDown;
	float HEATER110_PID_P;
	float HEATER110_PID_I;
	float HEATER110_PID_D;
	float HEATER110_AutotuneActivate;
	float HEATER110_Autotune_Status;
	float HEATER110_Autotune_PID_P;
	float HEATER110_Autotune_PID_I;
	float HEATER110_Autotune_PID_D;
	float HEATER111_PV;
	float HEATER111_Temp_Hi_Alarm;
	float HEATER111_Working_Output;
	float HEATER111_Working_SP;
	float HEATER111_Inhibit_state;
	float HEATER111_TC_Error;
	float HEATER111_Auto_Manual;
	float HEATER111_SBrkAlarm_EN;
	float HEATER111_Temp_Hi_Alarm_Inhibit;
	float HEATER111_RateUp;
	float HEATER111_RateDown;
	float HEATER111_PID_P;
	float HEATER111_PID_I;
	float HEATER111_PID_D;
	float HEATER111_AutotuneActivate;
	float HEATER111_Autotune_Status;
	float HEATER111_Autotune_PID_P;
	float HEATER111_Autotune_PID_I;
	float HEATER111_Autotune_PID_D;
	float HEATER112_PV;
	float HEATER112_Temp_Hi_Alarm;
	float HEATER112_Working_Output;
	float HEATER112_Working_SP;
	float HEATER112_Inhibit_state;
	float HEATER112_TC_Error;
	float HEATER112_Auto_Manual;
	float HEATER112_SBrkAlarm_EN;
	float HEATER112_Temp_Hi_Alarm_Inhibit;
	float HEATER112_RateUp;
	float HEATER112_RateDown;
	float HEATER112_PID_P;
	float HEATER112_PID_I;
	float HEATER112_PID_D;
	float HEATER112_AutotuneActivate;
	float HEATER112_Autotune_Status;
	float HEATER112_Autotune_PID_P;
	float HEATER112_Autotune_PID_I;
	float HEATER112_Autotune_PID_D;
	float HEATER113_PV;
	float HEATER113_Temp_Hi_Alarm;
	float HEATER113_Working_Output;
	float HEATER113_Working_SP;
	float HEATER113_Inhibit_state;
	float HEATER113_TC_Error;
	float HEATER113_Auto_Manual;
	float HEATER113_SBrkAlarm_EN;
	float HEATER113_Temp_Hi_Alarm_Inhibit;
	float HEATER113_RateUp;
	float HEATER113_RateDown;
	float HEATER113_PID_P;
	float HEATER113_PID_I;
	float HEATER113_PID_D;
	float HEATER113_AutotuneActivate;
	float HEATER113_Autotune_Status;
	float HEATER113_Autotune_PID_P;
	float HEATER113_Autotune_PID_I;
	float HEATER113_Autotune_PID_D;
	float HEATER114_PV;
	float HEATER114_Temp_Hi_Alarm;
	float HEATER114_Working_Output;
	float HEATER114_Working_SP;
	float HEATER114_Inhibit_state;
	float HEATER114_TC_Error;
	float HEATER114_Auto_Manual;
	float HEATER114_SBrkAlarm_EN;
	float HEATER114_Temp_Hi_Alarm_Inhibit;
	float HEATER114_RateUp;
	float HEATER114_RateDown;
	float HEATER114_PID_P;
	float HEATER114_PID_I;
	float HEATER114_PID_D;
	float HEATER114_AutotuneActivate;
	float HEATER114_Autotune_Status;
	float HEATER114_Autotune_PID_P;
	float HEATER114_Autotune_PID_I;
	float HEATER114_Autotune_PID_D;
	float HEATER115_PV;
	float HEATER115_Temp_Hi_Alarm;
	float HEATER115_Working_Output;
	float HEATER115_Working_SP;
	float HEATER115_Inhibit_state;
	float HEATER115_TC_Error;
	float HEATER115_Auto_Manual;
	float HEATER115_SBrkAlarm_EN;
	float HEATER115_Temp_Hi_Alarm_Inhibit;
	float HEATER115_RateUp;
	float HEATER115_RateDown;
	float HEATER115_PID_P;
	float HEATER115_PID_I;
	float HEATER115_PID_D;
	float HEATER115_AutotuneActivate;
	float HEATER115_Autotune_Status;
	float HEATER115_Autotune_PID_P;
	float HEATER115_Autotune_PID_I;
	float HEATER115_Autotune_PID_D;
	float HEATER116_PV;
	float HEATER116_Temp_Hi_Alarm;
	float HEATER116_Working_Output;
	float HEATER116_Working_SP;
	float HEATER116_Inhibit_state;
	float HEATER116_TC_Error;
	float HEATER116_Auto_Manual;
	float HEATER116_SBrkAlarm_EN;
	float HEATER116_Temp_Hi_Alarm_Inhibit;
	float HEATER116_RateUp;
	float HEATER116_RateDown;
	float HEATER116_PID_P;
	float HEATER116_PID_I;
	float HEATER116_PID_D;
	float HEATER116_AutotuneActivate;
	float HEATER116_Autotune_Status;
	float HEATER116_Autotune_PID_P;
	float HEATER116_Autotune_PID_I;
	float HEATER116_Autotune_PID_D;
	float HEATER117_PV;
	float HEATER117_Temp_Hi_Alarm;
	float HEATER117_Working_Output;
	float HEATER117_Working_SP;
	float HEATER117_Inhibit_state;
	float HEATER117_TC_Error;
	float HEATER117_Auto_Manual;
	float HEATER117_SBrkAlarm_EN;
	float HEATER117_Temp_Hi_Alarm_Inhibit;
	float HEATER117_RateUp;
	float HEATER117_RateDown;
	float HEATER117_PID_P;
	float HEATER117_PID_I;
	float HEATER117_PID_D;
	float HEATER117_AutotuneActivate;
	float HEATER117_Autotune_Status;
	float HEATER117_Autotune_PID_P;
	float HEATER117_Autotune_PID_I;
	float HEATER117_Autotune_PID_D;
	float HEATER118_PV;
	float HEATER118_Temp_Hi_Alarm;
	float HEATER118_Working_Output;
	float HEATER118_Working_SP;
	float HEATER118_Inhibit_state;
	float HEATER118_TC_Error;
	float HEATER118_Auto_Manual;
	float HEATER118_SBrkAlarm_EN;
	float HEATER118_Temp_Hi_Alarm_Inhibit;
	float HEATER118_RateUp;
	float HEATER118_RateDown;
	float HEATER118_PID_P;
	float HEATER118_PID_I;
	float HEATER118_PID_D;
	float HEATER118_AutotuneActivate;
	float HEATER118_Autotune_Status;
	float HEATER118_Autotune_PID_P;
	float HEATER118_Autotune_PID_I;
	float HEATER118_Autotune_PID_D;
	float HEATER119_PV;
	float HEATER119_Temp_Hi_Alarm;
	float HEATER119_Working_Output;
	float HEATER119_Working_SP;
	float HEATER119_Inhibit_state;
	float HEATER119_TC_Error;
	float HEATER119_Auto_Manual;
	float HEATER119_SBrkAlarm_EN;
	float HEATER119_Temp_Hi_Alarm_Inhibit;
	float HEATER119_RateUp;
	float HEATER119_RateDown;
	float HEATER119_PID_P;
	float HEATER119_PID_I;
	float HEATER119_PID_D;
	float HEATER119_AutotuneActivate;
	float HEATER119_Autotune_Status;
	float HEATER119_Autotune_PID_P;
	float HEATER119_Autotune_PID_I;
	float HEATER119_Autotune_PID_D;
	float HEATER120_PV;
	float HEATER120_Temp_Hi_Alarm;
	float HEATER120_Working_Output;
	float HEATER120_Working_SP;
	float HEATER120_Inhibit_state;
	float HEATER120_TC_Error;
	float HEATER120_Auto_Manual;
	float HEATER120_SBrkAlarm_EN;
	float HEATER120_Temp_Hi_Alarm_Inhibit;
	float HEATER120_RateUp;
	float HEATER120_RateDown;
	float HEATER120_PID_P;
	float HEATER120_PID_I;
	float HEATER120_PID_D;
	float HEATER120_AutotuneActivate;
	float HEATER120_Autotune_Status;
	float HEATER120_Autotune_PID_P;
	float HEATER120_Autotune_PID_I;
	float HEATER120_Autotune_PID_D;
	float FFU1_1_STATUS;
	float FFU1_2_STATUS;
	float FFU1_3_STATUS;
	float FFU1_4_STATUS;
	float FFU1_5_STATUS;
	float FFU1_6_STATUS;
	float FFU2_1_STATUS;
	float FFU2_2_STATUS;
	float FFU2_3_STATUS;
	float FFU2_4_STATUS;
	float FFU2_5_STATUS;
	float FFU2_6_STATUS;
	float FFU3_1_STATUS;
	float FFU3_2_STATUS;
	float FFU3_3_STATUS;
	float FFU3_4_STATUS;
	float FFU3_5_STATUS;
	float FFU3_6_STATUS;
	float FFU1_1_SPEED_PV;
	float FFU1_2_SPEED_PV;
	float FFU1_3_SPEED_PV;
	float FFU1_4_SPEED_PV;
	float FFU1_5_SPEED_PV;
	float FFU1_6_SPEED_PV;
	float FFU2_1_SPEED_PV;
	float FFU2_2_SPEED_PV;
	float FFU2_3_SPEED_PV;
	float FFU2_4_SPEED_PV;
	float FFU2_5_SPEED_PV;
	float FFU2_6_SPEED_PV;
	float FFU3_1_SPEED_PV;
	float FFU3_2_SPEED_PV;
	float FFU3_3_SPEED_PV;
	float FFU3_4_SPEED_PV;
	float FFU3_5_SPEED_PV;
	float FFU3_6_SPEED_PV;
	float CKD_APC_Value_Sensor_Input1;
	float CKD_APC_Value_Sensor_Input2;
	float CKD_APC_Position_Actual_Value;
	float CKD_APC_Control_Mode_Status;
	float CKD_APC_Homing_Status;
	float CKD_APC_Selected_Controller;
	float CKD_APC_Device_Management_Device_Warning_Details;
	float CKD_APC_Sensor_Input1_Device_Warning_Details;
	float CKD_APC_Sensor_Input2_Device_Warning_Details;
	float CKD_APC_Process_Controller_Selector_Device_Warning_Details;
	float CKD_APC_Valve_Device_Warning_Details;
	float CKD_APC_Valve_manufacturer_Warning_Details;
	float CKD_APC_Device_Management_manufacturer_Error_Details;
	float CKD_APC_Sensor_Input1_Management_manufacturer_Error_Details;
	float CKD_APC_Sensor_Input2_Management_manufacturer_Error_Details;
	float CKD_APC_Valve_Management_manufacturer_Error_Details;
	float CKD_APC_Zero_Reset_P1;
	float CKD_APC_Zero_adjust_P1;
	float CKD_APC_Span_adjust_P1;
	float CKD_APC_Zero_Reset_P2;
	float CKD_APC_Zero_adjust_P2;
	float CKD_APC_Span_adjust_P2;
	float CKD_APC_Slow_vacuum_control_target_vacuum_Pressure;
	float CKD_APC_Valve_status_threshold;
	float CKD_APC_Forbid_interlock_outbreak;
	float CKD_APC_Slow_vacuum_mode_setting;
	float CKD_APC_Interlock1;
	float CKD_APC_Interlock2;
	float CKD_APC_Interlock3;
	float CKD_APC_Interlock_constant_of_interlock3;
	float CKD_APC_P1_sensor_offset_setting;
	float CKD_APC_Pos_mon_offset_setting;
	float CKD_APC_Sensor_adjust_reset;
	float CKD_APC_Slow_vacuum_rate;
	float CKD_APC_Slow_vacuum_control_P;
	float CKD_APC_Slow_vacuum_control_I;
	float CKD_APC_Slow_vacuum_control_D;
	float CKD_APC_Slow_vacuum_control_a;
	float CKD_APC_controller_mode_select;
	float CKD_APC_Specify_target_vacuum_Pressure_control;
	float CKD_APC_Specify_target_opening_for_valve_opening_control;
	float CKD_APC_Specify_control_mode;
	float CKD_APC_Range_Upper_Limit_Sensor_Input1;
	float CKD_APC_Range_Upper_Limit_Sensor_Input2;
	float CKD_APC_P_constant_for_process_controller1;
	float CKD_APC_I_constant_for_process_controller1;
	float CKD_APC_D_constant_for_process_controller1;
	float CKD_APC_a_sensor_differential_controller1;
	float CKD_APC_CH_controller1;
	float CKD_APC_CL1_controller1;
	float CKD_APC_OFFSET_for_Pocess_Controller_1;
	float CKD_APC_P_constant_for_process_controller2;
	float CKD_APC_I_constant_for_process_controller2;
	float CKD_APC_D_constant_for_process_controller2;
	float CKD_APC_a_sensor_differential_controller2;
	float CKD_APC_CH_controller2;
	float CKD_APC_CL1_controller2;
	float CKD_APC_OFFSET_for_Pocess_Controller_2;
	float CKD_APC_P_constant_for_process_controller3;
	float CKD_APC_I_constant_for_process_controller3;
	float CKD_APC_D_constant_for_process_controller3;
	float CKD_APC_a_sensor_differential_controller3;
	float CKD_APC_CH_controller3;
	float CKD_APC_CL1_controller3;
	float CKD_APC_OFFSET_for_Pocess_Controller_3;
	float CKD_APC_P_constant_for_process_controller4;
	float CKD_APC_I_constant_for_process_controller4;
	float CKD_APC_D_constant_for_process_controller4;
	float CKD_APC_a_sensor_differential_controller4;
	float CKD_APC_CH_controller4;
	float CKD_APC_CL1_controller4;
	float CKD_APC_OFFSET_for_Pocess_Controller_4;
	float CKD_APC_P_constant_for_process_controller5;
	float CKD_APC_I_constant_for_process_controller5;
	float CKD_APC_D_constant_for_process_controller5;
	float CKD_APC_a_sensor_differential_controller5;
	float CKD_APC_CH_controller5;
	float CKD_APC_CL1_controller5;
	float CKD_APC_OFFSET_for_Pocess_Controller_5;
	float CKD_APC_P_constant_for_process_controller6;
	float CKD_APC_I_constant_for_process_controller6;
	float CKD_APC_D_constant_for_process_controller6;
	float CKD_APC_a_sensor_differential_controller6;
	float CKD_APC_CH_controller6;
	float CKD_APC_CL1_controller6;
	float CKD_APC_OFFSET_for_Pocess_Controller_6;
	float CKD_APC_P_constant_for_process_controller7;
	float CKD_APC_I_constant_for_process_controller7;
	float CKD_APC_D_constant_for_process_controller7;
	float CKD_APC_a_sensor_differential_controller7;
	float CKD_APC_CH_controller7;
	float CKD_APC_CL1_controller7;
	float CKD_APC_OFFSET_for_Pocess_Controller_7;
	float CKD_APC_P_constant_for_process_controller8;
	float CKD_APC_I_constant_for_process_controller8;
	float CKD_APC_D_constant_for_process_controller8;
	float CKD_APC_a_sensor_differential_controller8;
	float CKD_APC_CH_controller8;
	float CKD_APC_CL1_controller8;
	float CKD_APC_OFFSET_for_Pocess_Controller_8;
	float CKD_APC_P_constant_for_process_controller9;
	float CKD_APC_I_constant_for_process_controller9;
	float CKD_APC_D_constant_for_process_controller9;
	float CKD_APC_a_sensor_differential_controller9;
	float CKD_APC_CH_controller9;
	float CKD_APC_CL1_controller9;
	float CKD_APC_OFFSET_for_Pocess_Controller_9;
	float CKD_APC_P_constant_for_process_controller10;
	float CKD_APC_I_constant_for_process_controller10;
	float CKD_APC_D_constant_for_process_controller10;
	float CKD_APC_a_sensor_differential_controller10;
	float CKD_APC_CH_controller10;
	float CKD_APC_CL1_controller10;
	float CKD_APC_OFFSET_for_Pocess_Controller_10;
	float Actual_Pressure;
	float Pressure_Sensor_1;
	float Pressure_Sensor_2;
	float Actual_Position;
	float Control_Mode;
	float Error_Number;
	float General_Status;
	float General_Warnings;
	float Extended_Warnings;
	float BufferMotorPositionFb;
	float BufferMotorSpeedFb;
	float BufferMotorTorqueFb;
	float BufferTargetPosFb;
	float BufferDriverErrCode;
	float BufferMotionErrID;
	float BoatMotorPositionFeedback;
	float BoatMotorSpeedFb;
	float BoatTargetPosFb;
	float BoatDriverErrCode;
	float CapsSpeedFb;
	float FTRPickPlaceAcK;
	float WTRPickPlaceAcK;
} ModuleMoniterAI, *PModuleMoniterAI;

typedef struct _ModuleMoniterNDI
{
	bool UPS_Fault;
	bool UPS_Alarm;
	bool UPS_Bypass_Status;
	bool UPS_Battery_Voltage_Low;
	bool UPS_Start;
	bool UPS_AC_Input_Cut_Off;
	bool Powerbox_front_doorswitch_1;
	bool Powerbox_front_doorswitch_2;
	bool Powerbox_back_doorswitch_1;
	bool Powerbox_back_doorswitch_2;
	bool External_HPM_In;
	bool KM101_ON;
	bool KM201_ON;
	bool KM102_ON;
	bool KM103_ON;
	bool KM106_ON;
	bool Furnace_main_breaker_status_monitor;
	bool Blower_Breaker_status_feedback;
	bool Zone1_Circuit_Breaker_Status_Monitor;
	bool Zone2_Circuit_Breaker_Status_Monitor;
	bool Zone3_Circuit_Breaker_Status_Monitor;
	bool Zone4_Circuit_Breaker_Status_Monitor;
	bool Zone5_Circuit_Breaker_Status_Monitor;
	bool Zone6_Circuit_Breaker_Status_Monitor;
	bool Zone7_Circuit_Breaker_Status_Monitor;
	bool LDS1_Bulk_to_Process_Running;
	bool LDS1_Supply_Doing;
	bool LDS1_System_Ready;
	bool LDS1_Major_Alarm;
	bool LDS1_Minor_Alarm;
	bool LDS1_Low_Level_Alram;
	bool LDS1_Empty_Alarm;
	bool LDS2_Bulk_to_Process_Running;
	bool LDS2_Supply_Doing;
	bool LDS2_System_Ready;
	bool LDS2_Major_Alarm;
	bool LDS2_Minor_Alarm;
	bool LDS2_Low_Level_Alram;
	bool LDS2_Empty_Alarm;
	bool Vaccum1_Pump_Both_On;
	bool Vaccum1_Pump_Warning;
	bool Vaccum1_Pump_Alarm;
	bool N2_Purge_BOX_PG13_CNT1;
	bool N2_Purge_BOX_PG13_CNT2;
	bool N2_Purge_BOX_PG14_CNT1;
	bool N2_Purge_BOX_PG14_CNT2;
	bool N2_Purge_BOX_PG15_CNT1;
	bool N2_Purge_BOX_PG15_CNT2;
	bool N2_Purge_Box_PG16_CNT1;
	bool N2_Purge_Box_PG16_CNT2;
	bool N2_Purge_Box_PG130_CNT1;
	bool N2_Purge_Box_PG130_CNT2;
	bool PS17_Value_Out_Limit_Alarm1;
	bool PG3_LOW_ALARM;
	bool PG3_HIGH_ALARM;
	bool PG4_LOW_ALARM;
	bool PG4_HIGH_ALARM;
	bool PG5_LOW_ALARM;
	bool PG5_HIGH_ALARM;
	bool PG6_LOW_ALARM;
	bool PG6_HIGH_ALARM;
	bool PG7_LOW_ALARM;
	bool PG7_HIGH_ALARM;
	bool PG8_LOW_ALARM;
	bool PG8_HIGH_ALARM;
	bool PG31_LOW_ALARM;
	bool PG31_HIGH_ALARM;
	bool PG32_LOW_ALARM;
	bool PG32_HIGH_ALARM;
	bool LSC_H_LEVEL;
	bool LSC_M_LEVEL;
	bool LSC_L_LEVEL;
	bool VG31_STATUS_OK;
	bool VG31_LOW_ALARM;
	bool VG31_HIGH_ALARM;
	bool GD_FAN1_STOP;
	bool GD_FAN2_STOP;
	bool OX_MS1;
	bool OX_MS2;
	bool OX_MS3;
	bool OX_MSI1;
	bool OX_MSI2;
	bool OX_RC1;
	bool OX_RC2;
	bool OX_RC3;
	bool MS2_Pressure_LOW_ALARM;
	bool MS2_Pressure_HIGH_ALARM;
	bool MS321_Pressure_LOW_ALARM;
	bool MS321_Pressure_HIGH_ALARM;
	bool MP_PS20_Pressure_ALARM;
	bool MP_PS11_Pressure_ALARM;
	bool PG1_LOW_ALARM;
	bool PG1_HIGH_ALARM;
	bool PG2_LOW_ALARM;
	bool PG2_HIGH_ALARM;
	bool FS105_flow_alarm;
	bool FS106_flow_alarm;
	bool FS202_flow_alarm;
	bool FS104_flow_alarm;
	bool FS111_flow_alarm;
	bool FS102_flow_alarm;
	bool VG11_STATUS_OK;
	bool VG11_LOW_ALARM;
	bool VG11_HIGH_ALARM;
	bool VG13_STATUS_OK;
	bool VG13_LOW_ALARM;
	bool VG13_HIGH_ALARM;
	bool AV71_fan_1_alarm;
	bool AV71_fan_2_alarm;
	bool DG1_low_limit_alarm;
	bool DG1_high_limit_alarm;
	bool MP21_PS_Pressure_low_alarm;
	bool FS101_flow_alarm_1;
	bool FS101_flow_alarm_2;
	bool FL301_flow_switch;
	bool FS116_flow_alarm;
	bool PS110_Pressure_low_alarm;
	bool PS110_Pressure_high_alarm;
	bool PG_PS12_Pressure_low_alarm;
	bool PG_PS12_Pressure_high_alarm;
	bool PS13_ATM_status;
	bool PS13_high_limit_alarm;
	bool PG101_water_Pressure_low_alarm;
	bool PG101_water_Pressure_high_alarm;
	bool VG14_STATUS_OK;
	bool VG14_LOW_ALARM;
	bool VG14_HIGH_ALARM;
	bool PS14_Pressure_low_alarm;
	bool PS14_Pressure_high_alarm;
	bool APC_valve_status;
	bool APC_alarm_status;
	bool RHC_cooling_air_cylinder_1_open;
	bool RHC_cooling_air_cylinder_1_close;
	bool RHC_cooling_air_cylinder_2_open;
	bool RHC_cooling_air_cylinder_2_close;
	bool RHC_cooling_valve_open;
	bool RHC_cooling_valve_close;
	bool RHC_cooling_Butterfly_Valves_open;
	bool RHC_cooling_Butterfly_Valves_close;
	bool No1_Left_Extended_Detect1;
	bool No1_Left_Back_Detect1;
	bool No1_Left_Extended_Detect2;
	bool No1_Left_Back_Detect2;
	bool No1_Left_InPos_Detect1;
	bool No1_Left_InPos_Detect2;
	bool No1_Left_InPos_Detect3;
	bool No1_Left_Spare;
	bool No1_Right_Extended_Detect1;
	bool No1_Right_Back_Detect1;
	bool No1_Right_Extended_Detect2;
	bool No1_Right_Back_Detect2;
	bool No1_Right_InPos_Detect1;
	bool No1_Right_InPos_Detect2;
	bool No1_Right_InPos_Detect3;
	bool No1_Right_Spare;
	bool No2_Left_Back_Detect;
	bool No2_Left_Extended_Detect;
	bool No2_Left_Flow_Detect1;
	bool No2_Left_Flow_Detect2;
	bool No2_Left_InPos_Detect1;
	bool No2_Right_Back_Detect;
	bool No2_Right_Extended_Detect;
	bool No2_Right_Flow_Detect1;
	bool No2_Right_Flow_Detect2;
	bool No2_Right_InPos_Detect1;
	bool No3_Left_Back_Detect;
	bool No3_Left_Extended_Detect;
	bool No3_Left_Flow_Detect1;
	bool No3_Left_Flow_Detect2;
	bool No3_Left_InPos_Detect1;
	bool No3_Right_Back_Detect;
	bool No3_Right_Extended_Detect;
	bool No3_Right_Flow_Detect1;
	bool No3_Right_Flow_Detect2;
	bool No3_Right_InPos_Detect1;
	bool No4_Left_InPos_Detect1;
	bool No4_Left_InPos_Detect2;
	bool No4_Left_InPos_Detect3;
	bool No4_Left_Spare;
	bool No4_Left_Productor_Detect;
	bool No4_Right_InPos_Detect1;
	bool No4_Right_InPos_Detect2;
	bool No4_Right_InPos_Detect3;
	bool No4_Right_Spare;
	bool No4_Right_Productor_Detect;
	bool Door_Up_Detect;
	bool Door_Down_Detect;
	bool No1_Left_Productor_Detect;
	bool No1_Right_Productor_Detect;
	bool Robot_Loadport1_E84_Valid;
	bool Robot_Loadport1_E84_CS_1;
	bool Robot_Loadport1_E84_TR_REQ;
	bool Robot_Loadport1_E84_busy;
	bool Robot_Loadport1_E84_COMPT;
	bool Robot_Loadport1_E84_CONT;
	bool Robot_Loadport2_E84_Valid;
	bool Robot_Loadport2_E84_CS_0;
	bool Robot_Loadport2_E84_CS_1;
	bool Robot_Loadport2_E84_TR_REQ;
	bool Robot_Loadport2_E84_busy;
	bool Robot_Loadport2_E84_COMPT1;
	bool Robot_Loadport2_E84_COMPT2;
	bool Robot_Loadport2_E84_CONT;
	bool Robot_Spare1;
	bool Robot_Spare2;
	bool Robot_Spare3;
	bool Robot_Spare4;
	bool Robot_Spare5;
	bool Robot_Spare6;
	bool Robot_Spare7;
	bool Robot_Spare8;
	bool Robot_Spare9;
	bool Robot_Spare10;
	bool Robot_Spare11;
	bool Robot_Spare12;
	bool Robot_Spare13;
	bool Robot_Spare14;
	bool Robot_Spare15;
	bool Robot_Spare16;
	bool Robot_Spare17;
	bool Robot_Spare18;
	bool Stop_Button;
	bool Pause_Button;
	bool Plugging_Button;
	bool Left_Error_Rst;
	bool Right_Error_Rst;
	bool FIMS1_FOUP_dock;
	bool FIMS1_FOUP_undock;
	bool FIMS1_FOUP_exist;
	bool FIMS2_FOUP_dock;
	bool FIMS2_FOUP_undock;
	bool FIMS2_FOUP_exist;
	bool FIMS1_FOUP_wafer_shift_detection;
	bool FIMS2_FOUP_wafer_shift_detection;
	bool FIMS1_FOUP_negative_Pressure;
	bool FIMS1_FOUP_ordinary_Pressure;
	bool FIMS2_FOUP_negative_Pressure;
	bool FIMS2_FOUP_ordinary_Pressure;
	bool BOAT_slow_down_position_detection;
	bool buffer_rotation_conv_detect_sensor;
	bool LA_internal_cycle_switch_1_open;
	bool LA_internal_cycle_switch_1_close;
	bool LA_internal_cycle_switch_2_open;
	bool LA_internal_cycle_switch_2_close;
	bool R_axis_air_cylinder_extend_position;
	bool R_axis_air_cylinder_retract_position;
	bool Furnace_shutter_open;
	bool Furnace_shutter_close;
	bool FIMS1_exhaust_open_position;
	bool FIMS1_exhaust_close_position;
	bool FIMS2_exhaust_open_position;
	bool FIMS2_exhaust_close_position;
	bool FIMS1_seal;
	bool FIMS1_release;
	bool FIMS1_door_close;
	bool FIMS1_door_open;
	bool FIMS1_FOUP_latch_off;
	bool FIMS1_FOUP_latch_on;
	bool FIMS1_collision_avoidance_up;
	bool FIMS1_collision_avoidance_down;
	bool FIMS2_seal;
	bool FIMS2_release;
	bool FIMS2_door_close;
	bool FIMS2_door_open;
	bool FIMS2_FOUP_latch_off;
	bool FIMS2_FOUP_latch_on;
	bool FIMS2_collision_avoidance_up;
	bool FIMS2_collision_avoidance_down;
	bool Buffer_A1_N2_Pressure_alarm;
	bool Buffer_A1_FOUP_detect;
	bool Buffer_B1_N2_Pressure_alarm;
	bool Buffer_B1_FOUP_detect;
	bool Buffer_C1_N2_Pressure_alarm;
	bool Buffer_C1_FOUP_detect;
	bool Buffer_D1_N2_Pressure_alarm;
	bool Buffer_D1_FOUP_detect;
	bool Buffer_A2_N2_Pressure_alarm;
	bool Buffer_A2_FOUP_detect;
	bool Buffer_B2_N2_Pressure_alarm;
	bool Buffer_B2_FOUP_detect;
	bool Buffer_C2_N2_Pressure_alarm;
	bool Buffer_C2_FOUP_detect;
	bool Buffer_D2_N2_Pressure_alarm;
	bool Buffer_D2_FOUP_detect;
	bool Buffer_A3_N2_Pressure_alarm;
	bool Buffer_A3_FOUP_detect;
	bool Buffer_B3_N2_Pressure_alarm;
	bool Buffer_B3_FOUP_detect;
	bool Buffer_C3_N2_Pressure_alarm;
	bool Buffer_C3_FOUP_detect;
	bool Buffer_D3_N2_Pressure_alarm;
	bool Buffer_D3_FOUP_detect;
	bool Buffer_A4_N2_Pressure_alarm;
	bool Buffer_A4_FOUP_detect;
	bool Buffer_B4_N2_Pressure_alarm;
	bool Buffer_B4_FOUP_detect;
	bool Buffer_C4_N2_Pressure_alarm;
	bool Buffer_C4_FOUP_detect;
	bool Buffer_D4_N2_Pressure_alarm;
	bool Buffer_D4_FOUP_detect;
	bool FTRTPStatus;
	bool WaferRobotTPstatus;
	bool WaferRobotPowerStatus;
	bool WaferRobotAlarm;
	bool WaferRobotWafer_1Checked;
	bool WaferRobotWafer_2Checked;
	bool WaferRobotWafer_3Checked;
	bool WaferRobotWafer_4Checked;
	bool WaferRobotWafer_5Checked;
	bool WaferRobotAxis_Zhome;
	bool WaferRobotAxis_THhome;
	bool WaferRobotAxis_EX1home;
	bool WaferRobotAxis_EX2home;
	bool WaferRobotAxis_Phome;
	bool WaferRobotRunning;
	bool MS8_RHC_ExhPress_LOW_ALARM;
	bool MS8_RHC_ExhPress_HIGH_ALARM;
	bool MS1_Heater_ExhPress_LOW_ALARM;
	bool MS1_Heater_ExhPress_HIGH_ALARM;
	bool MS3_Scavenger_ExhPress_LOW_ALARM;
	bool MS3_Scavenger_ExhPress_HIGH_ALARM;
	bool MS6_Frontbody_ExhPress_LOW_ALARM;
	bool MS6_Frontbody_ExhPress_HIGH_ALARM;
	bool MS9_LSC1_ExhPress_LOW_ALARM;
	bool MS9_LSC1_ExhPress_HIGH_ALARM;
	bool MS11_GasBox_ExhPress_LOW_ALARM;
	bool MS11_GasBox_ExhPress_HIGH_ALARM;
	bool MS12_GasBox_ExhPress_LOW_ALARM;
	bool MS12_GasBox_ExhPress_HIGH_ALARM;
	bool SysData_PLCReset_b;
	bool SysData_BlowerSwitch_b;
	bool SysData_LightCurtainBypass_b;
	bool SysData_FFUAlarmReset_b;
	bool SysData_MINI8AlarmReset_b;
	bool SysData_VGUnitConversion_b;
	bool SysData_F2_CleanSwitch_b;
	bool SysData_APC_DATA_READ_SYSCONFIG;
	bool SysData_APC_DATA_WRITE_SYSCONFIG;
	bool SysData_APC_DATA_READ_CUSCONFIG;
	bool SysData_APC_DATA_WRITE_CUSCONFIG;
	bool SysData_HTR1_Temp_alarm;
	bool SysData_HTR2_Temp_alarm;
	bool SysData_Abnormal_seal_cap_HTR_temp;
	bool SysData_Abnormal_furnace_heater_temp;
	bool SysData_HTR3_Temp_alarm;
	bool SysData_HTR1_ON;
	bool SysData_HTR2_ON;
	bool SysData_HTR3_ON;
	bool SysData_HTR1_SW_ON;
	bool SysData_HTR2_SW_ON;
	bool SysData_HTR3_SW_ON;
	bool SysData_HF_CleanSwitch;
	bool SysData_DEPO_SW;
	bool ILK_LA_O2_Check_First_EN;
	bool SysData_FIMS1_O2_Check_EN;
	bool SysData_FIMS2_O2_Check_EN;
	bool SysData_N2_PURGE_PROCESS;
	bool ILK_LA_O2_Check_OT;
	bool ILK_FIMS1_O2_Check_OT;
	bool ILK_FIMS2_O2_Check_OT;
	bool FIMS1_Load_Complete;
	bool FIMS1_Unload_Complete;
	bool FIMS1_Home_Complete;
	bool FIMS1_Running;
	bool FIMS1_LoadAlarm;
	bool FIMS1_UnloadAlarm;
	bool FIMS1_AutoManualMode;
	bool FIMS2_Load_Complete;
	bool FIMS2_Unload_Complete;
	bool FIMS2_Home_Complete;
	bool FIMS2_Running;
	bool FIMS2_LoadAlarm;
	bool FIMS2_UnloadAlarm;
	bool FIMS2_AutoManualMode;
	bool O2_Detect_Side_LA;
	bool O2_Detect_Side_FIMS1;
	bool O2_Detect_Side_FIMS2;
	bool Mini8_OffLine;
	bool MvAbsBusyBufferAxis;
	bool BufferFaultBufferAxis;
	bool BufferInPositionA1;
	bool BufferInPositionB1;
	bool BufferInPositionC1;
	bool BufferInPositionD1;
	bool BufferInPositionA2;
	bool BufferInPositionB2;
	bool BufferInPositionC2;
	bool BufferInPositionD2;
	bool BufferInPositionA3;
	bool BufferInPositionB3;
	bool BufferInPositionC3;
	bool BufferInPositionD3;
	bool BufferInPositionA4;
	bool BufferInPositionB4;
	bool BufferInPositionC4;
	bool BufferInPositionD4;
	bool ServoOnBufferAxis;
	bool PwrErrBufferAxis;
	bool PwrBusyBoatZAxis;
	bool MvAbsBusyBoatZAxis;
	bool HmPosBoatZAxis;
	bool NegLmtPosBoatZAxis;
	bool PotLmtPosBoatZAxis;
	bool ReadytoSwitchOnBoatZAxis;
	bool SwitchedOnBoatZAxis;
	bool BoatFaultBoatZAxis;
	bool MiddlePos1BoatZAxis;
	bool MiddlePos2BoatZAxis;
	bool MiddlePos3BoatZAxis;
	bool BoatLiftMotorUpPosition;
	bool BoatLiftMotorDownPosition;
	bool BoatRAxisMoving;
	bool BoatRAxisHomeBusy;
	bool BoatRAxisHomeDone;
	bool BoatRAxisRotationBusy;
	bool BoatRAxisInHomePosition;
	bool BoatRAxisAlarm;
	bool bHeartBeatPMC_PLC_Monitor;
	bool bHeartBeatPMC_IPC_Monitor;
	bool DP;
	bool BWR;
	bool DPR1;
	bool DPR2;
	bool WAT_R;
	bool WAT_F;
	bool HTR1;
	bool HTR2;
	bool HTR3;
	bool HTR4;
	bool HTR5;
	bool T_MNT;
	bool T_REF;
	bool DEPO;
	bool CLN;
	bool ECO;
	bool AGV;
	bool SP1;
	bool PZ;
	bool P_CONT;
	bool DGZERO;
	bool C_EXH;
	bool F2_CLN;
	bool F_N;
	bool P_RUN;
	bool LSC1_Level_HH;
	bool LSC1_Level_H;
	bool LSC1_Level_M;
	bool LSC1_Level_L;
	bool LSC1_OverFill;
	bool LSC1_Ref_RDY;
	bool T_REF_On;
	bool D_Gas_OK;
	bool DEPO_OK;
	bool CLN_OK;
	bool ATM;
	bool F2_CLN_OK;
	bool VAC1;
	bool VAC2;
	bool VAC3;
	bool VAC4;
	bool VAC5;
	bool VAC6;
	bool VAC7;
	bool VAC8;
	bool VAC9;
	bool VAC10;
	bool bBoatUnLoad_ILK;
	bool AV1_ILK;
	bool AV2_ILK;
	bool AV3_ILK;
	bool AV4_ILK;
	bool AV5_ILK;
	bool AV6_ILK;
	bool AV7_ILK;
	bool AV8_ILK;
	bool AV9_ILK;
	bool AV10_ILK;
	bool AV11_ILK;
	bool AV12_ILK;
	bool AV13_ILK;
	bool AV14_ILK;
	bool AV15_ILK;
	bool AV16_ILK;
	bool AV17_ILK;
	bool AV18_ILK;
	bool AV19_ILK;
	bool AV20_ILK;
	bool AV21_ILK;
	bool AV22_ILK;
	bool AV23_ILK;
	bool AV24_ILK;
	bool AV25_ILK;
	bool AV26_ILK;
	bool AV27_ILK;
	bool AV28_ILK;
	bool AV29_ILK;
	bool AV30_ILK;
	bool AV31_ILK;
	bool AV32_ILK;
	bool AV33_ILK;
	bool AV34_ILK;
	bool AV35_ILK;
	bool AV36_ILK;
	bool AV37_ILK;
	bool AV38_ILK;
	bool AV39_ILK;
	bool AV40_ILK;
	bool AV41_ILK;
	bool AV42_ILK;
	bool AV43_ILK;
	bool AV44_ILK;
	bool AV45_ILK;
	bool AV46_ILK;
	bool AV47_ILK;
	bool AV48_ILK;
	bool AV49_ILK;
	bool AV50_ILK;
	bool AV51_ILK;
	bool AV52_ILK;
	bool AV53_ILK;
	bool AV54_ILK;
	bool AV55_ILK;
	bool AV56_ILK;
	bool AV57_ILK;
	bool AV58_ILK;
	bool AV59_ILK;
	bool AV60_ILK;
	bool AV61_ILK;
	bool AV62_ILK;
	bool AV63_ILK;
	bool AV64_ILK;
	bool AV65_ILK;
	bool AV66_ILK;
	bool AV67_ILK;
	bool AV68_ILK;
	bool AV69_ILK;
	bool AV70_ILK;
	bool AV71_ILK;
	bool AV72_ILK;
	bool AV73_ILK;
	bool AV74_ILK;
	bool AV75_ILK;
	bool AV76_ILK;
	bool AV77_ILK;
	bool AV78_ILK;
	bool AV79_ILK;
	bool AV80_ILK;
	bool AV81_ILK;
	bool AV82_ILK;
	bool AV83_ILK;
	bool AV84_ILK;
	bool AV85_ILK;
	bool AV86_ILK;
	bool AV87_ILK;
	bool AV88_ILK;
	bool AV89_ILK;
	bool AV90_ILK;
	bool AV91_ILK;
	bool AV92_ILK;
	bool AV93_ILK;
	bool AV94_ILK;
	bool AV95_ILK;
	bool AV96_ILK;
	bool AV97_ILK;
	bool AV98_ILK;
	bool AV99_ILK;
	bool AV100_ILK;
	bool AV101_ILK;
	bool AV102_ILK;
	bool AV103_ILK;
	bool AV104_ILK;
	bool AV105_ILK;
	bool AV106_ILK;
	bool AV107_ILK;
	bool AV108_ILK;
	bool AV109_ILK;
	bool AV110_ILK;
	bool AV111_ILK;
	bool AV112_ILK;
	bool AV113_ILK;
	bool AV114_ILK;
	bool AV115_ILK;
	bool AV116_ILK;
	bool AV117_ILK;
	bool AV118_ILK;
	bool AV119_ILK;
	bool AV120_ILK;
	bool AV121_ILK;
	bool AV122_ILK;
	bool AV123_ILK;
	bool AV124_ILK;
	bool AV125_ILK;
	bool AV126_ILK;
	bool AV127_ILK;
	bool AV128_ILK;
	bool AV129_ILK;
	bool AV130_ILK;
	bool AV131_ILK;
	bool AV132_ILK;
	bool AV133_ILK;
	bool AV134_ILK;
	bool AV135_ILK;
	bool AV136_ILK;
	bool AV137_ILK;
	bool AV138_ILK;
	bool AV139_ILK;
	bool AV140_ILK;
	bool AV141_ILK;
	bool AV142_ILK;
	bool AV143_ILK;
	bool AV144_ILK;
	bool AV145_ILK;
	bool AV146_ILK;
	bool AV147_ILK;
	bool AV148_ILK;
	bool AV149_ILK;
	bool AV150_ILK;
	bool AV151_ILK;
	bool AV152_ILK;
	bool AV153_ILK;
	bool AV154_ILK;
	bool AV155_ILK;
	bool AV156_ILK;
	bool AV157_ILK;
	bool AV158_ILK;
	bool AV159_ILK;
	bool AV160_ILK;
	bool AV161_ILK;
	bool AV162_ILK;
	bool AV163_ILK;
	bool AV164_ILK;
	bool AV165_ILK;
	bool AV166_ILK;
	bool AV167_ILK;
	bool AV168_ILK;
	bool AV169_ILK;
	bool AV170_ILK;
	bool AV171_ILK;
	bool AV172_ILK;
	bool AV173_ILK;
	bool AV174_ILK;
	bool AV175_ILK;
	bool AV176_ILK;
	bool AV177_ILK;
	bool AV178_ILK;
	bool AV179_ILK;
	bool AV180_ILK;
	bool AV181_ILK;
	bool AV182_ILK;
	bool AV183_ILK;
	bool AV184_ILK;
	bool AV185_ILK;
	bool AV186_ILK;
	bool AV187_ILK;
	bool AV188_ILK;
	bool AV189_ILK;
	bool AV190_ILK;
	bool AV191_ILK;
	bool AV192_ILK;
	bool AV193_ILK;
	bool AV194_ILK;
	bool AV195_ILK;
	bool AV196_ILK;
	bool AV197_ILK;
	bool AV198_ILK;
	bool AV199_ILK;
	bool AV200_ILK;
	bool AV201_ILK;
	bool AV202_ILK;
	bool AV203_ILK;
	bool AV204_ILK;
	bool AV205_ILK;
	bool AV206_ILK;
	bool AV207_ILK;
	bool AV208_ILK;
	bool AV209_ILK;
	bool AV210_ILK;
	bool AV211_ILK;
	bool AV212_ILK;
	bool AV213_ILK;
	bool AV214_ILK;
	bool AV215_ILK;
	bool AV216_ILK;
	bool AV217_ILK;
	bool AV218_ILK;
	bool AV219_ILK;
	bool AV220_ILK;
	bool AV221_ILK;
	bool AV222_ILK;
	bool AV223_ILK;
	bool AV224_ILK;
	bool AV225_ILK;
	bool AV226_ILK;
	bool AV227_ILK;
	bool AV228_ILK;
	bool AV229_ILK;
	bool AV230_ILK;
	bool AV231_ILK;
	bool AV232_ILK;
	bool AV233_ILK;
	bool AV234_ILK;
	bool AV235_ILK;
	bool AV236_ILK;
	bool AV237_ILK;
	bool AV238_ILK;
	bool AV239_ILK;
	bool AV240_ILK;
	bool AV241_ILK;
	bool AV242_ILK;
	bool AV243_ILK;
	bool AV244_ILK;
	bool AV245_ILK;
	bool AV246_ILK;
	bool AV247_ILK;
	bool AV248_ILK;
	bool AV249_ILK;
	bool AV250_ILK;
	bool AV540_ILK;
	bool Interlock1;
	bool Interlock2;
	bool Interlock3;
	bool Interlock4;
	bool Interlock5;
	bool Interlock6;
	bool Interlock7;
	bool Interlock8;
	bool Interlock9;
	bool Interlock10;
	bool Interlock11;
	bool Interlock12;
	bool Interlock13;
	bool Interlock14;
	bool Interlock15;
	bool Interlock16;
	bool Interlock17;
	bool Interlock18;
	bool Interlock19;
	bool Interlock20;
	bool Interlock21;
	bool Interlock22;
	bool Interlock23;
	bool Interlock24;
	bool Interlock25;
	bool Interlock26;
	bool Interlock27;
	bool Interlock28;
	bool Interlock29;
	bool Interlock30;
	bool Interlock31;
	bool Interlock32;
	bool Interlock33;
	bool Interlock34;
	bool Interlock35;
	bool Interlock36;
	bool Interlock37;
	bool Interlock38;
	bool Interlock39;
	bool Interlock40;
	bool Interlock41;
	bool Interlock42;
	bool Interlock43;
	bool Interlock44;
	bool Interlock45;
	bool Interlock46;
	bool Interlock47;
	bool Interlock48;
	bool Interlock49;
	bool Interlock50;
	bool Interlock51;
	bool Interlock52;
	bool Interlock53;
	bool Interlock54;
	bool Interlock55;
	bool Interlock56;
	bool Interlock57;
	bool Interlock58;
	bool Interlock59;
	bool Interlock60;
	bool Interlock61;
	bool Interlock62;
	bool Interlock63;
	bool Interlock64;
	bool Interlock65;
	bool Interlock66;
	bool Interlock67;
	bool Interlock68;
	bool Interlock69;
	bool Interlock70;
	bool Interlock71;
	bool Interlock72;
	bool Interlock73;
	bool Interlock74;
	bool Interlock75;
	bool Interlock76;
	bool Interlock77;
	bool Interlock78;
	bool Interlock79;
	bool Interlock80;
	bool Interlock81;
	bool Interlock82;
	bool Interlock83;
	bool Interlock84;
	bool Interlock85;
	bool Interlock86;
	bool Interlock87;
	bool Interlock88;
	bool Interlock89;
	bool Interlock90;
	bool Interlock91;
	bool Interlock92;
	bool Interlock93;
	bool Interlock94;
	bool Interlock95;
	bool Interlock96;
	bool Interlock97;
	bool Interlock98;
	bool Interlock99;
	bool Interlock100;
	bool Interlock101;
	bool Interlock102;
	bool Interlock103;
	bool Interlock104;
	bool Interlock105;
	bool Interlock106;
	bool Interlock107;
	bool Interlock108;
	bool Interlock109;
	bool Interlock110;
	bool Interlock111;
	bool Interlock112;
	bool Interlock113;
	bool Interlock114;
	bool Interlock115;
	bool Interlock116;
	bool Interlock117;
	bool Interlock118;
	bool Interlock119;
	bool Interlock120;
	bool Interlock121;
	bool Interlock122;
	bool Interlock123;
	bool Interlock124;
	bool Interlock125;
	bool Interlock126;
	bool Interlock127;
	bool Interlock128;
	bool Interlock129;
	bool Interlock130;
	bool Interlock131;
	bool Interlock132;
	bool Interlock133;
	bool Interlock134;
	bool Interlock135;
	bool Interlock136;
	bool Interlock137;
	bool Interlock138;
	bool Interlock139;
	bool Interlock140;
	bool Interlock141;
	bool Interlock142;
	bool Interlock143;
	bool Interlock144;
	bool Interlock145;
	bool Interlock146;
	bool Interlock147;
	bool Interlock148;
	bool Interlock149;
	bool Interlock150;
} ModuleMoniterNDI, *PModuleMoniterNDI;

#pragma pack(push,1)
typedef struct _ModuleMoniterSDI
{
	ULONG Value;
	ULONG Status;
	ULONG Data;
	bool SPLC_Com_Error;
	bool SPLC_Other_Error;
	bool O2_analyzer_over_range_alarm;
	bool SCR_ONOFF_SWITCH;
	bool O2_analyzer_fault;
	bool SMK1_detector_operator;
	bool SMK1_detector_fault;
	bool SMK1_detector_fire_alarm;
	bool GD201_NF3_gas_leak_1st_alarm;
	bool GD201_NF3_gas_leak_2nd_alarm;
	bool GD202_SiH4_gas_leak_1st_alarm;
	bool GD201_fault;
	bool GD202_SiH4_gas_leak_2nd_alarm;
	bool GD202_fault;
	bool GD203_NH3_gas_leak_2nd_alarm;
	bool GD203_NH3_gas_leak_1st_alarm;
	bool GD203_fault;
	bool GD204_HCL_gas_leak_1st_alarm;
	bool GD204_fault;
	bool GD204_HCL_gas_leak_2nd_alarm;
	bool GD205_F2_gas_leak_1st_alarm;
	bool GD205_F2_gas_leak_2nd_alarm;
	bool GD206_NF3_gas_leak_1st_alarm;
	bool GD205_fault;
	bool GD206_NF3_gas_leak_2nd_alarm;
	bool GD206_fault;
	bool GD207_SiH4_gas_leak_2nd_alarm;
	bool GD207_SiH4_gas_leak_1st_alarm;
	bool GD207_fault;
	bool GD208_NH3_gas_leak_1st_alarm;
	bool GD208_fault;
	bool GD208_NH3_gas_leak_2nd_alarm;
	bool GD209_HCL_gas_leak_1st_alarm;
	bool GD209_HCL_gas_leak_2nd_alarm;
	bool GD210_F2_gas_leak_1st_alarm;
	bool GD209_fault;
	bool GD210_F2_gas_leak_2nd_alarm;
	bool GD210_fault;
	bool TS31_Cap_outside_temp_sw;
	bool TS30_Cap_inside_temp_sw;
	bool TS34_R_axis_rotation_temp_sw;
	bool Loading_area_EMS;
	bool SL201_gas_box_door_sw1_1;
	bool FFU_temp_sw;
	bool SL201_gas_box_door_sw1_2;
	bool SL202_gas_box_door_sw2_1;
	bool SL203_gas_box_door_sw3_1;
	bool SL202_gas_box_door_sw2_2;
	bool SL203_gas_box_door_sw3_2;
	bool SL204_gas_box_door_sw4_1;
	bool SL205_gas_box_door_sw5_1;
	bool SL204_gas_box_door_sw4_2;
	bool SL205_gas_box_door_sw5_2;
	bool SL501_LA_door_sw1;
	bool SL503_LA_door_sw3;
	bool SL502_LA_door_sw2;
	bool SL504_furnace_door_sw;
	bool MS2_S_gas_box_exhaust_alarm;
	bool MS11_S_gas_box_exhaust_alarm;
	bool MS12_S_gas_box_exhaust_alarm;
	bool LSC_1_leak_alarm;
	bool LD501_Magnetic_fluid_leak;
	bool LD502_Cooling_water_leak;
	bool TS305_RHC_temp_sw;
	bool LD503_RHC_leak;
	bool TS306_Main_furnace_Temp_sw;
	bool LD301_water_leak_alarm;
	bool EMO301_Exhaust_box_EMO;
	bool LD302_water_leak_alarm;
	bool FS101_water_flow_alarm1;
	bool Buffer_motor_EDM;
	bool R_axis_motor_EDM;
	bool E_axis_motor_EDM;
	bool EMO101_power_box_EMO;
	bool Furnace_transformer_temp_sw;
	bool Power_box_fire_detector_alarm;
	bool AC100V_transformer_temp_sw;
	bool Furnace_power_on_switch;
	bool Power_box_reset_button;
	bool AC100V_transformer_power_on_switch;
	bool VFD_EDM;
	bool Light_curtain_fault;
	bool Light_curtain_OSSD2;
	bool Light_curtain_OSSD1;
	bool Gas_box_reset_button;
	bool EMO401_frontbody_EMO;
	bool Frontbody_IO_shutter;
	bool Frontbody_door_sw;
	bool Frontbody_reset_button;
} ModuleMoniterSDI, *PModuleMoniterSDI;
#pragma pack(pop)

typedef struct _ModuleMoniterAO
{
	float MFC1_SV;
	float MFC1_Rate;
	float MFC2_SV;
	float MFC2_Rate;
	float MFC3_SV;
	float MFC3_Rate;
	float MFC4_SV;
	float MFC4_Rate;
	float MFC5_SV;
	float MFC5_Rate;
	float MFC6_SV;
	float MFC6_Rate;
	float MFC7_SV;
	float MFC7_Rate;
	float MFC8_SV;
	float MFC8_Rate;
	float MFC9_SV;
	float MFC9_Rate;
	float MFC10_SV;
	float MFC10_Rate;
	float MFC11_SV;
	float MFC11_Rate;
	float MFC12_SV;
	float MFC12_Rate;
	float MFC13_SV;
	float MFC13_Rate;
	float MFC14_SV;
	float MFC14_Rate;
	float MFC15_SV;
	float MFC15_Rate;
	float MFC16_SV;
	float MFC16_Rate;
	float MFC17_SV;
	float MFC17_Rate;
	float MFC51_SV;
	float MFC51_Rate;
	float FURNACE_Tube_Film_Thickness;
	float RecipeNo;
	float FURNACE_WR_EN;
	float FURNACE_JETCMode;
	float U_SP;
	float U_Offset;
	float U_Forced_MV;
	float U_Control_Mode;
	float U_Enable_Out;
	float CU_SP;
	float CU_Offset;
	float CU_Forced_MV;
	float CU_Control_Mode;
	float CU_Enable_Out;
	float C_SP;
	float C_Offset;
	float C_Forced_MV;
	float C_Control_Mode;
	float C_Enable_Out;
	float CL_SP;
	float CL_Offset;
	float CL_Forced_MV;
	float CL_Control_Mode;
	float CL_Enable_Out;
	float L_SP;
	float L_Offset;
	float L_Forced_MV;
	float L_Control_Mode;
	float L_Enable_Out;
	float SL_SP;
	float SL_Offset;
	float SL_Forced_MV;
	float SL_Control_Mode;
	float SL_Enable_Out;
	float SUB_SP;
	float SUB_Offset;
	float SUB_Forced_MV;
	float SUB_Control_Mode;
	float SUB_Enable_Out;
	float U_Open_Offset;
	float CU_Open_Offset;
	float C_Open_Offset;
	float CL_Open_Offset;
	float L_Open_Offset;
	float SL_Open_Offset;
	float SUB_Up_Rate;
	float SUB_Down_Rate;
	float SUB_PID_P;
	float SUB_PID_I;
	float SUB_PID_D;
	float U_Cascade_Mode_Selection;
	float U_Up_Rate;
	float U_Down_Rate;
	float U_Secondary_SP;
	float U_Main_TC_Select;
	float U_Primary_PID_P;
	float U_Primary_PID_I;
	float U_Primary_PID_D;
	float U_PID_P;
	float U_PID_I;
	float U_PID_D;
	float CU_Cascade_Mode_Selection;
	float CU_Up_Rate;
	float CU_Down_Rate;
	float CU_Secondary_SP;
	float CU_Main_TC_Select;
	float CU_Primary_PID_P;
	float CU_Primary_PID_I;
	float CU_Primary_PID_D;
	float CU_PID_P;
	float CU_PID_I;
	float CU_PID_D;
	float C_Cascade_Mode_Selection;
	float C_Up_Rate;
	float C_Down_Rate;
	float C_Secondary_SP;
	float C_Main_TC_Select;
	float C_Primary_PID_P;
	float C_Primary_PID_I;
	float C_Primary_PID_D;
	float C_PID_P;
	float C_PID_I;
	float C_PID_D;
	float CL_Cascade_Mode_Selection;
	float CL_Up_Rate;
	float CL_Down_Rate;
	float CL_Secondary_SP;
	float CL_Main_TC_Select;
	float CL_Primary_PID_P;
	float CL_Primary_PID_I;
	float CL_Primary_PID_D;
	float CL_PID_P;
	float CL_PID_I;
	float CL_PID_D;
	float L_Cascade_Mode_Selection;
	float L_Up_Rate;
	float L_Down_Rate;
	float L_Secondary_SP;
	float L_Main_TC_Select;
	float L_Primary_PID_P;
	float L_Primary_PID_I;
	float L_Primary_PID_D;
	float L_PID_P;
	float L_PID_I;
	float L_PID_D;
	float SL_Cascade_Mode_Selection;
	float SL_Up_Rate;
	float SL_Down_Rate;
	float SL_Secondary_SP;
	float SL_Main_TC_Select;
	float SL_Primary_PID_P;
	float SL_Primary_PID_I;
	float SL_Primary_PID_D;
	float SL_PID_P;
	float SL_PID_I;
	float SL_PID_D;
	float Instrument_ForceStandby;
	float HEATER1_SP;
	float HEATER1_Clear_Alarms;
	float HEATER1_Forced_MV;
	float HEATER1_Auto_Manual;
	float HEATER1_Inhibit;
	float HEATER1_SBrkAlarm_EN;
	float HEATER1_Temp_Hi_Alarm_Inhibit;
	float HEATER1_RateUp;
	float HEATER1_RateDown;
	float HEATER1_AutotuneActivate;
	float HEATER1_PID_P;
	float HEATER1_PID_I;
	float HEATER1_PID_D;
	float HEATER1_WR_EN;
	float HEATER2_SP;
	float HEATER2_Clear_Alarms;
	float HEATER2_Forced_MV;
	float HEATER2_Auto_Manual;
	float HEATER2_Inhibit;
	float HEATER2_SBrkAlarm_EN;
	float HEATER2_Temp_Hi_Alarm_Inhibit;
	float HEATER2_RateUp;
	float HEATER2_RateDown;
	float HEATER2_AutotuneActivate;
	float HEATER2_PID_P;
	float HEATER2_PID_I;
	float HEATER2_PID_D;
	float HEATER2_WR_EN;
	float HEATER3_SP;
	float HEATER3_Clear_Alarms;
	float HEATER3_Forced_MV;
	float HEATER3_Auto_Manual;
	float HEATER3_Inhibit;
	float HEATER3_SBrkAlarm_EN;
	float HEATER3_Temp_Hi_Alarm_Inhibit;
	float HEATER3_RateUp;
	float HEATER3_RateDown;
	float HEATER3_AutotuneActivate;
	float HEATER3_PID_P;
	float HEATER3_PID_I;
	float HEATER3_PID_D;
	float HEATER3_WR_EN;
	float HEATER4_SP;
	float HEATER4_Clear_Alarms;
	float HEATER4_Forced_MV;
	float HEATER4_Auto_Manual;
	float HEATER4_Inhibit;
	float HEATER4_SBrkAlarm_EN;
	float HEATER4_Temp_Hi_Alarm_Inhibit;
	float HEATER4_RateUp;
	float HEATER4_RateDown;
	float HEATER4_AutotuneActivate;
	float HEATER4_PID_P;
	float HEATER4_PID_I;
	float HEATER4_PID_D;
	float HEATER4_WR_EN;
	float HEATER5_SP;
	float HEATER5_Clear_Alarms;
	float HEATER5_Forced_MV;
	float HEATER5_Auto_Manual;
	float HEATER5_Inhibit;
	float HEATER5_SBrkAlarm_EN;
	float HEATER5_Temp_Hi_Alarm_Inhibit;
	float HEATER5_RateUp;
	float HEATER5_RateDown;
	float HEATER5_AutotuneActivate;
	float HEATER5_PID_P;
	float HEATER5_PID_I;
	float HEATER5_PID_D;
	float HEATER5_WR_EN;
	float HEATER6_SP;
	float HEATER6_Clear_Alarms;
	float HEATER6_Forced_MV;
	float HEATER6_Auto_Manual;
	float HEATER6_Inhibit;
	float HEATER6_SBrkAlarm_EN;
	float HEATER6_Temp_Hi_Alarm_Inhibit;
	float HEATER6_RateUp;
	float HEATER6_RateDown;
	float HEATER6_AutotuneActivate;
	float HEATER6_PID_P;
	float HEATER6_PID_I;
	float HEATER6_PID_D;
	float HEATER6_WR_EN;
	float HEATER7_SP;
	float HEATER7_Clear_Alarms;
	float HEATER7_Forced_MV;
	float HEATER7_Auto_Manual;
	float HEATER7_Inhibit;
	float HEATER7_SBrkAlarm_EN;
	float HEATER7_Temp_Hi_Alarm_Inhibit;
	float HEATER7_RateUp;
	float HEATER7_RateDown;
	float HEATER7_AutotuneActivate;
	float HEATER7_PID_P;
	float HEATER7_PID_I;
	float HEATER7_PID_D;
	float HEATER7_WR_EN;
	float HEATER8_SP;
	float HEATER8_Clear_Alarms;
	float HEATER8_Forced_MV;
	float HEATER8_Auto_Manual;
	float HEATER8_Inhibit;
	float HEATER8_SBrkAlarm_EN;
	float HEATER8_Temp_Hi_Alarm_Inhibit;
	float HEATER8_RateUp;
	float HEATER8_RateDown;
	float HEATER8_AutotuneActivate;
	float HEATER8_PID_P;
	float HEATER8_PID_I;
	float HEATER8_PID_D;
	float HEATER8_WR_EN;
	float HEATER9_SP;
	float HEATER9_Clear_Alarms;
	float HEATER9_Forced_MV;
	float HEATER9_Auto_Manual;
	float HEATER9_Inhibit;
	float HEATER9_SBrkAlarm_EN;
	float HEATER9_Temp_Hi_Alarm_Inhibit;
	float HEATER9_RateUp;
	float HEATER9_RateDown;
	float HEATER9_AutotuneActivate;
	float HEATER9_PID_P;
	float HEATER9_PID_I;
	float HEATER9_PID_D;
	float HEATER9_WR_EN;
	float HEATER10_SP;
	float HEATER10_Clear_Alarms;
	float HEATER10_Forced_MV;
	float HEATER10_Auto_Manual;
	float HEATER10_Inhibit;
	float HEATER10_SBrkAlarm_EN;
	float HEATER10_Temp_Hi_Alarm_Inhibit;
	float HEATER10_RateUp;
	float HEATER10_RateDown;
	float HEATER10_AutotuneActivate;
	float HEATER10_PID_P;
	float HEATER10_PID_I;
	float HEATER10_PID_D;
	float HEATER10_WR_EN;
	float HEATER11_SP;
	float HEATER11_Clear_Alarms;
	float HEATER11_Forced_MV;
	float HEATER11_Auto_Manual;
	float HEATER11_Inhibit;
	float HEATER11_SBrkAlarm_EN;
	float HEATER11_Temp_Hi_Alarm_Inhibit;
	float HEATER11_RateUp;
	float HEATER11_RateDown;
	float HEATER11_AutotuneActivate;
	float HEATER11_PID_P;
	float HEATER11_PID_I;
	float HEATER11_PID_D;
	float HEATER11_WR_EN;
	float HEATER12_SP;
	float HEATER12_Clear_Alarms;
	float HEATER12_Forced_MV;
	float HEATER12_Auto_Manual;
	float HEATER12_Inhibit;
	float HEATER12_SBrkAlarm_EN;
	float HEATER12_Temp_Hi_Alarm_Inhibit;
	float HEATER12_RateUp;
	float HEATER12_RateDown;
	float HEATER12_AutotuneActivate;
	float HEATER12_PID_P;
	float HEATER12_PID_I;
	float HEATER12_PID_D;
	float HEATER12_WR_EN;
	float HEATER13_SP;
	float HEATER13_Clear_Alarms;
	float HEATER13_Forced_MV;
	float HEATER13_Auto_Manual;
	float HEATER13_Inhibit;
	float HEATER13_SBrkAlarm_EN;
	float HEATER13_Temp_Hi_Alarm_Inhibit;
	float HEATER13_RateUp;
	float HEATER13_RateDown;
	float HEATER13_AutotuneActivate;
	float HEATER13_PID_P;
	float HEATER13_PID_I;
	float HEATER13_PID_D;
	float HEATER13_WR_EN;
	float HEATER14_SP;
	float HEATER14_Clear_Alarms;
	float HEATER14_Forced_MV;
	float HEATER14_Auto_Manual;
	float HEATER14_Inhibit;
	float HEATER14_SBrkAlarm_EN;
	float HEATER14_Temp_Hi_Alarm_Inhibit;
	float HEATER14_RateUp;
	float HEATER14_RateDown;
	float HEATER14_AutotuneActivate;
	float HEATER14_PID_P;
	float HEATER14_PID_I;
	float HEATER14_PID_D;
	float HEATER14_WR_EN;
	float HEATER15_SP;
	float HEATER15_Clear_Alarms;
	float HEATER15_Forced_MV;
	float HEATER15_Auto_Manual;
	float HEATER15_Inhibit;
	float HEATER15_SBrkAlarm_EN;
	float HEATER15_Temp_Hi_Alarm_Inhibit;
	float HEATER15_RateUp;
	float HEATER15_RateDown;
	float HEATER15_AutotuneActivate;
	float HEATER15_PID_P;
	float HEATER15_PID_I;
	float HEATER15_PID_D;
	float HEATER15_WR_EN;
	float HEATER16_SP;
	float HEATER16_Clear_Alarms;
	float HEATER16_Forced_MV;
	float HEATER16_Auto_Manual;
	float HEATER16_Inhibit;
	float HEATER16_SBrkAlarm_EN;
	float HEATER16_Temp_Hi_Alarm_Inhibit;
	float HEATER16_RateUp;
	float HEATER16_RateDown;
	float HEATER16_AutotuneActivate;
	float HEATER16_PID_P;
	float HEATER16_PID_I;
	float HEATER16_PID_D;
	float HEATER16_WR_EN;
	float HEATER17_SP;
	float HEATER17_Clear_Alarms;
	float HEATER17_Forced_MV;
	float HEATER17_Auto_Manual;
	float HEATER17_Inhibit;
	float HEATER17_SBrkAlarm_EN;
	float HEATER17_Temp_Hi_Alarm_Inhibit;
	float HEATER17_RateUp;
	float HEATER17_RateDown;
	float HEATER17_AutotuneActivate;
	float HEATER17_PID_P;
	float HEATER17_PID_I;
	float HEATER17_PID_D;
	float HEATER17_WR_EN;
	float HEATER18_SP;
	float HEATER18_Clear_Alarms;
	float HEATER18_Forced_MV;
	float HEATER18_Auto_Manual;
	float HEATER18_Inhibit;
	float HEATER18_SBrkAlarm_EN;
	float HEATER18_Temp_Hi_Alarm_Inhibit;
	float HEATER18_RateUp;
	float HEATER18_RateDown;
	float HEATER18_AutotuneActivate;
	float HEATER18_PID_P;
	float HEATER18_PID_I;
	float HEATER18_PID_D;
	float HEATER18_WR_EN;
	float HEATER19_SP;
	float HEATER19_Clear_Alarms;
	float HEATER19_Forced_MV;
	float HEATER19_Auto_Manual;
	float HEATER19_Inhibit;
	float HEATER19_SBrkAlarm_EN;
	float HEATER19_Temp_Hi_Alarm_Inhibit;
	float HEATER19_RateUp;
	float HEATER19_RateDown;
	float HEATER19_AutotuneActivate;
	float HEATER19_PID_P;
	float HEATER19_PID_I;
	float HEATER19_PID_D;
	float HEATER19_WR_EN;
	float HEATER20_SP;
	float HEATER20_Clear_Alarms;
	float HEATER20_Forced_MV;
	float HEATER20_Auto_Manual;
	float HEATER20_Inhibit;
	float HEATER20_SBrkAlarm_EN;
	float HEATER20_Temp_Hi_Alarm_Inhibit;
	float HEATER20_RateUp;
	float HEATER20_RateDown;
	float HEATER20_AutotuneActivate;
	float HEATER20_PID_P;
	float HEATER20_PID_I;
	float HEATER20_PID_D;
	float HEATER20_WR_EN;
	float HEATER21_SP;
	float HEATER21_Clear_Alarms;
	float HEATER21_Forced_MV;
	float HEATER21_Auto_Manual;
	float HEATER21_Inhibit;
	float HEATER21_SBrkAlarm_EN;
	float HEATER21_Temp_Hi_Alarm_Inhibit;
	float HEATER21_RateUp;
	float HEATER21_RateDown;
	float HEATER21_AutotuneActivate;
	float HEATER21_PID_P;
	float HEATER21_PID_I;
	float HEATER21_PID_D;
	float HEATER21_WR_EN;
	float HEATER22_SP;
	float HEATER22_Clear_Alarms;
	float HEATER22_Forced_MV;
	float HEATER22_Auto_Manual;
	float HEATER22_Inhibit;
	float HEATER22_SBrkAlarm_EN;
	float HEATER22_Temp_Hi_Alarm_Inhibit;
	float HEATER22_RateUp;
	float HEATER22_RateDown;
	float HEATER22_AutotuneActivate;
	float HEATER22_PID_P;
	float HEATER22_PID_I;
	float HEATER22_PID_D;
	float HEATER22_WR_EN;
	float HEATER23_SP;
	float HEATER23_Clear_Alarms;
	float HEATER23_Forced_MV;
	float HEATER23_Auto_Manual;
	float HEATER23_Inhibit;
	float HEATER23_SBrkAlarm_EN;
	float HEATER23_Temp_Hi_Alarm_Inhibit;
	float HEATER23_RateUp;
	float HEATER23_RateDown;
	float HEATER23_AutotuneActivate;
	float HEATER23_PID_P;
	float HEATER23_PID_I;
	float HEATER23_PID_D;
	float HEATER23_WR_EN;
	float HEATER24_SP;
	float HEATER24_Clear_Alarms;
	float HEATER24_Forced_MV;
	float HEATER24_Auto_Manual;
	float HEATER24_Inhibit;
	float HEATER24_SBrkAlarm_EN;
	float HEATER24_Temp_Hi_Alarm_Inhibit;
	float HEATER24_RateUp;
	float HEATER24_RateDown;
	float HEATER24_AutotuneActivate;
	float HEATER24_PID_P;
	float HEATER24_PID_I;
	float HEATER24_PID_D;
	float HEATER24_WR_EN;
	float HEATER25_SP;
	float HEATER25_Clear_Alarms;
	float HEATER25_Forced_MV;
	float HEATER25_Auto_Manual;
	float HEATER25_Inhibit;
	float HEATER25_SBrkAlarm_EN;
	float HEATER25_Temp_Hi_Alarm_Inhibit;
	float HEATER25_RateUp;
	float HEATER25_RateDown;
	float HEATER25_AutotuneActivate;
	float HEATER25_PID_P;
	float HEATER25_PID_I;
	float HEATER25_PID_D;
	float HEATER25_WR_EN;
	float HEATER26_SP;
	float HEATER26_Clear_Alarms;
	float HEATER26_Forced_MV;
	float HEATER26_Auto_Manual;
	float HEATER26_Inhibit;
	float HEATER26_SBrkAlarm_EN;
	float HEATER26_Temp_Hi_Alarm_Inhibit;
	float HEATER26_RateUp;
	float HEATER26_RateDown;
	float HEATER26_AutotuneActivate;
	float HEATER26_PID_P;
	float HEATER26_PID_I;
	float HEATER26_PID_D;
	float HEATER26_WR_EN;
	float HEATER27_SP;
	float HEATER27_Clear_Alarms;
	float HEATER27_Forced_MV;
	float HEATER27_Auto_Manual;
	float HEATER27_Inhibit;
	float HEATER27_SBrkAlarm_EN;
	float HEATER27_Temp_Hi_Alarm_Inhibit;
	float HEATER27_RateUp;
	float HEATER27_RateDown;
	float HEATER27_AutotuneActivate;
	float HEATER27_PID_P;
	float HEATER27_PID_I;
	float HEATER27_PID_D;
	float HEATER27_WR_EN;
	float HEATER28_SP;
	float HEATER28_Clear_Alarms;
	float HEATER28_Forced_MV;
	float HEATER28_Auto_Manual;
	float HEATER28_Inhibit;
	float HEATER28_SBrkAlarm_EN;
	float HEATER28_Temp_Hi_Alarm_Inhibit;
	float HEATER28_RateUp;
	float HEATER28_RateDown;
	float HEATER28_AutotuneActivate;
	float HEATER28_PID_P;
	float HEATER28_PID_I;
	float HEATER28_PID_D;
	float HEATER28_WR_EN;
	float HEATER29_SP;
	float HEATER29_Clear_Alarms;
	float HEATER29_Forced_MV;
	float HEATER29_Auto_Manual;
	float HEATER29_Inhibit;
	float HEATER29_SBrkAlarm_EN;
	float HEATER29_Temp_Hi_Alarm_Inhibit;
	float HEATER29_RateUp;
	float HEATER29_RateDown;
	float HEATER29_AutotuneActivate;
	float HEATER29_PID_P;
	float HEATER29_PID_I;
	float HEATER29_PID_D;
	float HEATER29_WR_EN;
	float HEATER30_SP;
	float HEATER30_Clear_Alarms;
	float HEATER30_Forced_MV;
	float HEATER30_Auto_Manual;
	float HEATER30_Inhibit;
	float HEATER30_SBrkAlarm_EN;
	float HEATER30_Temp_Hi_Alarm_Inhibit;
	float HEATER30_RateUp;
	float HEATER30_RateDown;
	float HEATER30_AutotuneActivate;
	float HEATER30_PID_P;
	float HEATER30_PID_I;
	float HEATER30_PID_D;
	float HEATER30_WR_EN;
	float HEATER31_SP;
	float HEATER31_Clear_Alarms;
	float HEATER31_Forced_MV;
	float HEATER31_Auto_Manual;
	float HEATER31_Inhibit;
	float HEATER31_SBrkAlarm_EN;
	float HEATER31_Temp_Hi_Alarm_Inhibit;
	float HEATER31_RateUp;
	float HEATER31_RateDown;
	float HEATER31_AutotuneActivate;
	float HEATER31_PID_P;
	float HEATER31_PID_I;
	float HEATER31_PID_D;
	float HEATER31_WR_EN;
	float HEATER32_SP;
	float HEATER32_Clear_Alarms;
	float HEATER32_Forced_MV;
	float HEATER32_Auto_Manual;
	float HEATER32_Inhibit;
	float HEATER32_SBrkAlarm_EN;
	float HEATER32_Temp_Hi_Alarm_Inhibit;
	float HEATER32_RateUp;
	float HEATER32_RateDown;
	float HEATER32_AutotuneActivate;
	float HEATER32_PID_P;
	float HEATER32_PID_I;
	float HEATER32_PID_D;
	float HEATER32_WR_EN;
	float HEATER33_SP;
	float HEATER33_Clear_Alarms;
	float HEATER33_Forced_MV;
	float HEATER33_Auto_Manual;
	float HEATER33_Inhibit;
	float HEATER33_SBrkAlarm_EN;
	float HEATER33_Temp_Hi_Alarm_Inhibit;
	float HEATER33_RateUp;
	float HEATER33_RateDown;
	float HEATER33_AutotuneActivate;
	float HEATER33_PID_P;
	float HEATER33_PID_I;
	float HEATER33_PID_D;
	float HEATER33_WR_EN;
	float HEATER34_SP;
	float HEATER34_Clear_Alarms;
	float HEATER34_Forced_MV;
	float HEATER34_Auto_Manual;
	float HEATER34_Inhibit;
	float HEATER34_SBrkAlarm_EN;
	float HEATER34_Temp_Hi_Alarm_Inhibit;
	float HEATER34_RateUp;
	float HEATER34_RateDown;
	float HEATER34_AutotuneActivate;
	float HEATER34_PID_P;
	float HEATER34_PID_I;
	float HEATER34_PID_D;
	float HEATER34_WR_EN;
	float HEATER35_SP;
	float HEATER35_Clear_Alarms;
	float HEATER35_Forced_MV;
	float HEATER35_Auto_Manual;
	float HEATER35_Inhibit;
	float HEATER35_SBrkAlarm_EN;
	float HEATER35_Temp_Hi_Alarm_Inhibit;
	float HEATER35_RateUp;
	float HEATER35_RateDown;
	float HEATER35_AutotuneActivate;
	float HEATER35_PID_P;
	float HEATER35_PID_I;
	float HEATER35_PID_D;
	float HEATER35_WR_EN;
	float HEATER36_SP;
	float HEATER36_Clear_Alarms;
	float HEATER36_Forced_MV;
	float HEATER36_Auto_Manual;
	float HEATER36_Inhibit;
	float HEATER36_SBrkAlarm_EN;
	float HEATER36_Temp_Hi_Alarm_Inhibit;
	float HEATER36_RateUp;
	float HEATER36_RateDown;
	float HEATER36_AutotuneActivate;
	float HEATER36_PID_P;
	float HEATER36_PID_I;
	float HEATER36_PID_D;
	float HEATER36_WR_EN;
	float HEATER37_SP;
	float HEATER37_Clear_Alarms;
	float HEATER37_Forced_MV;
	float HEATER37_Auto_Manual;
	float HEATER37_Inhibit;
	float HEATER37_SBrkAlarm_EN;
	float HEATER37_Temp_Hi_Alarm_Inhibit;
	float HEATER37_RateUp;
	float HEATER37_RateDown;
	float HEATER37_AutotuneActivate;
	float HEATER37_PID_P;
	float HEATER37_PID_I;
	float HEATER37_PID_D;
	float HEATER37_WR_EN;
	float HEATER38_SP;
	float HEATER38_Clear_Alarms;
	float HEATER38_Forced_MV;
	float HEATER38_Auto_Manual;
	float HEATER38_Inhibit;
	float HEATER38_SBrkAlarm_EN;
	float HEATER38_Temp_Hi_Alarm_Inhibit;
	float HEATER38_RateUp;
	float HEATER38_RateDown;
	float HEATER38_AutotuneActivate;
	float HEATER38_PID_P;
	float HEATER38_PID_I;
	float HEATER38_PID_D;
	float HEATER38_WR_EN;
	float HEATER39_SP;
	float HEATER39_Clear_Alarms;
	float HEATER39_Forced_MV;
	float HEATER39_Auto_Manual;
	float HEATER39_Inhibit;
	float HEATER39_SBrkAlarm_EN;
	float HEATER39_Temp_Hi_Alarm_Inhibit;
	float HEATER39_RateUp;
	float HEATER39_RateDown;
	float HEATER39_AutotuneActivate;
	float HEATER39_PID_P;
	float HEATER39_PID_I;
	float HEATER39_PID_D;
	float HEATER39_WR_EN;
	float HEATER40_SP;
	float HEATER40_Clear_Alarms;
	float HEATER40_Forced_MV;
	float HEATER40_Auto_Manual;
	float HEATER40_Inhibit;
	float HEATER40_SBrkAlarm_EN;
	float HEATER40_Temp_Hi_Alarm_Inhibit;
	float HEATER40_RateUp;
	float HEATER40_RateDown;
	float HEATER40_AutotuneActivate;
	float HEATER40_PID_P;
	float HEATER40_PID_I;
	float HEATER40_PID_D;
	float HEATER40_WR_EN;
	float HEATER41_SP;
	float HEATER41_Clear_Alarms;
	float HEATER41_Forced_MV;
	float HEATER41_Auto_Manual;
	float HEATER41_Inhibit;
	float HEATER41_SBrkAlarm_EN;
	float HEATER41_Temp_Hi_Alarm_Inhibit;
	float HEATER41_RateUp;
	float HEATER41_RateDown;
	float HEATER41_AutotuneActivate;
	float HEATER41_PID_P;
	float HEATER41_PID_I;
	float HEATER41_PID_D;
	float HEATER41_WR_EN;
	float HEATER42_SP;
	float HEATER42_Clear_Alarms;
	float HEATER42_Forced_MV;
	float HEATER42_Auto_Manual;
	float HEATER42_Inhibit;
	float HEATER42_SBrkAlarm_EN;
	float HEATER42_Temp_Hi_Alarm_Inhibit;
	float HEATER42_RateUp;
	float HEATER42_RateDown;
	float HEATER42_AutotuneActivate;
	float HEATER42_PID_P;
	float HEATER42_PID_I;
	float HEATER42_PID_D;
	float HEATER42_WR_EN;
	float HEATER43_SP;
	float HEATER43_Clear_Alarms;
	float HEATER43_Forced_MV;
	float HEATER43_Auto_Manual;
	float HEATER43_Inhibit;
	float HEATER43_SBrkAlarm_EN;
	float HEATER43_Temp_Hi_Alarm_Inhibit;
	float HEATER43_RateUp;
	float HEATER43_RateDown;
	float HEATER43_AutotuneActivate;
	float HEATER43_PID_P;
	float HEATER43_PID_I;
	float HEATER43_PID_D;
	float HEATER43_WR_EN;
	float HEATER44_SP;
	float HEATER44_Clear_Alarms;
	float HEATER44_Forced_MV;
	float HEATER44_Auto_Manual;
	float HEATER44_Inhibit;
	float HEATER44_SBrkAlarm_EN;
	float HEATER44_Temp_Hi_Alarm_Inhibit;
	float HEATER44_RateUp;
	float HEATER44_RateDown;
	float HEATER44_AutotuneActivate;
	float HEATER44_PID_P;
	float HEATER44_PID_I;
	float HEATER44_PID_D;
	float HEATER44_WR_EN;
	float HEATER45_SP;
	float HEATER45_Clear_Alarms;
	float HEATER45_Forced_MV;
	float HEATER45_Auto_Manual;
	float HEATER45_Inhibit;
	float HEATER45_SBrkAlarm_EN;
	float HEATER45_Temp_Hi_Alarm_Inhibit;
	float HEATER45_RateUp;
	float HEATER45_RateDown;
	float HEATER45_AutotuneActivate;
	float HEATER45_PID_P;
	float HEATER45_PID_I;
	float HEATER45_PID_D;
	float HEATER45_WR_EN;
	float HEATER46_SP;
	float HEATER46_Clear_Alarms;
	float HEATER46_Forced_MV;
	float HEATER46_Auto_Manual;
	float HEATER46_Inhibit;
	float HEATER46_SBrkAlarm_EN;
	float HEATER46_Temp_Hi_Alarm_Inhibit;
	float HEATER46_RateUp;
	float HEATER46_RateDown;
	float HEATER46_AutotuneActivate;
	float HEATER46_PID_P;
	float HEATER46_PID_I;
	float HEATER46_PID_D;
	float HEATER46_WR_EN;
	float HEATER47_SP;
	float HEATER47_Clear_Alarms;
	float HEATER47_Forced_MV;
	float HEATER47_Auto_Manual;
	float HEATER47_Inhibit;
	float HEATER47_SBrkAlarm_EN;
	float HEATER47_Temp_Hi_Alarm_Inhibit;
	float HEATER47_RateUp;
	float HEATER47_RateDown;
	float HEATER47_AutotuneActivate;
	float HEATER47_PID_P;
	float HEATER47_PID_I;
	float HEATER47_PID_D;
	float HEATER47_WR_EN;
	float HEATER48_SP;
	float HEATER48_Clear_Alarms;
	float HEATER48_Forced_MV;
	float HEATER48_Auto_Manual;
	float HEATER48_Inhibit;
	float HEATER48_SBrkAlarm_EN;
	float HEATER48_Temp_Hi_Alarm_Inhibit;
	float HEATER48_RateUp;
	float HEATER48_RateDown;
	float HEATER48_AutotuneActivate;
	float HEATER48_PID_P;
	float HEATER48_PID_I;
	float HEATER48_PID_D;
	float HEATER48_WR_EN;
	float HEATER49_SP;
	float HEATER49_Clear_Alarms;
	float HEATER49_Forced_MV;
	float HEATER49_Auto_Manual;
	float HEATER49_Inhibit;
	float HEATER49_SBrkAlarm_EN;
	float HEATER49_Temp_Hi_Alarm_Inhibit;
	float HEATER49_RateUp;
	float HEATER49_RateDown;
	float HEATER49_AutotuneActivate;
	float HEATER49_PID_P;
	float HEATER49_PID_I;
	float HEATER49_PID_D;
	float HEATER49_WR_EN;
	float HEATER50_SP;
	float HEATER50_Clear_Alarms;
	float HEATER50_Forced_MV;
	float HEATER50_Auto_Manual;
	float HEATER50_Inhibit;
	float HEATER50_SBrkAlarm_EN;
	float HEATER50_Temp_Hi_Alarm_Inhibit;
	float HEATER50_RateUp;
	float HEATER50_RateDown;
	float HEATER50_AutotuneActivate;
	float HEATER50_PID_P;
	float HEATER50_PID_I;
	float HEATER50_PID_D;
	float HEATER50_WR_EN;
	float HEATER51_SP;
	float HEATER51_Clear_Alarms;
	float HEATER51_Forced_MV;
	float HEATER51_Auto_Manual;
	float HEATER51_Inhibit;
	float HEATER51_SBrkAlarm_EN;
	float HEATER51_Temp_Hi_Alarm_Inhibit;
	float HEATER51_RateUp;
	float HEATER51_RateDown;
	float HEATER51_AutotuneActivate;
	float HEATER51_PID_P;
	float HEATER51_PID_I;
	float HEATER51_PID_D;
	float HEATER51_WR_EN;
	float HEATER52_SP;
	float HEATER52_Clear_Alarms;
	float HEATER52_Forced_MV;
	float HEATER52_Auto_Manual;
	float HEATER52_Inhibit;
	float HEATER52_SBrkAlarm_EN;
	float HEATER52_Temp_Hi_Alarm_Inhibit;
	float HEATER52_RateUp;
	float HEATER52_RateDown;
	float HEATER52_AutotuneActivate;
	float HEATER52_PID_P;
	float HEATER52_PID_I;
	float HEATER52_PID_D;
	float HEATER52_WR_EN;
	float HEATER53_SP;
	float HEATER53_Clear_Alarms;
	float HEATER53_Forced_MV;
	float HEATER53_Auto_Manual;
	float HEATER53_Inhibit;
	float HEATER53_SBrkAlarm_EN;
	float HEATER53_Temp_Hi_Alarm_Inhibit;
	float HEATER53_RateUp;
	float HEATER53_RateDown;
	float HEATER53_AutotuneActivate;
	float HEATER53_PID_P;
	float HEATER53_PID_I;
	float HEATER53_PID_D;
	float HEATER53_WR_EN;
	float HEATER54_SP;
	float HEATER54_Clear_Alarms;
	float HEATER54_Forced_MV;
	float HEATER54_Auto_Manual;
	float HEATER54_Inhibit;
	float HEATER54_SBrkAlarm_EN;
	float HEATER54_Temp_Hi_Alarm_Inhibit;
	float HEATER54_RateUp;
	float HEATER54_RateDown;
	float HEATER54_AutotuneActivate;
	float HEATER54_PID_P;
	float HEATER54_PID_I;
	float HEATER54_PID_D;
	float HEATER54_WR_EN;
	float HEATER55_SP;
	float HEATER55_Clear_Alarms;
	float HEATER55_Forced_MV;
	float HEATER55_Auto_Manual;
	float HEATER55_Inhibit;
	float HEATER55_SBrkAlarm_EN;
	float HEATER55_Temp_Hi_Alarm_Inhibit;
	float HEATER55_RateUp;
	float HEATER55_RateDown;
	float HEATER55_AutotuneActivate;
	float HEATER55_PID_P;
	float HEATER55_PID_I;
	float HEATER55_PID_D;
	float HEATER55_WR_EN;
	float HEATER56_SP;
	float HEATER56_Clear_Alarms;
	float HEATER56_Forced_MV;
	float HEATER56_Auto_Manual;
	float HEATER56_Inhibit;
	float HEATER56_SBrkAlarm_EN;
	float HEATER56_Temp_Hi_Alarm_Inhibit;
	float HEATER56_RateUp;
	float HEATER56_RateDown;
	float HEATER56_AutotuneActivate;
	float HEATER56_PID_P;
	float HEATER56_PID_I;
	float HEATER56_PID_D;
	float HEATER56_WR_EN;
	float HEATER57_SP;
	float HEATER57_Clear_Alarms;
	float HEATER57_Forced_MV;
	float HEATER57_Auto_Manual;
	float HEATER57_Inhibit;
	float HEATER57_SBrkAlarm_EN;
	float HEATER57_Temp_Hi_Alarm_Inhibit;
	float HEATER57_RateUp;
	float HEATER57_RateDown;
	float HEATER57_AutotuneActivate;
	float HEATER57_PID_P;
	float HEATER57_PID_I;
	float HEATER57_PID_D;
	float HEATER57_WR_EN;
	float HEATER58_SP;
	float HEATER58_Clear_Alarms;
	float HEATER58_Forced_MV;
	float HEATER58_Auto_Manual;
	float HEATER58_Inhibit;
	float HEATER58_SBrkAlarm_EN;
	float HEATER58_Temp_Hi_Alarm_Inhibit;
	float HEATER58_RateUp;
	float HEATER58_RateDown;
	float HEATER58_AutotuneActivate;
	float HEATER58_PID_P;
	float HEATER58_PID_I;
	float HEATER58_PID_D;
	float HEATER58_WR_EN;
	float HEATER59_SP;
	float HEATER59_Clear_Alarms;
	float HEATER59_Forced_MV;
	float HEATER59_Auto_Manual;
	float HEATER59_Inhibit;
	float HEATER59_SBrkAlarm_EN;
	float HEATER59_Temp_Hi_Alarm_Inhibit;
	float HEATER59_RateUp;
	float HEATER59_RateDown;
	float HEATER59_AutotuneActivate;
	float HEATER59_PID_P;
	float HEATER59_PID_I;
	float HEATER59_PID_D;
	float HEATER59_WR_EN;
	float HEATER60_SP;
	float HEATER60_Clear_Alarms;
	float HEATER60_Forced_MV;
	float HEATER60_Auto_Manual;
	float HEATER60_Inhibit;
	float HEATER60_SBrkAlarm_EN;
	float HEATER60_Temp_Hi_Alarm_Inhibit;
	float HEATER60_RateUp;
	float HEATER60_RateDown;
	float HEATER60_AutotuneActivate;
	float HEATER60_PID_P;
	float HEATER60_PID_I;
	float HEATER60_PID_D;
	float HEATER60_WR_EN;
	float HEATER61_SP;
	float HEATER61_Clear_Alarms;
	float HEATER61_Forced_MV;
	float HEATER61_Auto_Manual;
	float HEATER61_Inhibit;
	float HEATER61_SBrkAlarm_EN;
	float HEATER61_Temp_Hi_Alarm_Inhibit;
	float HEATER61_RateUp;
	float HEATER61_RateDown;
	float HEATER61_AutotuneActivate;
	float HEATER61_PID_P;
	float HEATER61_PID_I;
	float HEATER61_PID_D;
	float HEATER61_WR_EN;
	float HEATER62_SP;
	float HEATER62_Clear_Alarms;
	float HEATER62_Forced_MV;
	float HEATER62_Auto_Manual;
	float HEATER62_Inhibit;
	float HEATER62_SBrkAlarm_EN;
	float HEATER62_Temp_Hi_Alarm_Inhibit;
	float HEATER62_RateUp;
	float HEATER62_RateDown;
	float HEATER62_AutotuneActivate;
	float HEATER62_PID_P;
	float HEATER62_PID_I;
	float HEATER62_PID_D;
	float HEATER62_WR_EN;
	float HEATER63_SP;
	float HEATER63_Clear_Alarms;
	float HEATER63_Forced_MV;
	float HEATER63_Auto_Manual;
	float HEATER63_Inhibit;
	float HEATER63_SBrkAlarm_EN;
	float HEATER63_Temp_Hi_Alarm_Inhibit;
	float HEATER63_RateUp;
	float HEATER63_RateDown;
	float HEATER63_AutotuneActivate;
	float HEATER63_PID_P;
	float HEATER63_PID_I;
	float HEATER63_PID_D;
	float HEATER63_WR_EN;
	float HEATER64_SP;
	float HEATER64_Clear_Alarms;
	float HEATER64_Forced_MV;
	float HEATER64_Auto_Manual;
	float HEATER64_Inhibit;
	float HEATER64_SBrkAlarm_EN;
	float HEATER64_Temp_Hi_Alarm_Inhibit;
	float HEATER64_RateUp;
	float HEATER64_RateDown;
	float HEATER64_AutotuneActivate;
	float HEATER64_PID_P;
	float HEATER64_PID_I;
	float HEATER64_PID_D;
	float HEATER64_WR_EN;
	float HEATER65_SP;
	float HEATER65_Clear_Alarms;
	float HEATER65_Forced_MV;
	float HEATER65_Auto_Manual;
	float HEATER65_Inhibit;
	float HEATER65_SBrkAlarm_EN;
	float HEATER65_Temp_Hi_Alarm_Inhibit;
	float HEATER65_RateUp;
	float HEATER65_RateDown;
	float HEATER65_AutotuneActivate;
	float HEATER65_PID_P;
	float HEATER65_PID_I;
	float HEATER65_PID_D;
	float HEATER65_WR_EN;
	float HEATER66_SP;
	float HEATER66_Clear_Alarms;
	float HEATER66_Forced_MV;
	float HEATER66_Auto_Manual;
	float HEATER66_Inhibit;
	float HEATER66_SBrkAlarm_EN;
	float HEATER66_Temp_Hi_Alarm_Inhibit;
	float HEATER66_RateUp;
	float HEATER66_RateDown;
	float HEATER66_AutotuneActivate;
	float HEATER66_PID_P;
	float HEATER66_PID_I;
	float HEATER66_PID_D;
	float HEATER66_WR_EN;
	float HEATER67_SP;
	float HEATER67_Clear_Alarms;
	float HEATER67_Forced_MV;
	float HEATER67_Auto_Manual;
	float HEATER67_Inhibit;
	float HEATER67_SBrkAlarm_EN;
	float HEATER67_Temp_Hi_Alarm_Inhibit;
	float HEATER67_RateUp;
	float HEATER67_RateDown;
	float HEATER67_AutotuneActivate;
	float HEATER67_PID_P;
	float HEATER67_PID_I;
	float HEATER67_PID_D;
	float HEATER67_WR_EN;
	float HEATER68_SP;
	float HEATER68_Clear_Alarms;
	float HEATER68_Forced_MV;
	float HEATER68_Auto_Manual;
	float HEATER68_Inhibit;
	float HEATER68_SBrkAlarm_EN;
	float HEATER68_Temp_Hi_Alarm_Inhibit;
	float HEATER68_RateUp;
	float HEATER68_RateDown;
	float HEATER68_AutotuneActivate;
	float HEATER68_PID_P;
	float HEATER68_PID_I;
	float HEATER68_PID_D;
	float HEATER68_WR_EN;
	float HEATER69_SP;
	float HEATER69_Clear_Alarms;
	float HEATER69_Forced_MV;
	float HEATER69_Auto_Manual;
	float HEATER69_Inhibit;
	float HEATER69_SBrkAlarm_EN;
	float HEATER69_Temp_Hi_Alarm_Inhibit;
	float HEATER69_RateUp;
	float HEATER69_RateDown;
	float HEATER69_AutotuneActivate;
	float HEATER69_PID_P;
	float HEATER69_PID_I;
	float HEATER69_PID_D;
	float HEATER69_WR_EN;
	float HEATER70_SP;
	float HEATER70_Clear_Alarms;
	float HEATER70_Forced_MV;
	float HEATER70_Auto_Manual;
	float HEATER70_Inhibit;
	float HEATER70_SBrkAlarm_EN;
	float HEATER70_Temp_Hi_Alarm_Inhibit;
	float HEATER70_RateUp;
	float HEATER70_RateDown;
	float HEATER70_AutotuneActivate;
	float HEATER70_PID_P;
	float HEATER70_PID_I;
	float HEATER70_PID_D;
	float HEATER70_WR_EN;
	float HEATER71_SP;
	float HEATER71_Clear_Alarms;
	float HEATER71_Forced_MV;
	float HEATER71_Auto_Manual;
	float HEATER71_Inhibit;
	float HEATER71_SBrkAlarm_EN;
	float HEATER71_Temp_Hi_Alarm_Inhibit;
	float HEATER71_RateUp;
	float HEATER71_RateDown;
	float HEATER71_AutotuneActivate;
	float HEATER71_PID_P;
	float HEATER71_PID_I;
	float HEATER71_PID_D;
	float HEATER71_WR_EN;
	float HEATER72_SP;
	float HEATER72_Clear_Alarms;
	float HEATER72_Forced_MV;
	float HEATER72_Auto_Manual;
	float HEATER72_Inhibit;
	float HEATER72_SBrkAlarm_EN;
	float HEATER72_Temp_Hi_Alarm_Inhibit;
	float HEATER72_RateUp;
	float HEATER72_RateDown;
	float HEATER72_AutotuneActivate;
	float HEATER72_PID_P;
	float HEATER72_PID_I;
	float HEATER72_PID_D;
	float HEATER72_WR_EN;
	float HEATER73_SP;
	float HEATER73_Clear_Alarms;
	float HEATER73_Forced_MV;
	float HEATER73_Auto_Manual;
	float HEATER73_Inhibit;
	float HEATER73_SBrkAlarm_EN;
	float HEATER73_Temp_Hi_Alarm_Inhibit;
	float HEATER73_RateUp;
	float HEATER73_RateDown;
	float HEATER73_AutotuneActivate;
	float HEATER73_PID_P;
	float HEATER73_PID_I;
	float HEATER73_PID_D;
	float HEATER73_WR_EN;
	float HEATER74_SP;
	float HEATER74_Clear_Alarms;
	float HEATER74_Forced_MV;
	float HEATER74_Auto_Manual;
	float HEATER74_Inhibit;
	float HEATER74_SBrkAlarm_EN;
	float HEATER74_Temp_Hi_Alarm_Inhibit;
	float HEATER74_RateUp;
	float HEATER74_RateDown;
	float HEATER74_AutotuneActivate;
	float HEATER74_PID_P;
	float HEATER74_PID_I;
	float HEATER74_PID_D;
	float HEATER74_WR_EN;
	float HEATER75_SP;
	float HEATER75_Clear_Alarms;
	float HEATER75_Forced_MV;
	float HEATER75_Auto_Manual;
	float HEATER75_Inhibit;
	float HEATER75_SBrkAlarm_EN;
	float HEATER75_Temp_Hi_Alarm_Inhibit;
	float HEATER75_RateUp;
	float HEATER75_RateDown;
	float HEATER75_AutotuneActivate;
	float HEATER75_PID_P;
	float HEATER75_PID_I;
	float HEATER75_PID_D;
	float HEATER75_WR_EN;
	float HEATER76_SP;
	float HEATER76_Clear_Alarms;
	float HEATER76_Forced_MV;
	float HEATER76_Auto_Manual;
	float HEATER76_Inhibit;
	float HEATER76_SBrkAlarm_EN;
	float HEATER76_Temp_Hi_Alarm_Inhibit;
	float HEATER76_RateUp;
	float HEATER76_RateDown;
	float HEATER76_AutotuneActivate;
	float HEATER76_PID_P;
	float HEATER76_PID_I;
	float HEATER76_PID_D;
	float HEATER76_WR_EN;
	float HEATER77_SP;
	float HEATER77_Clear_Alarms;
	float HEATER77_Forced_MV;
	float HEATER77_Auto_Manual;
	float HEATER77_Inhibit;
	float HEATER77_SBrkAlarm_EN;
	float HEATER77_Temp_Hi_Alarm_Inhibit;
	float HEATER77_RateUp;
	float HEATER77_RateDown;
	float HEATER77_AutotuneActivate;
	float HEATER77_PID_P;
	float HEATER77_PID_I;
	float HEATER77_PID_D;
	float HEATER77_WR_EN;
	float HEATER78_SP;
	float HEATER78_Clear_Alarms;
	float HEATER78_Forced_MV;
	float HEATER78_Auto_Manual;
	float HEATER78_Inhibit;
	float HEATER78_SBrkAlarm_EN;
	float HEATER78_Temp_Hi_Alarm_Inhibit;
	float HEATER78_RateUp;
	float HEATER78_RateDown;
	float HEATER78_AutotuneActivate;
	float HEATER78_PID_P;
	float HEATER78_PID_I;
	float HEATER78_PID_D;
	float HEATER78_WR_EN;
	float HEATER79_SP;
	float HEATER79_Clear_Alarms;
	float HEATER79_Forced_MV;
	float HEATER79_Auto_Manual;
	float HEATER79_Inhibit;
	float HEATER79_SBrkAlarm_EN;
	float HEATER79_Temp_Hi_Alarm_Inhibit;
	float HEATER79_RateUp;
	float HEATER79_RateDown;
	float HEATER79_AutotuneActivate;
	float HEATER79_PID_P;
	float HEATER79_PID_I;
	float HEATER79_PID_D;
	float HEATER79_WR_EN;
	float HEATER80_SP;
	float HEATER80_Clear_Alarms;
	float HEATER80_Forced_MV;
	float HEATER80_Auto_Manual;
	float HEATER80_Inhibit;
	float HEATER80_SBrkAlarm_EN;
	float HEATER80_Temp_Hi_Alarm_Inhibit;
	float HEATER80_RateUp;
	float HEATER80_RateDown;
	float HEATER80_AutotuneActivate;
	float HEATER80_PID_P;
	float HEATER80_PID_I;
	float HEATER80_PID_D;
	float HEATER80_WR_EN;
	float HEATER81_SP;
	float HEATER81_Clear_Alarms;
	float HEATER81_Forced_MV;
	float HEATER81_Auto_Manual;
	float HEATER81_Inhibit;
	float HEATER81_SBrkAlarm_EN;
	float HEATER81_Temp_Hi_Alarm_Inhibit;
	float HEATER81_RateUp;
	float HEATER81_RateDown;
	float HEATER81_AutotuneActivate;
	float HEATER81_PID_P;
	float HEATER81_PID_I;
	float HEATER81_PID_D;
	float HEATER81_WR_EN;
	float HEATER82_SP;
	float HEATER82_Clear_Alarms;
	float HEATER82_Forced_MV;
	float HEATER82_Auto_Manual;
	float HEATER82_Inhibit;
	float HEATER82_SBrkAlarm_EN;
	float HEATER82_Temp_Hi_Alarm_Inhibit;
	float HEATER82_RateUp;
	float HEATER82_RateDown;
	float HEATER82_AutotuneActivate;
	float HEATER82_PID_P;
	float HEATER82_PID_I;
	float HEATER82_PID_D;
	float HEATER82_WR_EN;
	float HEATER83_SP;
	float HEATER83_Clear_Alarms;
	float HEATER83_Forced_MV;
	float HEATER83_Auto_Manual;
	float HEATER83_Inhibit;
	float HEATER83_SBrkAlarm_EN;
	float HEATER83_Temp_Hi_Alarm_Inhibit;
	float HEATER83_RateUp;
	float HEATER83_RateDown;
	float HEATER83_AutotuneActivate;
	float HEATER83_PID_P;
	float HEATER83_PID_I;
	float HEATER83_PID_D;
	float HEATER83_WR_EN;
	float HEATER84_SP;
	float HEATER84_Clear_Alarms;
	float HEATER84_Forced_MV;
	float HEATER84_Auto_Manual;
	float HEATER84_Inhibit;
	float HEATER84_SBrkAlarm_EN;
	float HEATER84_Temp_Hi_Alarm_Inhibit;
	float HEATER84_RateUp;
	float HEATER84_RateDown;
	float HEATER84_AutotuneActivate;
	float HEATER84_PID_P;
	float HEATER84_PID_I;
	float HEATER84_PID_D;
	float HEATER84_WR_EN;
	float HEATER85_SP;
	float HEATER85_Clear_Alarms;
	float HEATER85_Forced_MV;
	float HEATER85_Auto_Manual;
	float HEATER85_Inhibit;
	float HEATER85_SBrkAlarm_EN;
	float HEATER85_Temp_Hi_Alarm_Inhibit;
	float HEATER85_RateUp;
	float HEATER85_RateDown;
	float HEATER85_AutotuneActivate;
	float HEATER85_PID_P;
	float HEATER85_PID_I;
	float HEATER85_PID_D;
	float HEATER85_WR_EN;
	float HEATER86_SP;
	float HEATER86_Clear_Alarms;
	float HEATER86_Forced_MV;
	float HEATER86_Auto_Manual;
	float HEATER86_Inhibit;
	float HEATER86_SBrkAlarm_EN;
	float HEATER86_Temp_Hi_Alarm_Inhibit;
	float HEATER86_RateUp;
	float HEATER86_RateDown;
	float HEATER86_AutotuneActivate;
	float HEATER86_PID_P;
	float HEATER86_PID_I;
	float HEATER86_PID_D;
	float HEATER86_WR_EN;
	float HEATER87_SP;
	float HEATER87_Clear_Alarms;
	float HEATER87_Forced_MV;
	float HEATER87_Auto_Manual;
	float HEATER87_Inhibit;
	float HEATER87_SBrkAlarm_EN;
	float HEATER87_Temp_Hi_Alarm_Inhibit;
	float HEATER87_RateUp;
	float HEATER87_RateDown;
	float HEATER87_AutotuneActivate;
	float HEATER87_PID_P;
	float HEATER87_PID_I;
	float HEATER87_PID_D;
	float HEATER87_WR_EN;
	float HEATER88_SP;
	float HEATER88_Clear_Alarms;
	float HEATER88_Forced_MV;
	float HEATER88_Auto_Manual;
	float HEATER88_Inhibit;
	float HEATER88_SBrkAlarm_EN;
	float HEATER88_Temp_Hi_Alarm_Inhibit;
	float HEATER88_RateUp;
	float HEATER88_RateDown;
	float HEATER88_AutotuneActivate;
	float HEATER88_PID_P;
	float HEATER88_PID_I;
	float HEATER88_PID_D;
	float HEATER88_WR_EN;
	float HEATER89_SP;
	float HEATER89_Clear_Alarms;
	float HEATER89_Forced_MV;
	float HEATER89_Auto_Manual;
	float HEATER89_Inhibit;
	float HEATER89_SBrkAlarm_EN;
	float HEATER89_Temp_Hi_Alarm_Inhibit;
	float HEATER89_RateUp;
	float HEATER89_RateDown;
	float HEATER89_AutotuneActivate;
	float HEATER89_PID_P;
	float HEATER89_PID_I;
	float HEATER89_PID_D;
	float HEATER89_WR_EN;
	float HEATER90_SP;
	float HEATER90_Clear_Alarms;
	float HEATER90_Forced_MV;
	float HEATER90_Auto_Manual;
	float HEATER90_Inhibit;
	float HEATER90_SBrkAlarm_EN;
	float HEATER90_Temp_Hi_Alarm_Inhibit;
	float HEATER90_RateUp;
	float HEATER90_RateDown;
	float HEATER90_AutotuneActivate;
	float HEATER90_PID_P;
	float HEATER90_PID_I;
	float HEATER90_PID_D;
	float HEATER90_WR_EN;
	float HEATER91_SP;
	float HEATER91_Clear_Alarms;
	float HEATER91_Forced_MV;
	float HEATER91_Auto_Manual;
	float HEATER91_Inhibit;
	float HEATER91_SBrkAlarm_EN;
	float HEATER91_Temp_Hi_Alarm_Inhibit;
	float HEATER91_RateUp;
	float HEATER91_RateDown;
	float HEATER91_AutotuneActivate;
	float HEATER91_PID_P;
	float HEATER91_PID_I;
	float HEATER91_PID_D;
	float HEATER91_WR_EN;
	float HEATER92_SP;
	float HEATER92_Clear_Alarms;
	float HEATER92_Forced_MV;
	float HEATER92_Auto_Manual;
	float HEATER92_Inhibit;
	float HEATER92_SBrkAlarm_EN;
	float HEATER92_Temp_Hi_Alarm_Inhibit;
	float HEATER92_RateUp;
	float HEATER92_RateDown;
	float HEATER92_AutotuneActivate;
	float HEATER92_PID_P;
	float HEATER92_PID_I;
	float HEATER92_PID_D;
	float HEATER92_WR_EN;
	float HEATER93_SP;
	float HEATER93_Clear_Alarms;
	float HEATER93_Forced_MV;
	float HEATER93_Auto_Manual;
	float HEATER93_Inhibit;
	float HEATER93_SBrkAlarm_EN;
	float HEATER93_Temp_Hi_Alarm_Inhibit;
	float HEATER93_RateUp;
	float HEATER93_RateDown;
	float HEATER93_AutotuneActivate;
	float HEATER93_PID_P;
	float HEATER93_PID_I;
	float HEATER93_PID_D;
	float HEATER93_WR_EN;
	float HEATER94_SP;
	float HEATER94_Clear_Alarms;
	float HEATER94_Forced_MV;
	float HEATER94_Auto_Manual;
	float HEATER94_Inhibit;
	float HEATER94_SBrkAlarm_EN;
	float HEATER94_Temp_Hi_Alarm_Inhibit;
	float HEATER94_RateUp;
	float HEATER94_RateDown;
	float HEATER94_AutotuneActivate;
	float HEATER94_PID_P;
	float HEATER94_PID_I;
	float HEATER94_PID_D;
	float HEATER94_WR_EN;
	float HEATER95_SP;
	float HEATER95_Clear_Alarms;
	float HEATER95_Forced_MV;
	float HEATER95_Auto_Manual;
	float HEATER95_Inhibit;
	float HEATER95_SBrkAlarm_EN;
	float HEATER95_Temp_Hi_Alarm_Inhibit;
	float HEATER95_RateUp;
	float HEATER95_RateDown;
	float HEATER95_AutotuneActivate;
	float HEATER95_PID_P;
	float HEATER95_PID_I;
	float HEATER95_PID_D;
	float HEATER95_WR_EN;
	float HEATER96_SP;
	float HEATER96_Clear_Alarms;
	float HEATER96_Forced_MV;
	float HEATER96_Auto_Manual;
	float HEATER96_Inhibit;
	float HEATER96_SBrkAlarm_EN;
	float HEATER96_Temp_Hi_Alarm_Inhibit;
	float HEATER96_RateUp;
	float HEATER96_RateDown;
	float HEATER96_AutotuneActivate;
	float HEATER96_PID_P;
	float HEATER96_PID_I;
	float HEATER96_PID_D;
	float HEATER96_WR_EN;
	float HEATER97_SP;
	float HEATER97_Clear_Alarms;
	float HEATER97_Forced_MV;
	float HEATER97_Auto_Manual;
	float HEATER97_Inhibit;
	float HEATER97_SBrkAlarm_EN;
	float HEATER97_Temp_Hi_Alarm_Inhibit;
	float HEATER97_RateUp;
	float HEATER97_RateDown;
	float HEATER97_AutotuneActivate;
	float HEATER97_PID_P;
	float HEATER97_PID_I;
	float HEATER97_PID_D;
	float HEATER97_WR_EN;
	float HEATER98_SP;
	float HEATER98_Clear_Alarms;
	float HEATER98_Forced_MV;
	float HEATER98_Auto_Manual;
	float HEATER98_Inhibit;
	float HEATER98_SBrkAlarm_EN;
	float HEATER98_Temp_Hi_Alarm_Inhibit;
	float HEATER98_RateUp;
	float HEATER98_RateDown;
	float HEATER98_AutotuneActivate;
	float HEATER98_PID_P;
	float HEATER98_PID_I;
	float HEATER98_PID_D;
	float HEATER98_WR_EN;
	float HEATER99_SP;
	float HEATER99_Clear_Alarms;
	float HEATER99_Forced_MV;
	float HEATER99_Auto_Manual;
	float HEATER99_Inhibit;
	float HEATER99_SBrkAlarm_EN;
	float HEATER99_Temp_Hi_Alarm_Inhibit;
	float HEATER99_RateUp;
	float HEATER99_RateDown;
	float HEATER99_AutotuneActivate;
	float HEATER99_PID_P;
	float HEATER99_PID_I;
	float HEATER99_PID_D;
	float HEATER99_WR_EN;
	float HEATER100_SP;
	float HEATER100_Clear_Alarms;
	float HEATER100_Forced_MV;
	float HEATER100_Auto_Manual;
	float HEATER100_Inhibit;
	float HEATER100_SBrkAlarm_EN;
	float HEATER100_Temp_Hi_Alarm_Inhibit;
	float HEATER100_RateUp;
	float HEATER100_RateDown;
	float HEATER100_AutotuneActivate;
	float HEATER100_PID_P;
	float HEATER100_PID_I;
	float HEATER100_PID_D;
	float HEATER100_WR_EN;
	float HEATER101_SP;
	float HEATER101_Clear_Alarms;
	float HEATER101_Forced_MV;
	float HEATER101_Auto_Manual;
	float HEATER101_Inhibit;
	float HEATER101_SBrkAlarm_EN;
	float HEATER101_Temp_Hi_Alarm_Inhibit;
	float HEATER101_RateUp;
	float HEATER101_RateDown;
	float HEATER101_AutotuneActivate;
	float HEATER101_PID_P;
	float HEATER101_PID_I;
	float HEATER101_PID_D;
	float HEATER101_WR_EN;
	float HEATER102_SP;
	float HEATER102_Clear_Alarms;
	float HEATER102_Forced_MV;
	float HEATER102_Auto_Manual;
	float HEATER102_Inhibit;
	float HEATER102_SBrkAlarm_EN;
	float HEATER102_Temp_Hi_Alarm_Inhibit;
	float HEATER102_RateUp;
	float HEATER102_RateDown;
	float HEATER102_AutotuneActivate;
	float HEATER102_PID_P;
	float HEATER102_PID_I;
	float HEATER102_PID_D;
	float HEATER102_WR_EN;
	float HEATER103_SP;
	float HEATER103_Clear_Alarms;
	float HEATER103_Forced_MV;
	float HEATER103_Auto_Manual;
	float HEATER103_Inhibit;
	float HEATER103_SBrkAlarm_EN;
	float HEATER103_Temp_Hi_Alarm_Inhibit;
	float HEATER103_RateUp;
	float HEATER103_RateDown;
	float HEATER103_AutotuneActivate;
	float HEATER103_PID_P;
	float HEATER103_PID_I;
	float HEATER103_PID_D;
	float HEATER103_WR_EN;
	float HEATER104_SP;
	float HEATER104_Clear_Alarms;
	float HEATER104_Forced_MV;
	float HEATER104_Auto_Manual;
	float HEATER104_Inhibit;
	float HEATER104_SBrkAlarm_EN;
	float HEATER104_Temp_Hi_Alarm_Inhibit;
	float HEATER104_RateUp;
	float HEATER104_RateDown;
	float HEATER104_AutotuneActivate;
	float HEATER104_PID_P;
	float HEATER104_PID_I;
	float HEATER104_PID_D;
	float HEATER104_WR_EN;
	float HEATER105_SP;
	float HEATER105_Clear_Alarms;
	float HEATER105_Forced_MV;
	float HEATER105_Auto_Manual;
	float HEATER105_Inhibit;
	float HEATER105_SBrkAlarm_EN;
	float HEATER105_Temp_Hi_Alarm_Inhibit;
	float HEATER105_RateUp;
	float HEATER105_RateDown;
	float HEATER105_AutotuneActivate;
	float HEATER105_PID_P;
	float HEATER105_PID_I;
	float HEATER105_PID_D;
	float HEATER105_WR_EN;
	float HEATER106_SP;
	float HEATER106_Clear_Alarms;
	float HEATER106_Forced_MV;
	float HEATER106_Auto_Manual;
	float HEATER106_Inhibit;
	float HEATER106_SBrkAlarm_EN;
	float HEATER106_Temp_Hi_Alarm_Inhibit;
	float HEATER106_RateUp;
	float HEATER106_RateDown;
	float HEATER106_AutotuneActivate;
	float HEATER106_PID_P;
	float HEATER106_PID_I;
	float HEATER106_PID_D;
	float HEATER106_WR_EN;
	float HEATER107_SP;
	float HEATER107_Clear_Alarms;
	float HEATER107_Forced_MV;
	float HEATER107_Auto_Manual;
	float HEATER107_Inhibit;
	float HEATER107_SBrkAlarm_EN;
	float HEATER107_Temp_Hi_Alarm_Inhibit;
	float HEATER107_RateUp;
	float HEATER107_RateDown;
	float HEATER107_AutotuneActivate;
	float HEATER107_PID_P;
	float HEATER107_PID_I;
	float HEATER107_PID_D;
	float HEATER107_WR_EN;
	float HEATER108_SP;
	float HEATER108_Clear_Alarms;
	float HEATER108_Forced_MV;
	float HEATER108_Auto_Manual;
	float HEATER108_Inhibit;
	float HEATER108_SBrkAlarm_EN;
	float HEATER108_Temp_Hi_Alarm_Inhibit;
	float HEATER108_RateUp;
	float HEATER108_RateDown;
	float HEATER108_AutotuneActivate;
	float HEATER108_PID_P;
	float HEATER108_PID_I;
	float HEATER108_PID_D;
	float HEATER108_WR_EN;
	float HEATER109_SP;
	float HEATER109_Clear_Alarms;
	float HEATER109_Forced_MV;
	float HEATER109_Auto_Manual;
	float HEATER109_Inhibit;
	float HEATER109_SBrkAlarm_EN;
	float HEATER109_Temp_Hi_Alarm_Inhibit;
	float HEATER109_RateUp;
	float HEATER109_RateDown;
	float HEATER109_AutotuneActivate;
	float HEATER109_PID_P;
	float HEATER109_PID_I;
	float HEATER109_PID_D;
	float HEATER109_WR_EN;
	float HEATER110_SP;
	float HEATER110_Clear_Alarms;
	float HEATER110_Forced_MV;
	float HEATER110_Auto_Manual;
	float HEATER110_Inhibit;
	float HEATER110_SBrkAlarm_EN;
	float HEATER110_Temp_Hi_Alarm_Inhibit;
	float HEATER110_RateUp;
	float HEATER110_RateDown;
	float HEATER110_AutotuneActivate;
	float HEATER110_PID_P;
	float HEATER110_PID_I;
	float HEATER110_PID_D;
	float HEATER110_WR_EN;
	float HEATER111_SP;
	float HEATER111_Clear_Alarms;
	float HEATER111_Forced_MV;
	float HEATER111_Auto_Manual;
	float HEATER111_Inhibit;
	float HEATER111_SBrkAlarm_EN;
	float HEATER111_Temp_Hi_Alarm_Inhibit;
	float HEATER111_RateUp;
	float HEATER111_RateDown;
	float HEATER111_AutotuneActivate;
	float HEATER111_PID_P;
	float HEATER111_PID_I;
	float HEATER111_PID_D;
	float HEATER111_WR_EN;
	float HEATER112_SP;
	float HEATER112_Clear_Alarms;
	float HEATER112_Forced_MV;
	float HEATER112_Auto_Manual;
	float HEATER112_Inhibit;
	float HEATER112_SBrkAlarm_EN;
	float HEATER112_Temp_Hi_Alarm_Inhibit;
	float HEATER112_RateUp;
	float HEATER112_RateDown;
	float HEATER112_AutotuneActivate;
	float HEATER112_PID_P;
	float HEATER112_PID_I;
	float HEATER112_PID_D;
	float HEATER112_WR_EN;
	float HEATER113_SP;
	float HEATER113_Clear_Alarms;
	float HEATER113_Forced_MV;
	float HEATER113_Auto_Manual;
	float HEATER113_Inhibit;
	float HEATER113_SBrkAlarm_EN;
	float HEATER113_Temp_Hi_Alarm_Inhibit;
	float HEATER113_RateUp;
	float HEATER113_RateDown;
	float HEATER113_AutotuneActivate;
	float HEATER113_PID_P;
	float HEATER113_PID_I;
	float HEATER113_PID_D;
	float HEATER113_WR_EN;
	float HEATER114_SP;
	float HEATER114_Clear_Alarms;
	float HEATER114_Forced_MV;
	float HEATER114_Auto_Manual;
	float HEATER114_Inhibit;
	float HEATER114_SBrkAlarm_EN;
	float HEATER114_Temp_Hi_Alarm_Inhibit;
	float HEATER114_RateUp;
	float HEATER114_RateDown;
	float HEATER114_AutotuneActivate;
	float HEATER114_PID_P;
	float HEATER114_PID_I;
	float HEATER114_PID_D;
	float HEATER114_WR_EN;
	float HEATER115_SP;
	float HEATER115_Clear_Alarms;
	float HEATER115_Forced_MV;
	float HEATER115_Auto_Manual;
	float HEATER115_Inhibit;
	float HEATER115_SBrkAlarm_EN;
	float HEATER115_Temp_Hi_Alarm_Inhibit;
	float HEATER115_RateUp;
	float HEATER115_RateDown;
	float HEATER115_AutotuneActivate;
	float HEATER115_PID_P;
	float HEATER115_PID_I;
	float HEATER115_PID_D;
	float HEATER115_WR_EN;
	float HEATER116_SP;
	float HEATER116_Clear_Alarms;
	float HEATER116_Forced_MV;
	float HEATER116_Auto_Manual;
	float HEATER116_Inhibit;
	float HEATER116_SBrkAlarm_EN;
	float HEATER116_Temp_Hi_Alarm_Inhibit;
	float HEATER116_RateUp;
	float HEATER116_RateDown;
	float HEATER116_AutotuneActivate;
	float HEATER116_PID_P;
	float HEATER116_PID_I;
	float HEATER116_PID_D;
	float HEATER116_WR_EN;
	float HEATER117_SP;
	float HEATER117_Clear_Alarms;
	float HEATER117_Forced_MV;
	float HEATER117_Auto_Manual;
	float HEATER117_Inhibit;
	float HEATER117_SBrkAlarm_EN;
	float HEATER117_Temp_Hi_Alarm_Inhibit;
	float HEATER117_RateUp;
	float HEATER117_RateDown;
	float HEATER117_AutotuneActivate;
	float HEATER117_PID_P;
	float HEATER117_PID_I;
	float HEATER117_PID_D;
	float HEATER117_WR_EN;
	float HEATER118_SP;
	float HEATER118_Clear_Alarms;
	float HEATER118_Forced_MV;
	float HEATER118_Auto_Manual;
	float HEATER118_Inhibit;
	float HEATER118_SBrkAlarm_EN;
	float HEATER118_Temp_Hi_Alarm_Inhibit;
	float HEATER118_RateUp;
	float HEATER118_RateDown;
	float HEATER118_AutotuneActivate;
	float HEATER118_PID_P;
	float HEATER118_PID_I;
	float HEATER118_PID_D;
	float HEATER118_WR_EN;
	float HEATER119_SP;
	float HEATER119_Clear_Alarms;
	float HEATER119_Forced_MV;
	float HEATER119_Auto_Manual;
	float HEATER119_Inhibit;
	float HEATER119_SBrkAlarm_EN;
	float HEATER119_Temp_Hi_Alarm_Inhibit;
	float HEATER119_RateUp;
	float HEATER119_RateDown;
	float HEATER119_AutotuneActivate;
	float HEATER119_PID_P;
	float HEATER119_PID_I;
	float HEATER119_PID_D;
	float HEATER119_WR_EN;
	float HEATER120_SP;
	float HEATER120_Clear_Alarms;
	float HEATER120_Forced_MV;
	float HEATER120_Auto_Manual;
	float HEATER120_Inhibit;
	float HEATER120_SBrkAlarm_EN;
	float HEATER120_Temp_Hi_Alarm_Inhibit;
	float HEATER120_RateUp;
	float HEATER120_RateDown;
	float HEATER120_AutotuneActivate;
	float HEATER120_PID_P;
	float HEATER120_PID_I;
	float HEATER120_PID_D;
	float HEATER120_WR_EN;
	float TPUINumber;
	float FFU_ALARM_EN;
	float FFU_HSPEED;
	float FFU_LSPEED;
	float FFU1_1_POWER_ON;
	float FFU1_2_POWER_ON;
	float FFU1_3_POWER_ON;
	float FFU1_4_POWER_ON;
	float FFU1_5_POWER_ON;
	float FFU1_6_POWER_ON;
	float FFU2_1_POWER_ON;
	float FFU2_2_POWER_ON;
	float FFU2_3_POWER_ON;
	float FFU2_4_POWER_ON;
	float FFU2_5_POWER_ON;
	float FFU2_6_POWER_ON;
	float FFU3_1_POWER_ON;
	float FFU3_2_POWER_ON;
	float FFU3_3_POWER_ON;
	float FFU3_4_POWER_ON;
	float FFU3_5_POWER_ON;
	float FFU3_6_POWER_ON;
	float FFU1_1_SPEED_SV;
	float FFU1_2_SPEED_SV;
	float FFU1_3_SPEED_SV;
	float FFU1_4_SPEED_SV;
	float FFU1_5_SPEED_SV;
	float FFU1_6_SPEED_SV;
	float FFU2_1_SPEED_SV;
	float FFU2_2_SPEED_SV;
	float FFU2_3_SPEED_SV;
	float FFU2_4_SPEED_SV;
	float FFU2_5_SPEED_SV;
	float FFU2_6_SPEED_SV;
	float FFU3_1_SPEED_SV;
	float FFU3_2_SPEED_SV;
	float FFU3_3_SPEED_SV;
	float FFU3_4_SPEED_SV;
	float FFU3_5_SPEED_SV;
	float FFU3_6_SPEED_SV;
	float FFU1_1_EN;
	float FFU1_2_EN;
	float FFU1_3_EN;
	float FFU1_4_EN;
	float FFU1_5_EN;
	float FFU1_6_EN;
	float FFU2_1_EN;
	float FFU2_2_EN;
	float FFU2_3_EN;
	float FFU2_4_EN;
	float FFU2_5_EN;
	float FFU2_6_EN;
	float FFU3_1_EN;
	float FFU3_2_EN;
	float FFU3_3_EN;
	float FFU3_4_EN;
	float FFU3_5_EN;
	float FFU3_6_EN;
	float UI_LA_O2_Over_Time;
	float UI_LA_O2_Check_Time;
	float UI_FOUP_O2_Over_Time;
	float UI_FOUP_O2_Check_Time;
	float UI_Exchange_LA_TO_FOUP_Wait_Time;
	float UI_Exchange_FOUP_TO_LA_Wait_Time;
	float UI_Exchange_FOUP_TO_FOUP_Wait_Time;
	float UI_LA_O2_Check_SV;
	float UI_FOUP_O2_Check_SV;
	float CKD_APC_Control_Mode;
	float CKD_APC_Process_Setpoint;
	float CKD_APC_Position_Setpoint;
	float CKD_APC_Exh_Rate;
	float CKD_APC_Active_Controller;
	float CKD_APC_Slow_exhaust_control_arrival_pressure;
	float CKD_APC_Zero_Reset_P1;
	float CKD_APC_Zero_adjust_P1;
	float CKD_APC_Span_adjust_P1;
	float CKD_APC_Zero_Reset_P2;
	float CKD_APC_Zero_adjust_P2;
	float CKD_APC_Span_adjust_P2;
	float CKD_APC_Slow_vacuum_control_target_vacuum_Pressure;
	float CKD_APC_Valve_status_threshold;
	float CKD_APC_Forbid_interlock_outbreak;
	float CKD_APC_Slow_vacuum_mode_setting;
	float CKD_APC_Interlock1;
	float CKD_APC_Interlock2;
	float CKD_APC_Interlock3;
	float CKD_APC_Interlock_constant_of_interlock3;
	float CKD_APC_P1_sensor_offset_setting;
	float CKD_APC_Pos_mon_offset_setting;
	float CKD_APC_Sensor_adjust_reset;
	float CKD_APC_Slow_vacuum_rate;
	float CKD_APC_Slow_vacuum_control_P;
	float CKD_APC_Slow_vacuum_control_I;
	float CKD_APC_Slow_vacuum_control_D;
	float CKD_APC_Slow_vacuum_control_a;
	float CKD_APC_controller_mode_select;
	float CKD_APC_Specify_target_vacuum_Pressure_control;
	float CKD_APC_Specify_target_opening_for_valve_opening_control;
	float CKD_APC_Specify_control_mode;
	float CKD_APC_Range_Upper_Limit_Sensor_Input1;
	float CKD_APC_Range_Upper_Limit_Sensor_Input2;
	float CKD_APC_P_constant_for_process_controller1;
	float CKD_APC_I_constant_for_process_controller1;
	float CKD_APC_D_constant_for_process_controller1;
	float CKD_APC_a_sensor_differential_controller1;
	float CKD_APC_CH_controller1;
	float CKD_APC_CL1_controller1;
	float CKD_APC_OFFSET_for_Pocess_Controller_1;
	float CKD_APC_P_constant_for_process_controller2;
	float CKD_APC_I_constant_for_process_controller2;
	float CKD_APC_D_constant_for_process_controller2;
	float CKD_APC_a_sensor_differential_controller2;
	float CKD_APC_CH_controller2;
	float CKD_APC_CL1_controller2;
	float CKD_APC_OFFSET_for_Pocess_Controller_2;
	float CKD_APC_P_constant_for_process_controller3;
	float CKD_APC_I_constant_for_process_controller3;
	float CKD_APC_D_constant_for_process_controller3;
	float CKD_APC_a_sensor_differential_controller3;
	float CKD_APC_CH_controller3;
	float CKD_APC_CL1_controller3;
	float CKD_APC_OFFSET_for_Pocess_Controller_3;
	float CKD_APC_P_constant_for_process_controller4;
	float CKD_APC_I_constant_for_process_controller4;
	float CKD_APC_D_constant_for_process_controller4;
	float CKD_APC_a_sensor_differential_controller4;
	float CKD_APC_CH_controller4;
	float CKD_APC_CL1_controller4;
	float CKD_APC_OFFSET_for_Pocess_Controller_4;
	float CKD_APC_P_constant_for_process_controller5;
	float CKD_APC_I_constant_for_process_controller5;
	float CKD_APC_D_constant_for_process_controller5;
	float CKD_APC_a_sensor_differential_controller5;
	float CKD_APC_CH_controller5;
	float CKD_APC_CL1_controller5;
	float CKD_APC_OFFSET_for_Pocess_Controller_5;
	float CKD_APC_P_constant_for_process_controller6;
	float CKD_APC_I_constant_for_process_controller6;
	float CKD_APC_D_constant_for_process_controller6;
	float CKD_APC_a_sensor_differential_controller6;
	float CKD_APC_CH_controller6;
	float CKD_APC_CL1_controller6;
	float CKD_APC_OFFSET_for_Pocess_Controller_6;
	float CKD_APC_P_constant_for_process_controller7;
	float CKD_APC_I_constant_for_process_controller7;
	float CKD_APC_D_constant_for_process_controller7;
	float CKD_APC_a_sensor_differential_controller7;
	float CKD_APC_CH_controller7;
	float CKD_APC_CL1_controller7;
	float CKD_APC_OFFSET_for_Pocess_Controller_7;
	float CKD_APC_P_constant_for_process_controller8;
	float CKD_APC_I_constant_for_process_controller8;
	float CKD_APC_D_constant_for_process_controller8;
	float CKD_APC_a_sensor_differential_controller8;
	float CKD_APC_CH_controller8;
	float CKD_APC_CL1_controller8;
	float CKD_APC_OFFSET_for_Pocess_Controller_8;
	float CKD_APC_P_constant_for_process_controller9;
	float CKD_APC_I_constant_for_process_controller9;
	float CKD_APC_D_constant_for_process_controller9;
	float CKD_APC_a_sensor_differential_controller9;
	float CKD_APC_CH_controller9;
	float CKD_APC_CL1_controller9;
	float CKD_APC_OFFSET_for_Pocess_Controller_9;
	float CKD_APC_P_constant_for_process_controller10;
	float CKD_APC_I_constant_for_process_controller10;
	float CKD_APC_D_constant_for_process_controller10;
	float CKD_APC_a_sensor_differential_controller10;
	float CKD_APC_CH_controller10;
	float CKD_APC_CL1_controller10;
	float CKD_APC_OFFSET_for_Pocess_Controller_10;
	float Target_Pressure;
	float Target_Position;
	float Pressure_Input_Digital_Sensor_1;
	float Pressure_Input_Digital_Sensor_2;
	float Control_Mode;
	float General_Control_Setpoint;
	float Pressure_Ramp_Time;
	float TargetPositionBufferAxis;
	float BufferRotationSpeed;
	float BoatPosition;
	float BoatRotationSpeed;
	float RotationSpeed;
	float BufferPos0;
	float BufferPos1;
	float BufferPos2;
	float BufferPos3;
	float BufferPos4;
	float BufferPos5;
	float BufferPos6;
	float BufferPos7;
	float BufferPos8;
	float BufferPos9;
	float BufferPos10;
	float BufferPos11;
	float BufferPos12;
	float BufferPos13;
	float BufferPos14;
	float BufferPos15;
	float BufferPos16;
	float BufferPos17;
	float BufferPos18;
	float BufferPos19;
	float BufferPos20;
	float BufferPos21;
	float BufferPos22;
	float BufferPos23;
	float BufferPos24;
	float BufferPos25;
	float BufferPos26;
	float BufferPos27;
	float BufferPos28;
	float BufferPos29;
	float BufferPos30;
	float BufferPos31;
	float BoatPos0;
	float BoatPos1;
	float BoatPos2;
	float BoatPos3;
	float BoatPos4;
	float BoatPos5;
	float BoatPos6;
	float BoatPos7;
	float BoatPos8;
	float BoatPos9;
	float BoatPos10;
	float BoatPos11;
	float BoatPos12;
	float BoatPos13;
	float BoatPos14;
	float BoatPos15;
	float BoatPos16;
	float BoatPos17;
	float BoatPos18;
	float BoatPos19;
	float BoatPos20;
	float BoatPos21;
	float BoatPos22;
	float BoatPos23;
	float BoatPos24;
	float BoatPos25;
	float BoatPos26;
	float BoatPos27;
	float BoatPos28;
	float BoatPos29;
	float BoatPos30;
	float BoatPos31;
	float CapPos0;
	float CapPos1;
	float CapPos2;
	float CapPos3;
	float CapPos4;
	float CapPos5;
	float CapPos6;
	float CapPos7;
	float CapPos8;
	float CapPos9;
	float CapPos10;
	float CapPos11;
	float CapPos12;
	float CapPos13;
	float CapPos14;
	float CapPos15;
	float CapPos16;
	float CapPos17;
	float CapPos18;
	float CapPos19;
	float CapPos20;
	float CapPos21;
	float CapPos22;
	float CapPos23;
	float CapPos24;
	float CapPos25;
	float CapPos26;
	float CapPos27;
	float CapPos28;
	float CapPos29;
	float CapPos30;
	float CapPos31;
	float BufferVel0;
	float BufferVel1;
	float BufferVel2;
	float BufferVel3;
	float BufferVel4;
	float BufferVel5;
	float BufferVel6;
	float BufferVel7;
	float BufferVel8;
	float BufferVel9;
	float BufferVel10;
	float BufferVel11;
	float BufferVel12;
	float BufferVel13;
	float BufferVel14;
	float BufferVel15;
	float BufferVel16;
	float BufferVel17;
	float BufferVel18;
	float BufferVel19;
	float BufferVel20;
	float BufferVel21;
	float BufferVel22;
	float BufferVel23;
	float BufferVel24;
	float BufferVel25;
	float BufferVel26;
	float BufferVel27;
	float BufferVel28;
	float BufferVel29;
	float BufferVel30;
	float BufferVel31;
	float BoatVel0;
	float BoatVel1;
	float BoatVel2;
	float BoatVel3;
	float BoatVel4;
	float BoatVel5;
	float BoatVel6;
	float BoatVel7;
	float BoatVel8;
	float BoatVel9;
	float BoatVel10;
	float BoatVel11;
	float BoatVel12;
	float BoatVel13;
	float BoatVel14;
	float BoatVel15;
	float BoatVel16;
	float BoatVel17;
	float BoatVel18;
	float BoatVel19;
	float BoatVel20;
	float BoatVel21;
	float BoatVel22;
	float BoatVel23;
	float BoatVel24;
	float BoatVel25;
	float BoatVel26;
	float BoatVel27;
	float BoatVel28;
	float BoatVel29;
	float BoatVel30;
	float BoatVel31;
	float CapVel0;
	float CapVel1;
	float CapVel2;
	float CapVel3;
	float CapVel4;
	float CapVel5;
	float CapVel6;
	float CapVel7;
	float CapVel8;
	float CapVel9;
	float CapVel10;
	float CapVel11;
	float CapVel12;
	float CapVel13;
	float CapVel14;
	float CapVel15;
	float CapVel16;
	float CapVel17;
	float CapVel18;
	float CapVel19;
	float CapVel20;
	float CapVel21;
	float CapVel22;
	float CapVel23;
	float CapVel24;
	float CapVel25;
	float CapVel26;
	float CapVel27;
	float CapVel28;
	float CapVel29;
	float CapVel30;
	float CapVel31;
	float FTRPickPlaceCMD;
	float WTRPickPlaceCMD;
	float VDF_frequency;
} ModuleMoniterAO, *PModuleMoniterAO;

#pragma pack(push,1)
typedef struct _ModuleMoniterNDO
{
	bool VFD_CS;
	bool VFD_AU;
	bool VFD_RES;
	bool VFD_MRS;
	bool VFD_RT;
	bool VFD_JOG;
	bool VFD_RL;
	bool VFD_RM;
	bool VFD_RH;
	bool VFD_STP;
	bool VFD_STR;
	bool VFD_STF;
	bool Furnace_1_zone_heating_enable;
	bool Furnace_2_zone_heating_enable;
	bool Furnace_3_zone_heating_enable;
	bool Furnace_4_zone_heating_enable;
	bool Furnace_5_zone_heating_enable;
	bool Furnace_6_zone_heating_enable;
	bool Furnace_7_zone_heating_enable;
	bool LDS1_REQUEST_Or_VALVE_OPEN;
	bool HPM_valve_out_status;
	bool Forline_heater_on;
	bool Vaccum_Pump_Both_On;
	bool Vaccum_Pump_AUC_On;
	bool Vaccum_Pump_AGV_Open;
	bool LSD2_REQUEST_Or_VALVE_OPEN;
	bool OX_PUMP_ON;
	bool Cooling_Valve1;
	bool Cooling_Valve2;
	bool AV71_AUTO_CLOSE;
	bool AV71_PUMP_ON;
	bool BALL_VALVE_OPEN_CLOSE;
	bool No1_left_Clamp_Val;
	bool Spare;
	bool No1_Right_Clamp_Val;
	bool No2_left_Val_Extended;
	bool No2_left_Val_Back;
	bool No2_left_Flow_Open;
	bool No2_Right_Val_Extended;
	bool No2_Right_Val_Back;
	bool No2_Right_Flow_Open;
	bool No3_left_Val_Extended;
	bool No3_left_Val_Back;
	bool No3_left_Flow_Open;
	bool No3_Right_Val_Extended;
	bool No3_Right_Val_Back;
	bool No3_Right_Flow_Open;
	bool Tri_Color_Light_Red;
	bool Tri_Color_Light_YE;
	bool Tri_Color_Light_GN;
	bool Tri_Color_Light_BZ;
	bool Door_Up;
	bool DOOr_Down;
	bool Stop_Light;
	bool Pause_Light;
	bool Plugging_Light;
	bool Left_Error_Rst_Light;
	bool Right_Error_Rst_Light;
	bool Left_FOUP_Detect;
	bool Left_FOUP_InPos;
	bool Left_FOUP_Load;
	bool Left_FOUP_Unload;
	bool Left_FOUP_Manual;
	bool Right_FOUP_Detect;
	bool Right_FOUP_InPos;
	bool Right_FOUP_Load;
	bool Right_FOUP_Unload;
	bool Right_FOUP_Manual;
	bool Robot_loadport_1_E84_REQ;
	bool Robot_loadport_1_E84_UREQ;
	bool Robot_loadport_1_E84_ready;
	bool Robot_loadport_1_E84_HO_AVBL;
	bool Robot_loadport_1_E84_ES;
	bool Robot_loadport_2_E84_REQ;
	bool Robot_loadport_2_E84_UREQ;
	bool Robot_loadport_2_E84_ready;
	bool Robot_loadport_2_E84_HO_AVBL;
	bool Robot_loadport2_E84_ES;
	bool Robot_loadport_2_FOUP_detect;
	bool Robot_loadport_3_FOUP_detect;
	bool Robot_loadport_4_FOUP_detect;
	bool Robot_Extend_Buffer_1_FOUP_detect;
	bool Robot_Extend_Buffer_2_FOUP_detect;
	bool Robot_POD_1_FOUP_detect;
	bool Robot_POD_2_FOUP_detect;
	bool Robot_Spare1;
	bool Robot_Spare2;
	bool Robot_Spare3;
	bool Robot_Spare4;
	bool Robot_Spare5;
	bool Robot_Spare6;
	bool Robot_Spare7;
	bool Robot_Spare8;
	bool Robot_Spare9;
	bool Robot_Spare10;
	bool Robot_Spare11;
	bool Robot_Spare12;
	bool Robot_Spare13;
	bool Robot_Spare14;
	bool Robot_Spare15;
	bool LA_internal_air_cycle_switch_1_open;
	bool LA_internal_air_cycle_switch_1_close;
	bool LA_internal_air_cycle_switch_2_open;
	bool LA_internal_air_cycle_switch_2_close;
	bool R_axis_air_cylinder_extend_switch;
	bool R_axis_air_cylinder_retract_switch;
	bool O2_detector_switch_LA_POD;
	bool O2_detector_switch_POD1_POD2;
	bool LA_internal_air_cycle_fan_1_switch;
	bool LA_internal_air_cycle_fan_2_switch;
	bool LA_internal_air_cycle_fan_3_switch;
	bool LA_internal_air_cycle_fan_4_switch;
	bool Furnace_shutter_open;
	bool Furnace_shutter_close;
	bool POD1_exhaust_switch_open;
	bool POD1_exhaust_switch_close;
	bool POD2_exhaust_switch_open;
	bool POD2_exhaust_switch_close;
	bool Buffer_A1_N2_Purge_switch;
	bool Buffer_B1_N2_Purge_switch;
	bool Buffer_C1_N2_Purge_switch;
	bool Buffer_D1_N2_Purge_switch;
	bool Buffer_A2_N2_Purge_switch;
	bool Buffer_B2_N2_Purge_switch;
	bool Buffer_C2_N2_Purge_switch;
	bool Buffer_D2_N2_Purge_switch;
	bool Buffer_A3_N2_Purge_switch;
	bool Buffer_B3_N2_Purge_switch;
	bool Buffer_C3_N2_Purge_switch;
	bool Buffer_D3_N2_Purge_switch;
	bool Buffer_A4_N2_Purge_switch;
	bool Buffer_B4_N2_Purge_switch;
	bool Buffer_C4_N2_Purge_switch;
	bool Buffer_D4_N2_Purge_switch;
	bool WaferRobotAlarmReset;
	bool WaferRobotActionHold;
	bool WaferRobotTPEnable;
	bool WaferRobotPOD1Interlock;
	bool WaferRobotPOD2Interlock;
	bool WaferRobotBoatRotaryInterlock;
	bool WaferRobotBoatBottomInterlock;
	bool Sys_PLCReset_b;
	bool Sys_BlowerSwitch_b;
	bool Sys_LightCurtainBypass_b;
	bool Sys_FFUAlarmReset_b;
	bool Sys_MINI8AlarmReset_b;
	bool Sys_VGUnitConversion_b;
	bool Sys_F2_CleanSwitch_b;
	bool Sys_APC_DATA_READ_SYSCONFIG;
	bool Sys_APC_DATA_WRITE_SYSCONFIG;
	bool Sys_APC_DATA_READ_CUSCONFIG;
	bool Sys_APC_DATA_WRITE_CUSCONFIG;
	bool Sys_HTR1_Temp_alarm;
	bool Sys_HTR2_Temp_alarm;
	bool Sys_Abnormal_seal_cap_HTR_temp;
	bool Sys_Abnormal_furnace_heater_temp;
	bool Sys_HTR3_Temp_alarm;
	bool Sys_HTR1_ON;
	bool Sys_HTR2_ON;
	bool Sys_HTR3_ON;
	bool Sys_HTR1_SW_ON;
	bool Sys_HTR2_SW_ON;
	bool Sys_HTR3_SW_ON;
	bool Sys_HF_CleanSwitch;
	bool Sys_DEPO_SW;
	bool Sys_LA_O2_Check_First_EN;
	bool Sys_FIMS1_O2_Check_EN;
	bool Sys_FIMS2_O2_Check_EN;
	bool Sys_N2_PURGE_PROCESS;
	bool FIMS1LoadCommand;
	bool FIMS1UnloadCommand;
	bool FIMS1HomeCommand;
	bool FIMS1AlarmReset;
	bool FIMS1Stop;
	bool FIMS1AutoManualCommand;
	bool FIMS1Dock;
	bool FIMS1Undock;
	bool FIMS1Seal;
	bool FIMS1Release;
	bool FIMS1DoorClose;
	bool FIMS1DoorOpen;
	bool FIMS1Latch1On;
	bool FIMS1Latch2On;
	bool FIMS1Latch1Off;
	bool FIMS1Latch2Off;
	bool FIMS1CollisionAvoidanceDown;
	bool FIMS1CollisionAvoidanceUp;
	bool FIMS1N2PurgeBypass;
	bool FIMS1N2PurgeValveOpen;
	bool FIMS1N2PurgeValveClose;
	bool FIMS1VaccumValveOpen;
	bool FIMS1VaccumValveClose;
	bool FIMS2LoadCommand;
	bool FIMS2UnloadCommand;
	bool FIMS2HomeCommand;
	bool FIMS2AlarmReset;
	bool FIMS2Stop;
	bool FIMS2AutoManualCommand;
	bool FIMS2Dock;
	bool FIMS2Undock;
	bool FIMS2Seal;
	bool FIMS2Release;
	bool FIMS2DoorClose;
	bool FIMS2DoorOpen;
	bool FIMS2Latch1On;
	bool FIMS2Latch2On;
	bool FIMS2Latch1Off;
	bool FIMS2Latch2Off;
	bool FIMS2CollisionAvoidanceDown;
	bool FIMS2CollisionAvoidanceUp;
	bool FIMS2N2PurgeBypass;
	bool FIMS2N2PurgeValveOpen;
	bool FIMS2N2PurgeValveClose;
	bool FIMS2VaccumValveOpen;
	bool FIMS2VaccumValveClose;
	bool ServoOnBufferAxis;
	bool StopBufferAxis;
	bool MoveCommandBufferAxis;
	bool ResetBufferAxis;
	bool StopBoatZAxis;
	bool MoveEnableBoatZAxis;
	bool ResetBoatZAxis;
	bool ServoOnBoatZAxis;
	bool BoatRAxisStop;
	bool BoatRAxisHomeCmd;
	bool BoatRAxisRotationCmd;
	bool BoatRAxisAlarmReset;
	bool BoatRAxisRotationForward;
	bool BoatRAxisRotationReverse;
	bool GetBoatAllow;
	bool GetBoatStart;
	bool GetBoatFinish;
	bool DP_sw;
	bool BWR_sw;
	bool DPR1_sw;
	bool DPR2_sw;
	bool WAT_R_sw;
	bool WAT_F_sw;
	bool HTR1_sw;
	bool HTR2_sw;
	bool HTR3_sw;
	bool HTR4_sw;
	bool HTR5_sw;
	bool AGV_sw;
	bool DEPO_sw;
	bool CLN_sw;
	bool T_MNT_sw;
	bool T_REF_sw;
	bool Pump1_ECO_sw;
	bool SP1_sw;
	bool PZ_sw;
	bool P_CONT_sw;
	bool DGZERO_sw;
	bool C_EXH_sw;
	bool F2_CLN_sw;
	bool F_N_sw;
	bool Furnace_Temp_abnormal;
	bool LSC_Ht_temp_abnormal;
	bool GB_Ht_temp_abnormal;
	bool EXH_Ht_temp_abnormal;
	bool CLN_Temp_abnormal;
	bool AV1;
	bool AV2;
	bool AV3;
	bool AV4;
	bool AV5;
	bool AV6;
	bool AV7;
	bool AV8;
	bool AV9;
	bool AV10;
	bool AV11;
	bool AV12;
	bool AV13;
	bool AV14;
	bool AV15;
	bool AV16;
	bool AV17;
	bool AV18;
	bool AV19;
	bool AV20;
	bool AV21;
	bool AV22;
	bool AV23;
	bool AV24;
	bool AV25;
	bool AV26;
	bool AV27;
	bool AV28;
	bool AV29;
	bool AV30;
	bool AV31;
	bool AV32;
	bool AV33;
	bool AV34;
	bool AV35;
	bool AV36;
	bool AV37;
	bool AV38;
	bool AV39;
	bool AV40;
	bool AV41;
	bool AV42;
	bool AV43;
	bool AV44;
	bool AV45;
	bool AV46;
	bool AV47;
	bool AV48;
	bool AV49;
	bool AV50;
	bool AV51;
	bool AV52;
	bool AV53;
	bool AV54;
	bool AV55;
	bool AV56;
	bool AV57;
	bool AV58;
	bool AV59;
	bool AV60;
	bool AV61;
	bool AV62;
	bool AV63;
	bool AV64;
	bool AV65Open;
	bool AV65Close;
	bool AV66;
	bool AV67;
	bool AV68;
	bool AV69;
	bool AV70;
	bool AV71;
	bool AV72;
	bool AV73;
	bool AV74;
	bool AV75;
	bool AV76;
	bool AV77;
	bool AV78;
	bool AV79Open;
	bool AV79Close;
	bool AV80;
	bool AV81;
	bool AV82;
	bool AV83;
	bool AV84;
	bool AV85;
	bool AV86;
	bool AV87;
	bool AV88;
	bool AV89;
	bool AV90;
	bool AV91Open;
	bool AV91Close;
	bool AV92;
	bool AV93;
	bool AV94;
	bool AV95;
	bool AV96;
	bool AV97;
	bool AV98;
	bool AV99;
	bool AV100;
	bool AV101;
	bool AV102;
	bool AV103;
	bool AV104;
	bool AV105;
	bool AV106;
	bool AV107;
	bool AV108;
	bool AV109;
	bool AV110;
	bool AV111;
	bool AV112;
	bool AV113;
	bool AV114;
	bool AV115;
	bool AV116;
	bool AV117;
	bool AV118;
	bool AV119;
	bool AV120;
	bool AV121;
	bool AV122;
	bool AV123;
	bool AV124;
	bool AV125;
	bool AV126;
	bool AV127;
	bool AV128;
	bool AV129;
	bool AV130;
	bool AV131;
	bool AV132;
	bool AV133;
	bool AV134;
	bool AV135;
	bool AV136;
	bool AV137;
	bool AV138;
	bool AV139;
	bool AV140;
	bool AV141;
	bool AV142;
	bool AV143;
	bool AV144;
	bool AV145;
	bool AV146;
	bool AV147;
	bool AV148;
	bool AV149;
	bool AV150;
	bool AV151;
	bool AV152;
	bool AV153;
	bool AV154;
	bool AV155;
	bool AV156;
	bool AV157;
	bool AV158;
	bool AV159;
	bool AV160;
	bool AV161;
	bool AV162;
	bool AV163;
	bool AV164;
	bool AV165;
	bool AV166;
	bool AV167;
	bool AV168;
	bool AV169;
	bool AV170;
	bool AV171;
	bool AV172;
	bool AV173;
	bool AV174;
	bool AV175;
	bool AV176;
	bool AV177;
	bool AV178;
	bool AV179;
	bool AV180;
	bool AV181;
	bool AV182;
	bool AV183;
	bool AV184;
	bool AV185;
	bool AV186;
	bool AV187;
	bool AV188;
	bool AV189;
	bool AV190;
	bool AV191;
	bool AV192;
	bool AV193;
	bool AV194;
	bool AV195;
	bool AV196;
	bool AV197;
	bool AV198;
	bool AV199;
	bool AV200;
	bool AV201;
	bool AV202Open;
	bool AV202Close;
	bool AV203;
	bool AV204;
	bool AV205;
	bool AV206;
	bool AV207;
	bool AV208;
	bool AV209;
	bool AV210;
	bool AV211;
	bool AV212;
	bool AV213;
	bool AV214;
	bool AV215;
	bool AV216;
	bool AV217;
	bool AV218;
	bool AV219;
	bool AV220;
	bool AV221;
	bool AV222;
	bool AV223;
	bool AV224;
	bool AV225;
	bool AV226;
	bool AV227;
	bool AV228;
	bool AV229;
	bool AV230;
	bool AV231;
	bool AV232;
	bool AV233;
	bool AV234;
	bool AV235;
	bool AV236;
	bool AV237;
	bool AV238;
	bool AV239;
	bool AV240;
	bool AV241;
	bool AV242;
	bool AV243;
	bool AV244;
	bool AV245;
	bool AV246;
	bool AV247;
	bool AV248;
	bool AV249;
	bool AV250;
	bool DataLoad;
	bool DataSend;
} ModuleMoniterNDO, *PModuleMoniterNDO;
#pragma pack(pop)

#pragma pack(push,1)
typedef struct _ModuleMoniterSDO
{
	bool HPM_valve_power_on_off;
	bool Furnace_power_on;
	bool Cap_heater_enable;
	bool AC100V_transformer_power_on;
	bool VFD_Enable;
	bool Blower_power_on;
	bool Buffer_motor_enable1;
	bool Buffer_motor_enable2;
	bool E_axis_motor_enable2;
	bool E_axis_motor_enable1;
	bool FTR_enable1;
	bool FTR_enable2;
	bool WTR_enable1;
	bool FTR_interlock_reset;
	bool WTR_enable2;
	bool WTR_interlock_reset;
	bool R_axis_motor_enable2;
	bool R_axis_motor_enable1;
	bool Light_curtain_idle;
	bool Frontbody_interlock_indicator;
	bool GasBox_interlock_indicator;
} ModuleMoniterSDO, *PModuleMoniterSDO;
#pragma pack(pop)

///</AutoGeneratedContent>



///<AutoGeneratedContent id="DataAreaIDs">
#define ADI_MainInputs 0
#define ADI_MainOutputs 1
#define ADI_ModuleMoniterAI 0
#define ADI_ModuleMoniterNDI 1
#define ADI_ModuleMoniterSDI 2
#define ADI_ModuleMoniterAO 3
#define ADI_ModuleMoniterNDO 4
#define ADI_ModuleMoniterSDO 5
///</AutoGeneratedContent>

///<AutoGeneratedContent id="InterfaceIDs">
#if !defined(_TC_IID_03010099_0000_0000_E000_000000000064_INCLUDED_)
#define _TC_IID_03010099_0000_0000_E000_000000000064_INCLUDED_
TCOM_DECL_INTERFACE("03010099-0000-0000-e000-000000000064", ITcIoTcpProtocolRecv)
#endif // !defined(_TC_IID_03010099_0000_0000_E000_000000000064_INCLUDED_)

#if !defined(_TC_IID_03010098_0000_0000_E000_000000000064_INCLUDED_)
#define _TC_IID_03010098_0000_0000_E000_000000000064_INCLUDED_
TCOM_DECL_INTERFACE("03010098-0000-0000-e000-000000000064", ITcIoTcpProtocol)
#endif // !defined(_TC_IID_03010098_0000_0000_E000_000000000064_INCLUDED_)

///</AutoGeneratedContent>

///<AutoGeneratedContent id="EventClasses">
///</AutoGeneratedContent>
