//
//common.h
//
#ifndef _COMMON_H_
#define _COMMON_H_

#include<stdio.h>
#include<stdlib.h>
#include "TcDef.h"
#include "TcServices.h"
#include "Ads.h"
#include "AdsLog.h"
#include "TcBaseInterfaces.h"
#include<string>
#include<vector>
#include<map>
#include"TcInterfaces.h"
#include<queue>
#include "TlvSession.h"
#include "FurancePMCInterfaces.h"

using namespace std;

typedef enum class RecipeExecStateValue
{
	UnknowExecState = 0,
	Execteing = 1,
	ParseParam = 2,
	ExecError = 3
} RecipeExecStateValue;

typedef enum class SystemStatus
{
	UnknowSysState = 0,
	Run = 1,
	Abort = 2,
	SysError = 3

} SystemStatus;

extern CTcTrace * LOG;



//ݻ
extern TlvSession AllDataSession; //TcpպͷݵSession

extern SystemStatus SST;

extern RecipeExecStateValue RecipeExecState;
extern LONGLONG sysTime;

class Common
{
public:
	Common();
	~Common();
	int Testvalue = 0;

	void test();
	void TestSend();

	void ParseAllData();
	
	void ParseAllDataSession();
	/***************************************************************
	 * @brief СֽbyteתΪֽ
	 * @param data byte飨С˸ʽ
	 * @param length 鳤
	 ***************************************************************/
	void ConvertLittleEndianToBigEndian(uint8_t* data, size_t length) 
	{
		for (size_t i = 0; i < length / 2; ++i) {
			std::swap(data[i], data[length - 1 - i]);
		}
	}

	/*****************************************************************
	 * @brief ذ汾ֱӴstd::vector<uint8_t>
	 * @param data byte飨С˸ʽ
	 *****************************************************************/
	void ConvertLittleEndianToBigEndian(std::vector<uint8_t>& data) 
	{
		ConvertLittleEndianToBigEndian(data.data(), data.size());
	}


private:

};

typedef enum DeviceTypeEnum
{
    UnknowType,
    APC,
    AUX,
    Axis,
    FFU,
    Heater,
    MFC,
    Shutter,
    Valve,
    PressureMeter,
    SingaLight,
    HeaterBand
} DeviceTypeEnum;

struct RecipeRunState
{
public:
	RecipeExecStateValue RecipeExecState;

};

struct alignas(4) MyStruct
{
public:
    int SendProperty;
    int SendValue;
    int SendValue2;
};

struct alignas(4) MyStructSend
{
public:
	int RcvProperty;
	int RcvValue;

};

struct PMCSystemState
{
public:
	SystemStatus PMCST;
};



template <typename T>
class BytesToStruct {
public:
	static T* FromBytes(const uint8_t* bytes, size_t size1) 
	{
		// ȷĿΪPODҴСƥ
		//static_assert(std::is_pod<T>::value, "T must be a POD type");
		//static_assert(sizeof(T) == size1, "Size mismatch between T and byte array");

		//LOG->Log(tlInfo, "sizeof(T) = '%d' ,size1 = '%d'", sizeof(T), size1);
		static T obj;
		std::memcpy(&obj, bytes, size1); // ֱڴ濽
		return &obj;
	}
};


template <typename T>
class StructToBytes {
public:
	static std::vector<uint8_t> ToBytes(const T& obj) 
	{
		//// ȷĿΪPOD
		//static_assert(std::is_pod<T>::value, "T must be a POD type");
		std::vector<uint8_t> bytes(sizeof(T));
		std::memcpy(bytes.data(), &obj, sizeof(T)); // ֱڴ濽
		return bytes;
	}
};

#endif