#ifndef __BOATMODULE_H__
#define __BOATMODULE_H__
#include"TriggerStatus.h"
#include"Fields.h"
#include"pmc_types.h"
#include "IoFurnaceMotor.h"
#include "IoShutter.h"
#include "OP.h"

#define SERVO_MOVE_CAP2     1
#define SERVO_MOVE_CAP     2
#define SERVO_MOVE_HOME     3
#define SERVO_MOVE_POSITION(n) n
typedef enum class _BoatRotateDirection { CW, CCW } BoatRotateDirection;

typedef enum class _BoatStatusEnum{Init,Idle,Elevating,Rotating,Moving,Error}BoatStatusEnum;
typedef TriggerStatus<BoatStatusEnum> BoatStatus;
class BoatModule {
public:
	char name[MAX_NAME_LEN];
	//״̬
	BoatStatus status = BoatStatusEnum::Init;
public:
	//豸
	IoFurnaceMotor *boatElevator=NULL;
	IoFurnaceMotor* boatRotation=NULL;
	IoShutter* shutter=NULL;
private:
	//
	OperatorNode* opNode=NULL;
	OperatorNode* lastOpNode=NULL;//һδɵĶ֮
public:
	void initialize();	
	void subscribe();
public:
	//ΪOP׼Ĺ
	PMCBOOL checkPrepareMove();
	PMCBOOL autoShutterOpen(PMCBOOL shutterOpen);
	PMCBOOL checkAutoShutterOpen(PMCBOOL shutterOpen);
	PMCBOOL setBoatZAxisMove(int position);
	PMCBOOL setBoatRAxisMove(BoatRotateDirection direction);
	OperatorStatusEnum checkBoatZAxisMove(int position);
	OperatorStatusEnum checkBoatRAxisMove(BoatRotateDirection direction);
	void stopElevating();
	void stopRotating();
};
extern BoatModule* boatModule;
#endif